/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.spi2jcr;

import java.util.Map;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.spi.RepositoryService;
import org.apache.jackrabbit.spi.RepositoryServiceFactory;
import org.apache.jackrabbit.spi2jcr.BatchReadConfig;
import org.apache.jackrabbit.spi2jcr.RepositoryServiceImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Spi2jcrRepositoryServiceFactory
implements RepositoryServiceFactory {
    public static final String PARAM_REPOSITORY = "org.apache.jackrabbit.spi2jcr.Repository";
    public static final String PARAM_BATCH_READ_CONFIG = "org.apache.jackrabbit.spi2jcr.BatchReadConfig";
    public static final String PARAM_ITEMINFO_CACHE_SIZE = "org.apache.jackrabbit.spi2jcr.ItemInfoCacheSize";

    public RepositoryService createRepositoryService(Map<?, ?> parameters) throws RepositoryException {
        if (parameters == null) {
            throw new RepositoryException("Parameter org.apache.jackrabbit.spi2jcr.Repository missing");
        }
        Object repo = parameters.get(PARAM_REPOSITORY);
        if (repo == null || !(repo instanceof Repository)) {
            throw new RepositoryException("Parameter org.apache.jackrabbit.spi2jcr.Repository missing or not an instance of Repository");
        }
        Object obj = parameters.get(PARAM_BATCH_READ_CONFIG);
        BatchReadConfig brConfig = obj != null && obj instanceof BatchReadConfig ? (BatchReadConfig)obj : new BatchReadConfig();
        int itemInfoCacheSize = 5000;
        Object param = parameters.get(PARAM_ITEMINFO_CACHE_SIZE);
        if (param != null) {
            try {
                itemInfoCacheSize = Integer.parseInt(param.toString());
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return new RepositoryServiceImpl((Repository)repo, brConfig, itemInfoCacheSize);
    }
}

