/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.spi2jcr;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import javax.jcr.observation.ObservationManager;
import org.apache.jackrabbit.spi.Event;
import org.apache.jackrabbit.spi.EventBundle;
import org.apache.jackrabbit.spi.EventFilter;
import org.apache.jackrabbit.spi.IdFactory;
import org.apache.jackrabbit.spi.QValueFactory;
import org.apache.jackrabbit.spi.Subscription;
import org.apache.jackrabbit.spi.commons.EventBundleImpl;
import org.apache.jackrabbit.spi.commons.EventFilterImpl;
import org.apache.jackrabbit.spi2jcr.EventFactory;
import org.apache.jackrabbit.spi2jcr.SessionInfoImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EventSubscription
implements Subscription,
EventListener {
    private static final Logger log = LoggerFactory.getLogger(EventSubscription.class);
    static final int ALL_EVENTS = 127;
    private final List<EventBundle> eventBundles = new ArrayList<EventBundle>();
    private final SessionInfoImpl sessionInfo;
    private volatile List<EventFilter> filters;
    private volatile boolean disposed = false;
    private final EventFactory eventFactory;

    EventSubscription(IdFactory idFactory, QValueFactory qValueFactory, SessionInfoImpl sessionInfo, EventFilter[] filters) throws RepositoryException {
        this.sessionInfo = sessionInfo;
        this.eventFactory = new EventFactory(sessionInfo.getSession(), sessionInfo.getNamePathResolver(), idFactory, qValueFactory);
        this.setFilters(filters);
        ObservationManager obsMgr = sessionInfo.getSession().getWorkspace().getObservationManager();
        obsMgr.addEventListener((EventListener)this, 127, "/", true, null, null, true);
    }

    void setFilters(EventFilter[] filters) throws RepositoryException {
        for (EventFilter filter : filters) {
            if (filter instanceof EventFilterImpl) continue;
            throw new RepositoryException("Unknown filter implementation");
        }
        ArrayList<EventFilter> tmp = new ArrayList<EventFilter>(Arrays.asList(filters));
        this.filters = Collections.unmodifiableList(tmp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispose() throws RepositoryException {
        this.sessionInfo.removeSubscription(this);
        this.sessionInfo.getSession().getWorkspace().getObservationManager().removeEventListener((EventListener)this);
        this.disposed = true;
        List<EventBundle> list = this.eventBundles;
        synchronized (list) {
            this.eventBundles.notify();
        }
    }

    public void onEvent(EventIterator events) {
        this.createEventBundle(events, false);
    }

    EventListener getLocalEventListener() {
        return new EventListener(){

            public void onEvent(EventIterator events) {
                EventSubscription.this.createEventBundle(events, true);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    EventBundle[] getEventBundles(long timeout) {
        EventBundle[] bundles;
        List<EventBundle> list = this.eventBundles;
        synchronized (list) {
            if (this.eventBundles.isEmpty()) {
                try {
                    this.eventBundles.wait(timeout);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            bundles = this.eventBundles.toArray(new EventBundle[this.eventBundles.size()]);
            this.eventBundles.clear();
        }
        EventFilter[] eventFilters = this.filters.toArray(new EventFilter[this.filters.size()]);
        for (int i = 0; i < bundles.length; ++i) {
            ArrayList<Event> filteredEvents = new ArrayList<Event>();
            Iterator it = bundles[i].getEvents();
            block6: while (it.hasNext()) {
                Event e = (Event)it.next();
                if (eventFilters == null || eventFilters.length == 0) {
                    filteredEvents.add(e);
                    continue;
                }
                for (EventFilter eventFilter : eventFilters) {
                    if (!eventFilter.accept(e, bundles[i].isLocal())) continue;
                    filteredEvents.add(e);
                    continue block6;
                }
            }
            bundles[i] = new EventBundleImpl(filteredEvents, bundles[i].isLocal());
        }
        return bundles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createEventBundle(EventIterator events, boolean isLocal) {
        if (this.disposed) {
            return;
        }
        ArrayList<Event> spiEvents = new ArrayList<Event>();
        while (events.hasNext()) {
            try {
                Event spiEvent = this.eventFactory.fromJCREvent(events.nextEvent());
                spiEvents.add(spiEvent);
            }
            catch (Exception ex) {
                log.warn("Unable to create SPI Event: " + ex);
            }
        }
        EventBundleImpl bundle = new EventBundleImpl(spiEvents, isLocal);
        List<EventBundle> list = this.eventBundles;
        synchronized (list) {
            this.eventBundles.add((EventBundle)bundle);
            this.eventBundles.notify();
        }
    }
}

