/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.glance.v1_0.domain;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import java.beans.ConstructorProperties;
import java.util.Set;
import javax.inject.Named;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.openstack.glance.v1_0.domain.ContainerFormat;
import org.jclouds.openstack.glance.v1_0.domain.DiskFormat;
import org.jclouds.openstack.v2_0.domain.Link;
import org.jclouds.openstack.v2_0.domain.Resource;

public class Image
extends Resource {
    @Named(value="container_format")
    private final Optional<ContainerFormat> containerFormat;
    @Named(value="disk_format")
    private final Optional<DiskFormat> diskFormat;
    private final Optional<Long> size;
    private final Optional<String> checksum;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromImage(this);
    }

    @ConstructorProperties(value={"id", "name", "links", "container_format", "disk_format", "size", "checksum"})
    protected Image(String id, @Nullable String name, Set<Link> links, @Nullable ContainerFormat containerFormat, @Nullable DiskFormat diskFormat, @Nullable Long size, @Nullable String checksum) {
        super(id, name, links);
        this.containerFormat = Optional.fromNullable((Object)((Object)containerFormat));
        this.diskFormat = Optional.fromNullable((Object)((Object)diskFormat));
        this.size = Optional.fromNullable((Object)size);
        this.checksum = Optional.fromNullable((Object)checksum);
    }

    public Optional<ContainerFormat> getContainerFormat() {
        return this.containerFormat;
    }

    public Optional<DiskFormat> getDiskFormat() {
        return this.diskFormat;
    }

    public Optional<Long> getSize() {
        return this.size;
    }

    public Optional<String> getChecksum() {
        return this.checksum;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.containerFormat, this.diskFormat, this.size, this.checksum});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        Image that = (Image)((Object)Image.class.cast(obj));
        return super.equals((Object)that) && Objects.equal(this.containerFormat, that.containerFormat) && Objects.equal(this.diskFormat, that.diskFormat) && Objects.equal(this.size, that.size) && Objects.equal(this.checksum, that.checksum);
    }

    protected Objects.ToStringHelper string() {
        return super.string().add("containerFormat", this.containerFormat).add("diskFormat", this.diskFormat).add("size", this.size).add("checksum", this.checksum);
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>>
    extends Resource.Builder<T> {
        protected ContainerFormat containerFormat;
        protected DiskFormat diskFormat;
        protected Long size;
        protected String checksum;

        public T containerFormat(ContainerFormat containerFormat) {
            this.containerFormat = containerFormat;
            return (T)((Object)((Builder)this.self()));
        }

        public T diskFormat(DiskFormat diskFormat) {
            this.diskFormat = diskFormat;
            return (T)((Object)((Builder)this.self()));
        }

        public T size(Long size) {
            this.size = size;
            return (T)((Object)((Builder)this.self()));
        }

        public T checksum(String checksum) {
            this.checksum = checksum;
            return (T)((Object)((Builder)this.self()));
        }

        public Image build() {
            return new Image(this.id, this.name, this.links, this.containerFormat, this.diskFormat, this.size, this.checksum);
        }

        public T fromImage(Image in) {
            return ((Builder)((Object)((Builder)((Object)((Builder)((Object)((Builder)super.fromResource((Resource)in)).containerFormat((ContainerFormat)((Object)in.getContainerFormat().orNull())))).diskFormat((DiskFormat)((Object)in.getDiskFormat().orNull())))).size((Long)in.getSize().orNull()))).checksum((String)in.getChecksum().orNull());
        }
    }

    public static enum Status {
        UNRECOGNIZED,
        ACTIVE,
        SAVING,
        QUEUED,
        KILLED,
        PENDING_DELETE,
        DELETED;


        public String value() {
            return this.name();
        }

        public static Status fromValue(String v) {
            try {
                return Status.valueOf(v.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }
}

