/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.glance.v1_0.options;

import com.google.common.base.Preconditions;
import java.util.Date;
import org.jclouds.openstack.glance.v1_0.domain.ContainerFormat;
import org.jclouds.openstack.glance.v1_0.domain.DiskFormat;
import org.jclouds.openstack.glance.v1_0.domain.Image;
import org.jclouds.openstack.glance.v1_0.options.ImageField;
import org.jclouds.openstack.v2_0.options.PaginationOptions;

public class ListImageOptions
extends PaginationOptions {
    public static final ListImageOptions NONE = new ListImageOptions();

    public ListImageOptions changesSince(Date ifModifiedSince) {
        this.queryParameters.put((Object)"changes-since", (Object)(((Date)Preconditions.checkNotNull((Object)ifModifiedSince, (Object)"modification date should not be null")).getTime() / 1000L + ""));
        return this;
    }

    public ListImageOptions marker(String marker) {
        return (ListImageOptions)((Object)ListImageOptions.class.cast(super.marker(marker)));
    }

    public ListImageOptions limit(int limit) {
        return (ListImageOptions)((Object)ListImageOptions.class.cast(super.limit(limit)));
    }

    public ListImageOptions name(String name) {
        this.queryParameters.put((Object)ImageField.NAME.asParam(), (Object)name);
        return this;
    }

    public ListImageOptions status(Image.Status status) {
        this.queryParameters.put((Object)ImageField.STATUS.asParam(), (Object)status.toString());
        return this;
    }

    public ListImageOptions containerFormat(ContainerFormat containerFormat) {
        this.queryParameters.put((Object)ImageField.CONTAINER_FORMAT.asParam(), (Object)containerFormat.toString());
        return this;
    }

    public ListImageOptions diskFormat(DiskFormat diskFormat) {
        this.queryParameters.put((Object)ImageField.DISK_FORMAT.asParam(), (Object)diskFormat.toString());
        return this;
    }

    public ListImageOptions minRam(long ram) {
        this.queryParameters.put((Object)ImageField.MIN_RAM.asParam(), (Object)Long.toString(ram));
        return this;
    }

    public ListImageOptions minDisk(long disk) {
        this.queryParameters.put((Object)ImageField.MIN_DISK.asParam(), (Object)Long.toString(disk));
        return this;
    }

    public ListImageOptions minSize(long size) {
        this.queryParameters.put((Object)ImageField.SIZE_MIN.asParam(), (Object)Long.toString(size));
        return this;
    }

    public ListImageOptions maxSize(long size) {
        this.queryParameters.put((Object)ImageField.SIZE_MAX.asParam(), (Object)Long.toString(size));
        return this;
    }

    public ListImageOptions isPublic(boolean isPublic) {
        this.queryParameters.put((Object)ImageField.IS_PUBLIC.asParam(), (Object)Boolean.toString(isPublic));
        return this;
    }

    public ListImageOptions isProtected(boolean isProtected) {
        this.queryParameters.put((Object)ImageField.PROTECTED.asParam(), (Object)Boolean.toString(isProtected));
        return this;
    }

    public ListImageOptions sortBy(ImageField key) {
        this.queryParameters.put((Object)"sort_key", (Object)key.asParam());
        return this;
    }

    public ListImageOptions sortAscending() {
        this.queryParameters.put((Object)"sort_dir", (Object)"asc");
        return this;
    }

    public static class Builder {
        public static ListImageOptions name(String name) {
            return new ListImageOptions().name(name);
        }

        public static ListImageOptions diskFormat(DiskFormat diskFormat) {
            return new ListImageOptions().diskFormat(diskFormat);
        }

        public static ListImageOptions containerFormat(ContainerFormat containerFormat) {
            return new ListImageOptions().containerFormat(containerFormat);
        }

        public static ListImageOptions minRam(long size) {
            return new ListImageOptions().minRam(size);
        }

        public static ListImageOptions minDisk(long size) {
            return new ListImageOptions().minDisk(size);
        }

        public static ListImageOptions minSize(long size) {
            return new ListImageOptions().minSize(size);
        }

        public static ListImageOptions maxSize(long size) {
            return new ListImageOptions().maxSize(size);
        }

        public static ListImageOptions status(Image.Status status) {
            return new ListImageOptions().status(status);
        }

        public static ListImageOptions sortBy(ImageField sortKey) {
            return new ListImageOptions().sortBy(sortKey);
        }

        public static ListImageOptions sortAscending() {
            return new ListImageOptions().sortAscending();
        }

        public static ListImageOptions isPublic(boolean isPublic) {
            return (ListImageOptions)((Object)ListImageOptions.class.cast((Object)new ListImageOptions().isPublic(isPublic)));
        }

        public static ListImageOptions isProtected(boolean isProtected) {
            return (ListImageOptions)((Object)ListImageOptions.class.cast((Object)new ListImageOptions().isProtected(isProtected)));
        }

        public static ListImageOptions limit(int limit) {
            return new ListImageOptions().limit(limit);
        }

        public static ListImageOptions marker(String marker) {
            return new ListImageOptions().marker(marker);
        }
    }
}

