/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.neutron.v2.domain;

import com.google.common.base.Objects;
import java.beans.ConstructorProperties;
import javax.inject.Named;
import org.jclouds.javax.annotation.Nullable;

public class ExtraDhcpOption {
    protected final String id;
    @Named(value="opt_name")
    protected final String optionName;
    @Named(value="opt_value")
    protected final String optionValue;

    @ConstructorProperties(value={"id", "opt_name", "opt_value"})
    protected ExtraDhcpOption(String id, String optionName, String optionValue) {
        this.id = id;
        this.optionName = optionName;
        this.optionValue = optionValue;
    }

    @Nullable
    public String getId() {
        return this.id;
    }

    @Nullable
    public String getOptionName() {
        return this.optionName;
    }

    @Nullable
    public String getOptionValue() {
        return this.optionValue;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.optionName, this.optionValue});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ExtraDhcpOption that = (ExtraDhcpOption)ExtraDhcpOption.class.cast(obj);
        return Objects.equal((Object)this.id, (Object)that.id) && Objects.equal((Object)this.optionName, (Object)that.optionName) && Objects.equal((Object)this.optionValue, (Object)that.optionValue);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((Object)this).add("id", (Object)this.id).add("optionName", (Object)this.optionName).add("optionValue", (Object)this.optionValue);
    }

    public String toString() {
        return this.string().toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().fromExtraDhcpOption(this);
    }

    public static class Builder {
        protected String id;
        protected String optionName;
        protected String optionValue;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder optionName(String optionName) {
            this.optionName = optionName;
            return this;
        }

        public Builder optionValue(String optionValue) {
            this.optionValue = optionValue;
            return this;
        }

        public ExtraDhcpOption build() {
            return new ExtraDhcpOption(this.id, this.optionName, this.optionValue);
        }

        public Builder fromExtraDhcpOption(ExtraDhcpOption in) {
            return this.id(in.getId()).optionName(in.getOptionName()).optionValue(in.getOptionValue());
        }
    }
}

