/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.neutron.v2.domain;

import com.google.common.base.Objects;
import java.beans.ConstructorProperties;
import javax.inject.Named;
import org.jclouds.javax.annotation.Nullable;

public class HostRoute {
    @Named(value="destination")
    private final String destinationCidr;
    @Named(value="nexthop")
    private final String nextHop;

    @ConstructorProperties(value={"destination", "nexthop"})
    protected HostRoute(String destinationCidr, String nextHop) {
        this.destinationCidr = destinationCidr;
        this.nextHop = nextHop;
    }

    @Nullable
    public String getDestinationCidr() {
        return this.destinationCidr;
    }

    @Nullable
    public String getNextHop() {
        return this.nextHop;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.destinationCidr, this.nextHop});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        HostRoute that = (HostRoute)HostRoute.class.cast(obj);
        return Objects.equal((Object)this.destinationCidr, (Object)that.destinationCidr) && Objects.equal((Object)this.nextHop, (Object)that.nextHop);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((Object)this).add("destinationCidr", (Object)this.destinationCidr).add("nextHop", (Object)this.nextHop);
    }

    public String toString() {
        return this.string().toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().fromHostRoute(this);
    }

    public static class Builder {
        protected String destinationCidr;
        protected String nextHop;

        public Builder destinationCidr(String destinationCidr) {
            this.destinationCidr = destinationCidr;
            return this;
        }

        public Builder nextHop(String nextHop) {
            this.nextHop = nextHop;
            return this;
        }

        public HostRoute build() {
            return new HostRoute(this.destinationCidr, this.nextHop);
        }

        public Builder fromHostRoute(HostRoute in) {
            return this.destinationCidr(in.getDestinationCidr()).nextHop(in.getNextHop());
        }
    }
}

