/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.neutron.v2.domain.lbaas.v1;

import com.google.common.base.Objects;
import java.beans.ConstructorProperties;
import javax.inject.Named;
import org.jclouds.javax.annotation.Nullable;

public class SessionPersistence {
    protected final Type type;
    @Named(value="cookie_name")
    protected final String cookieName;

    @ConstructorProperties(value={"type", "cookie_name"})
    protected SessionPersistence(Type type, String cookieName) {
        this.type = type;
        this.cookieName = cookieName;
    }

    @Nullable
    public Type getType() {
        return this.type;
    }

    @Nullable
    public String getCookieName() {
        return this.cookieName;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.type, this.cookieName});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SessionPersistence that = (SessionPersistence)SessionPersistence.class.cast(obj);
        return Objects.equal((Object)((Object)this.type), (Object)((Object)that.type)) && Objects.equal((Object)this.cookieName, (Object)that.cookieName);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((Object)this).add("type", (Object)this.type).add("cookieName", (Object)this.cookieName);
    }

    public String toString() {
        return this.string().toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum Type {
        SOURCE_IP("SOURCE_IP"),
        HTTP_COOKIE("HTTP_COOKIE"),
        APP_COOKIE("APP_COOKIE"),
        UNRECOGNIZED("unrecognized");

        private String name;

        private Type(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public static Type fromValue(String name) {
            if (name != null) {
                for (Type value : Type.values()) {
                    if (!name.equalsIgnoreCase(value.name)) continue;
                    return value;
                }
                return UNRECOGNIZED;
            }
            return null;
        }
    }

    public static class Builder {
        protected Type type;
        protected String cookieName;

        public Builder type(Type type) {
            this.type = type;
            return this;
        }

        public Builder cookieName(String cookieName) {
            this.cookieName = cookieName;
            return this;
        }

        public SessionPersistence build() {
            return new SessionPersistence(this.type, this.cookieName);
        }
    }
}

