/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFWriter;
import com.hp.hpl.jena.sparql.util.Convert;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.openjena.atlas.lib.MultiMap;
import org.openjena.riot.ContentType;
import org.openjena.riot.Lang;
import org.openjena.riot.RiotException;

public class FusekiLib {
    private static Model dummy = ModelFactory.createDefaultModel();
    private static Map<String, Lang> mapContentTypeToLang = new HashMap<String, Lang>();
    private static Map<Lang, String> mapLangToWriterName;

    public static Lang langFromContentType(String mimeType) {
        if (mimeType == null) {
            return null;
        }
        return mapContentTypeToLang.get(mimeType.toLowerCase());
    }

    public static ContentType contentType(HttpServletRequest request) {
        return ContentType.parse((String)request.getHeader("Content-Type"));
    }

    public static RDFWriter chooseWriter(Lang lang) {
        String name;
        if (lang == null) {
            lang = Lang.RDFXML;
        }
        if ((name = mapLangToWriterName.get(lang)) == null) {
            throw new RiotException("Not a triples language: " + lang);
        }
        return dummy.getWriter(name);
    }

    static String fmtRequest(HttpServletRequest request) {
        StringBuffer sbuff = new StringBuffer();
        sbuff.append(request.getMethod());
        sbuff.append(" ");
        sbuff.append(Convert.decWWWForm((StringBuffer)request.getRequestURL()));
        String qs = request.getQueryString();
        if (qs != null) {
            String tmp = request.getQueryString();
            tmp = Convert.decWWWForm((String)tmp);
            tmp = tmp.replace('\n', ' ');
            tmp = tmp.replace('\r', ' ');
            sbuff.append("?").append(tmp);
        }
        return sbuff.toString();
    }

    public static MultiMap<String, String> parseQueryString(HttpServletRequest req) {
        MultiMap map = MultiMap.createMapList();
        if (req.getQueryString() != null) {
            String[] params = req.getQueryString().split("&");
            for (int i = 0; i < params.length; ++i) {
                String p = params[i];
                String[] x = p.split("=", 2);
                String name = null;
                String value = null;
                if (x.length == 0) {
                    name = p;
                    value = "";
                } else if (x.length == 1) {
                    name = x[0];
                    value = "";
                } else {
                    name = x[0];
                    value = x[1];
                }
                map.put((Object)name, (Object)value);
            }
        }
        return map;
    }

    static {
        mapContentTypeToLang.put("application/rdf+xml", Lang.RDFXML);
        mapContentTypeToLang.put("text/turtle", Lang.TURTLE);
        mapContentTypeToLang.put("application/turtle", Lang.TURTLE);
        mapContentTypeToLang.put("application/x-turtle", Lang.TURTLE);
        mapContentTypeToLang.put("text/plain", Lang.NTRIPLES);
        mapContentTypeToLang.put("application/n-triples", Lang.NTRIPLES);
        mapLangToWriterName = new HashMap<Lang, String>();
        mapLangToWriterName.put(Lang.N3, "N3");
        mapLangToWriterName.put(Lang.TURTLE, "TURTLE");
        mapLangToWriterName.put(Lang.NTRIPLES, "N-TRIPLES");
        mapLangToWriterName.put(Lang.RDFXML, "RDF/XML");
    }
}

