/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.http;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.sparql.graph.GraphFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.FusekiException;
import org.apache.jena.fuseki.FusekiLib;
import org.apache.jena.fuseki.FusekiNotFoundException;
import org.apache.jena.fuseki.FusekiRequestException;
import org.apache.jena.fuseki.http.DatasetGraphAccessor;
import org.apache.jena.fuseki.http.HttpSC;
import org.apache.jena.fuseki.migrate.UnmodifiableGraph;
import org.openjena.atlas.io.IO;
import org.openjena.atlas.lib.Sink;
import org.openjena.atlas.logging.Log;
import org.openjena.atlas.web.TypedInputStream;
import org.openjena.riot.Lang;
import org.openjena.riot.RiotReader;
import org.openjena.riot.lang.LangRDFXML;
import org.openjena.riot.lang.SinkTriplesToGraph;

public class DatasetGraphAccessorHTTP
implements DatasetGraphAccessor {
    private final String remote;
    static final String paramGraph = "graph";
    static final String paramDefault = "default";
    private static HttpParams httpParams = DatasetGraphAccessorHTTP.createHttpParams();

    public DatasetGraphAccessorHTTP(String remote) {
        this.remote = remote;
    }

    @Override
    public Graph httpGet() {
        return this.doGet(this.targetDefault());
    }

    @Override
    public Graph httpGet(Node graphName) {
        return this.doGet(this.target(graphName));
    }

    private Graph doGet(String url) {
        HttpGet httpGet = new HttpGet(url);
        try {
            return this.exec(url, null, (HttpUriRequest)httpGet, true);
        }
        catch (FusekiNotFoundException ex) {
            return null;
        }
    }

    @Override
    public boolean httpHead() {
        return this.doHead(this.targetDefault());
    }

    @Override
    public boolean httpHead(Node graphName) {
        return this.doHead(this.target(graphName));
    }

    private boolean doHead(String url) {
        HttpHead httpHead = new HttpHead(url);
        try {
            this.exec(url, null, (HttpUriRequest)httpHead, false);
            return true;
        }
        catch (FusekiRequestException ex) {
            if (ex.getStatusCode() == 404) {
                return false;
            }
            throw ex;
        }
    }

    @Override
    public void httpPut(Graph data) {
        this.doPut(this.targetDefault(), data);
    }

    @Override
    public void httpPut(Node graphName, Graph data) {
        this.doPut(this.target(graphName), data);
    }

    private void doPut(String url, Graph data) {
        HttpPut httpPut = new HttpPut(url);
        this.exec(url, data, (HttpUriRequest)httpPut, false);
    }

    @Override
    public void httpDelete() {
        this.doDelete(this.targetDefault());
    }

    @Override
    public void httpDelete(Node graphName) {
        this.doDelete(this.target(graphName));
    }

    private boolean doDelete(String url) {
        try {
            HttpDelete httpDelete = new HttpDelete(url);
            this.exec(url, null, (HttpUriRequest)httpDelete, false);
            return true;
        }
        catch (FusekiNotFoundException ex) {
            return false;
        }
    }

    @Override
    public void httpPost(Graph data) {
        this.doPost(this.targetDefault(), data);
    }

    @Override
    public void httpPost(Node graphName, Graph data) {
        this.doPost(this.target(graphName), data);
    }

    private void doPost(String url, Graph data) {
        HttpPost httpPost = new HttpPost(url);
        this.exec(url, data, (HttpUriRequest)httpPost, false);
    }

    @Override
    public void httpPatch(Graph data) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void httpPatch(Node graphName, Graph data) {
        throw new UnsupportedOperationException();
    }

    private String targetDefault() {
        return this.remote + "?" + paramDefault + "=";
    }

    private String target(Node name) {
        if (!name.isURI()) {
            throw new FusekiException("Not a URI: " + name);
        }
        return this.remote + "?" + paramGraph + "=" + name.getURI();
    }

    private static HttpParams createHttpParams() {
        BasicHttpParams httpParams$ = new BasicHttpParams();
        HttpProtocolParams.setVersion((HttpParams)httpParams$, (ProtocolVersion)HttpVersion.HTTP_1_1);
        HttpProtocolParams.setContentCharset((HttpParams)httpParams$, (String)"ISO-8859-1");
        HttpProtocolParams.setUseExpectContinue((HttpParams)httpParams$, (boolean)true);
        HttpConnectionParams.setTcpNoDelay((HttpParams)httpParams$, (boolean)true);
        HttpConnectionParams.setSocketBufferSize((HttpParams)httpParams$, (int)32768);
        HttpProtocolParams.setUserAgent((HttpParams)httpParams$, (String)("Fuseki/" + Fuseki.VERSION));
        return httpParams$;
    }

    private static String getHeader(HttpResponse response, String headerName) {
        Header h = response.getLastHeader(headerName);
        if (h == null) {
            return null;
        }
        return h.getValue();
    }

    private Graph exec(String targetStr, Graph graphToSend, HttpUriRequest httpRequest, boolean processBody) {
        InputStreamEntity entity;
        DefaultHttpClient httpclient = new DefaultHttpClient(httpParams);
        if (graphToSend != null) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            Model model = ModelFactory.createModelForGraph((Graph)graphToSend);
            model.write((OutputStream)out, "RDF/XML");
            byte[] bytes = out.toByteArray();
            ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
            InputStreamEntity reqEntity = new InputStreamEntity((InputStream)in, (long)bytes.length);
            reqEntity.setContentType("application/rdf+xml");
            reqEntity.setContentEncoding("UTF-8");
            entity = reqEntity;
            ((HttpEntityEnclosingRequestBase)httpRequest).setEntity((HttpEntity)entity);
        }
        TypedInputStream ts = null;
        try {
            HttpEntity entity2;
            HttpResponse response = httpclient.execute(httpRequest);
            int responseCode = response.getStatusLine().getStatusCode();
            String responseMessage = response.getStatusLine().getReasonPhrase();
            if (HttpSC.isRedirection(responseCode)) {
                throw FusekiRequestException.create(responseCode, responseMessage);
            }
            if (HttpSC.isClientError(responseCode) || HttpSC.isServerError(responseCode)) {
                throw FusekiRequestException.create(responseCode, responseMessage);
            }
            if (responseCode == 204) {
                return null;
            }
            if (responseCode == 201) {
                return null;
            }
            if (responseCode != 200) {
                Log.warn((Object)this, (String)"Unexpected status code");
                throw FusekiRequestException.create(responseCode, responseMessage);
            }
            String ct = DatasetGraphAccessorHTTP.getHeader(response, "Content-Type");
            if (ct == null) {
                entity = response.getEntity();
                if (entity != null) {
                    InputStream instream = entity.getContent();
                    instream.close();
                }
                return null;
            }
            String x = DatasetGraphAccessorHTTP.getHeader(response, "Content-Type");
            String[] y = x.split(";");
            String contentType = null;
            if (y[0] != null) {
                contentType = y[0].trim();
            }
            String charset = null;
            if (y.length > 1 && y[1] != null) {
                charset = y[1].trim();
            }
            if ((entity2 = response.getEntity()) != null) {
                InputStream instream = entity2.getContent();
                ts = new TypedInputStream(instream, contentType, charset);
            }
            Graph graph = GraphFactory.createGraphMem();
            if (processBody) {
                this.readGraph(graph, ts, null);
            }
            if (ts != null) {
                ts.close();
            }
            UnmodifiableGraph graph2 = new UnmodifiableGraph(graph);
            return graph2;
        }
        catch (IOException ex) {
            httpRequest.abort();
            return null;
        }
    }

    private void readGraph(Graph graph, TypedInputStream ts, String base) {
        Lang lang = FusekiLib.langFromContentType(ts.getMediaType());
        if (lang == null) {
            throw new FusekiException("Unknown lang for " + ts.getMediaType());
        }
        SinkTriplesToGraph sink = new SinkTriplesToGraph(graph);
        Object parser = lang.equals((Object)Lang.RDFXML) ? LangRDFXML.create((InputStream)ts, (String)base, (String)base, null, (Sink)sink) : RiotReader.createParserTriples((InputStream)ts, (Lang)lang, (String)base, (Sink)sink);
        parser.parse();
        IO.close((Closeable)ts);
    }
}

