/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.mgt;

import java.util.List;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServlet;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.mgt.MgtCmdServlet;
import org.apache.jena.fuseki.server.FusekiErrorHandler;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.server.nio.BlockingChannelConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;

public class ManagementServer {
    public static Server createManagementServer(int mgtPort) {
        BlockingChannelConnector bcConnector;
        Fuseki.serverLog.info("Adding management functions");
        Server server = new Server();
        BlockingChannelConnector connector = bcConnector = new BlockingChannelConnector();
        connector.setMaxIdleTime(0);
        connector.setPort(mgtPort);
        server.addConnector((Connector)connector);
        ServletContextHandler context = new ServletContextHandler(1);
        context.setErrorHandler((ErrorHandler)new FusekiErrorHandler());
        server.setHandler((Handler)context);
        ManagementServer.addServlet(context, new MgtCmdServlet(), "/mgt");
        return server;
    }

    private static void addServlet(ServletContextHandler context, String datasetPath, HttpServlet servlet, List<String> pathSpecs) {
        for (String pathSpec : pathSpecs) {
            if (pathSpec.endsWith("/")) {
                pathSpec = pathSpec.substring(0, pathSpec.length() - 1);
            }
            if (pathSpec.startsWith("/")) {
                pathSpec = pathSpec.substring(1, pathSpec.length());
            }
            ManagementServer.addServlet(context, servlet, datasetPath + "/" + pathSpec);
        }
    }

    private static void addServlet(ServletContextHandler context, HttpServlet servlet, String pathSpec) {
        ServletHolder holder = new ServletHolder((Servlet)servlet);
        ManagementServer.addServlet(context, holder, pathSpec);
    }

    private static void addServlet(ServletContextHandler context, ServletHolder holder, String pathSpec) {
        Fuseki.serverLog.debug("Add servlet @ " + pathSpec);
        context.addServlet(holder, pathSpec);
    }
}

