/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.mgt;

import com.hp.hpl.jena.Jena;
import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.tdb.TDB;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.mgt.ActionBackup;
import org.apache.jena.fuseki.server.DatasetRef;
import org.apache.jena.fuseki.server.SPARQLServer;
import org.slf4j.Logger;

public class MgtCmdServlet
extends HttpServlet {
    private static Logger log = Fuseki.serverLog;
    public static String paramCmd = "cmd";
    public static String cmdBackup = "backup";
    public static String cmdRestart = "restart";
    public static String cmdShutdown = "shutdown";
    ActionBackup actionBackup = new ActionBackup();

    public void init() {
    }

    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String[] args = req.getParameterValues(paramCmd);
        if (args == null) {
            resp.setContentType("text/plain");
            resp.setStatus(400);
            return;
        }
        for (String cmd : args) {
            if (log.isInfoEnabled()) {
                log.info("Management command: " + cmd);
            }
            if (cmd.equalsIgnoreCase(cmdBackup)) {
                this.actionBackup.doPost(req, resp);
                continue;
            }
            if (cmd.equalsIgnoreCase(cmdRestart)) continue;
            if (cmd.equalsIgnoreCase(cmdShutdown)) {
                Fuseki.getServer().stop();
                continue;
            }
            log.warn("Unrecognized command : " + cmd);
        }
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) {
        try {
            PrintWriter out = resp.getWriter();
            resp.setContentType("text/plain");
            SPARQLServer server = Fuseki.getServer();
            out.println("Software:");
            String fusekiVersion = Fuseki.VERSION;
            if (fusekiVersion.equals("${project.version}")) {
                fusekiVersion = "(development)";
            }
            out.printf("  %s %s\n", "Fuseki", fusekiVersion);
            out.printf("  %s %s\n", "TDB", TDB.VERSION);
            out.printf("  %s %s\n", "ARQ", ARQ.VERSION);
            out.printf("  %s %s\n", Jena.NAME, Jena.VERSION);
            out.println();
            for (DatasetRef dsRef : server.getDatasets()) {
                MgtCmdServlet.datasetRefDetails(out, dsRef);
                out.println();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void datasetRefDetails(PrintWriter out, DatasetRef dsRef) {
        if (dsRef.name != null) {
            out.println("Name = " + dsRef.name);
        } else {
            out.println("Name = <unset>");
        }
        MgtCmdServlet.endpointDetail(out, "Query", dsRef, dsRef.queryEP);
        MgtCmdServlet.endpointDetail(out, "Update", dsRef, dsRef.updateEP);
        MgtCmdServlet.endpointDetail(out, "Upload", dsRef, dsRef.uploadEP);
        MgtCmdServlet.endpointDetail(out, "Graphs(Read)", dsRef, dsRef.readGraphStoreEP);
        MgtCmdServlet.endpointDetail(out, "Graphs(RW)", dsRef, dsRef.readWriteGraphStoreEP);
    }

    private static void endpointDetail(PrintWriter out, String label, DatasetRef dsRef, List<String> endpoints) {
        boolean first = true;
        out.printf("   %-15s :: ", label);
        for (String s : endpoints) {
            if (!first) {
                out.print(" , ");
            }
            first = false;
            s = "/" + dsRef.name + "/" + s;
            out.print(s);
        }
        out.println();
    }

    public String getServletInfo() {
        return "Fuseki Control Servlet";
    }
}

