/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.migrate;

import com.hp.hpl.jena.graph.Factory;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFErrorHandler;
import com.hp.hpl.jena.rdf.model.RDFReader;
import com.hp.hpl.jena.shared.NotFoundException;
import com.hp.hpl.jena.util.FileManager;
import com.hp.hpl.jena.util.FileUtils;
import java.io.InputStream;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.migrate.GraphErrorHandler;
import org.apache.jena.fuseki.migrate.LimitingGraph;
import org.apache.jena.fuseki.migrate.SinkLimited;
import org.openjena.atlas.lib.Sink;
import org.openjena.riot.Lang;
import org.openjena.riot.RiotReader;
import org.openjena.riot.lang.LangRIOT;
import org.openjena.riot.lang.SinkTriplesToGraph;

public class GraphLoadUtils {
    public static Model readModel(String uri, int limit) {
        Graph g = Factory.createGraphMem();
        GraphLoadUtils.readUtil(g, uri, limit);
        return ModelFactory.createModelForGraph((Graph)g);
    }

    public static void loadModel(Model model, String uri, int limit) {
        Graph g = model.getGraph();
        GraphLoadUtils.readUtil(g, uri, limit);
    }

    public static Graph readGraph(String uri, int limit) {
        Graph g = Factory.createGraphMem();
        GraphLoadUtils.readUtil(g, uri, limit);
        return g;
    }

    public static void loadGraph(Graph g, String uri, int limit) {
        GraphLoadUtils.readUtil(g, uri, limit);
    }

    private static void readUtil(Graph graph, String uri, int limit) {
        Lang lang = Lang.guess((String)uri, (Lang)Lang.RDFXML);
        Object sink = new SinkTriplesToGraph(graph);
        sink = new SinkLimited(sink, limit);
        InputStream input = Fuseki.webFileManager.open(uri);
        LangRIOT parser = RiotReader.createParserTriples((InputStream)input, (Lang)lang, (String)uri, (Sink)sink);
        parser.parse();
    }

    private static Model readUtil1(Graph graph, String uri, int limit, String syntax) {
        String altURI = FileManager.get().mapURI(uri);
        if (altURI != null) {
            syntax = FileUtils.guessLang((String)uri);
        }
        LimitingGraph g = new LimitingGraph(graph, limit);
        Model m = ModelFactory.createModelForGraph((Graph)g);
        RDFReader r = m.getReader(syntax);
        r.setErrorHandler((RDFErrorHandler)new GraphErrorHandler());
        InputStream in = FileManager.get().open(uri);
        if (in == null) {
            throw new NotFoundException("Not found: " + uri);
        }
        r.read(m, in, uri);
        return m;
    }
}

