/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.servlets;

import java.io.EOFException;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import org.apache.jena.fuseki.conneg.WebLib;

public class ResponseOps {
    public static boolean isEOFexception(IOException ioEx) {
        if (ioEx.getClass().getName().equals("org.mortbay.jetty.EofException eofEx")) {
            return true;
        }
        return ioEx instanceof EOFException;
    }

    public static String paramForceAccept(HttpServletRequest request) {
        String x = ResponseOps.fetchParam(request, "force-accept");
        return ResponseOps.expandShortName(x);
    }

    public static String paramStylesheet(HttpServletRequest request) {
        return ResponseOps.fetchParam(request, "stylesheet");
    }

    public static String paramOutput(HttpServletRequest request) {
        String x = ResponseOps.fetchParam(request, "output");
        if (x == null) {
            x = ResponseOps.fetchParam(request, "format");
        }
        return ResponseOps.expandShortName(x);
    }

    public static String paramAcceptField(HttpServletRequest request) {
        String acceptField = WebLib.getAccept(request);
        String acceptParam = ResponseOps.fetchParam(request, "accept");
        if (acceptParam != null) {
            acceptField = acceptParam;
        }
        if (acceptField == null) {
            return null;
        }
        return ResponseOps.expandShortName(acceptField);
    }

    public static String expandShortName(String str) {
        if (str == null) {
            return null;
        }
        if (str.equalsIgnoreCase("json")) {
            return "application/sparql-results+json";
        }
        if (str.equalsIgnoreCase("sparql")) {
            return "application/sparql-results+xml";
        }
        if (str.equalsIgnoreCase("xml")) {
            return "application/sparql-results+xml";
        }
        if (str.equalsIgnoreCase("text")) {
            return "text/plain";
        }
        if (str.equalsIgnoreCase("csv")) {
            return "text/csv";
        }
        if (str.equalsIgnoreCase("tsv")) {
            return "text/tab-separated-values";
        }
        return str;
    }

    public static String paramCallback(HttpServletRequest request) {
        return ResponseOps.fetchParam(request, "callback");
    }

    public static String fetchParam(HttpServletRequest request, String parameterName) {
        String value = request.getParameter(parameterName);
        if (value != null && (value = value.trim()).length() == 0) {
            value = null;
        }
        return value;
    }
}

