/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.servlets;

import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFormatter;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jena.fuseki.DEF;
import org.apache.jena.fuseki.FusekiException;
import org.apache.jena.fuseki.conneg.AcceptList;
import org.apache.jena.fuseki.conneg.ConNeg;
import org.apache.jena.fuseki.servlets.ResponseOps;
import org.apache.jena.fuseki.servlets.SPARQL_ServletBase;
import org.openjena.atlas.web.MediaType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseResultSet {
    private static Logger log = LoggerFactory.getLogger(ResponseResultSet.class);
    static AcceptList prefContentTypeResultSet = DEF.rsOffer;
    static AcceptList prefContentTypeRDF = DEF.rdfOffer;
    public static final String contentOutputJSON = "json";
    public static final String contentOutputXML = "xml";
    public static final String contentOutputSPARQL = "sparql";
    public static final String contentOutputText = "text";
    public static final String contentOutputCSV = "csv";
    public static final String contentOutputTSV = "tsv";

    public static void doResponseResultSet(final ResultSet resultSet, final Boolean booleanResult, HttpServletRequest request, HttpServletResponse response) {
        String forceAccept;
        String outputField;
        if (resultSet == null && booleanResult == null) {
            log.warn("doResponseResult: Both result set and boolean result are null");
            throw new FusekiException("Both result set and boolean result are null");
        }
        if (resultSet != null && booleanResult != null) {
            log.warn("doResponseResult: Both result set and boolean result are set");
            throw new FusekiException("Both result set and boolean result are set");
        }
        String mimeType = null;
        MediaType i = ConNeg.chooseContentType(request, DEF.rsOffer, DEF.acceptRSXML);
        if (i != null) {
            mimeType = i.getContentType();
        }
        if ((outputField = ResponseOps.paramOutput(request)) != null) {
            mimeType = outputField;
        }
        String serializationType = mimeType;
        String contentType = mimeType;
        final String stylesheetURL = ResponseOps.paramStylesheet(request);
        if (stylesheetURL != null && serializationType.equals("application/sparql-results+xml")) {
            contentType = "application/xml";
        }
        if ((forceAccept = ResponseOps.paramForceAccept(request)) != null) {
            contentType = forceAccept;
        }
        if (serializationType.equals("application/sparql-results+xml")) {
            try {
                ResponseResultSet.output(contentType, null, new OutputContent(){

                    @Override
                    public void output(ServletOutputStream out) {
                        if (resultSet != null) {
                            ResultSetFormatter.outputAsXML((OutputStream)out, (ResultSet)resultSet, (String)stylesheetURL);
                        }
                        if (booleanResult != null) {
                            ResultSetFormatter.outputAsXML((OutputStream)out, (boolean)booleanResult, (String)stylesheetURL);
                        }
                    }
                }, request, response);
            }
            catch (Exception ex) {
                log.debug("Exception [SELECT/XML]" + ex, (Throwable)ex);
            }
            return;
        }
        if (serializationType.equals("application/sparql-results+json")) {
            try {
                ResponseResultSet.jsonOutput(contentType, new OutputContent(){

                    @Override
                    public void output(ServletOutputStream out) {
                        if (resultSet != null) {
                            ResultSetFormatter.outputAsJSON((OutputStream)out, (ResultSet)resultSet);
                        }
                        if (booleanResult != null) {
                            ResultSetFormatter.outputAsJSON((OutputStream)out, (boolean)booleanResult);
                        }
                    }
                }, request, response);
            }
            catch (Exception ex) {
                log.debug("Exception [SELECT/JSON] " + ex, (Throwable)ex);
            }
            return;
        }
        if (serializationType.equals("text/plain")) {
            try {
                ResponseResultSet.textOutput(contentType, new OutputContent(){

                    @Override
                    public void output(ServletOutputStream out) {
                        if (resultSet != null) {
                            ResultSetFormatter.out((OutputStream)out, (ResultSet)resultSet);
                        }
                        if (booleanResult != null) {
                            ResultSetFormatter.out((OutputStream)out, (boolean)booleanResult);
                        }
                    }
                }, request, response);
            }
            catch (Exception ex) {
                log.debug("Exception [SELECT/Text] " + ex, (Throwable)ex);
            }
            return;
        }
        if (serializationType.equals("text/csv") || serializationType.equals("text/tab-separated-values")) {
            try {
                OutputContent output = serializationType.equals("text/csv") ? new OutputContent(){

                    @Override
                    public void output(ServletOutputStream out) {
                        if (resultSet != null) {
                            ResultSetFormatter.outputAsCSV((OutputStream)out, (ResultSet)resultSet);
                        }
                        if (booleanResult != null) {
                            ResultSetFormatter.outputAsCSV((OutputStream)out, (boolean)booleanResult);
                        }
                    }
                } : new OutputContent(){

                    @Override
                    public void output(ServletOutputStream out) {
                        if (resultSet != null) {
                            ResultSetFormatter.outputAsTSV((OutputStream)out, (ResultSet)resultSet);
                        }
                        if (booleanResult != null) {
                            ResultSetFormatter.outputAsTSV((OutputStream)out, (boolean)booleanResult);
                        }
                    }
                };
                ResponseResultSet.textOutput(contentType, output, request, response);
            }
            catch (Exception ex) {
                log.debug("Exception [SELECT/CSV-TSV] " + ex, (Throwable)ex);
            }
            return;
        }
        SPARQL_ServletBase.errorBadRequest("Can't determine output serialization: " + serializationType);
    }

    private static void output(String contentType, String charset, OutputContent proc, HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        try {
            ResponseResultSet.setHttpResponse(httpRequest, httpResponse, contentType, charset);
            httpResponse.setStatus(200);
            ServletOutputStream out = httpResponse.getOutputStream();
            proc.output(out);
            out.flush();
            httpResponse.flushBuffer();
        }
        catch (IOException ex) {
            SPARQL_ServletBase.errorOccurred(ex);
        }
    }

    public static void setHttpResponse(HttpServletRequest httpRequest, HttpServletResponse httpResponse, String contentType, String charset) {
        httpResponse.setHeader("Cache-Control", "no-cache");
        httpResponse.setHeader("Pragma", "no-cache");
        if (contentType != null) {
            if (charset != null && !ResponseResultSet.isXML(contentType)) {
                contentType = contentType + "; charset=" + charset;
            }
            log.trace("Content-Type for response: " + contentType);
            httpResponse.setContentType(contentType);
        }
    }

    private static boolean isXML(String contentType) {
        return contentType.equals("application/rdf+xml") || contentType.equals("application/sparql-results+xml") || contentType.equals("application/xml");
    }

    private static void jsonOutput(String contentType, OutputContent proc, HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        try {
            String callback = ResponseOps.paramCallback(httpRequest);
            String outputField = ResponseOps.paramOutput(httpRequest);
            ServletOutputStream out = httpResponse.getOutputStream();
            if (callback != null) {
                out.print(callback);
                out.println("(");
            }
            ResponseResultSet.output(contentType, "utf-8", proc, httpRequest, httpResponse);
            if (callback != null) {
                out.print(")");
                out.println();
            }
            out.flush();
            httpResponse.flushBuffer();
        }
        catch (IOException ex) {
            SPARQL_ServletBase.errorOccurred(ex);
        }
    }

    private static void textOutput(String contentType, OutputContent proc, HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        try {
            ServletOutputStream out = httpResponse.getOutputStream();
            ResponseResultSet.output(contentType, "utf-8", proc, httpRequest, httpResponse);
            out.flush();
            httpResponse.flushBuffer();
        }
        catch (IOException ex) {
            SPARQL_ServletBase.errorOccurred(ex);
        }
    }

    static interface OutputContent {
        public void output(ServletOutputStream var1);
    }
}

