/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.servlets;

import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryException;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QueryParseException;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.sparql.resultset.SPARQLResult;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jena.fuseki.FusekiException;
import org.apache.jena.fuseki.FusekiLib;
import org.apache.jena.fuseki.migrate.WebIO;
import org.apache.jena.fuseki.server.DatasetRef;
import org.apache.jena.fuseki.servlets.ResponseModel;
import org.apache.jena.fuseki.servlets.ResponseResultSet;
import org.apache.jena.fuseki.servlets.SPARQL_Protocol;
import org.apache.jena.fuseki.servlets.SPARQL_ServletBase;
import org.openjena.atlas.io.IO;
import org.openjena.atlas.io.IndentedLineBuffer;
import org.openjena.riot.ContentType;

public abstract class SPARQL_Query
extends SPARQL_Protocol {
    private static String[] params_ = new String[]{"query", "default-graph-uri", "named-graph-uri", "query-ref", "stylesheet", "accept", "output", "format", "callback", "force-accept", "timeout"};
    protected static Set<String> allParams = new HashSet<String>(Arrays.asList(params_));

    public SPARQL_Query(boolean verbose) {
        super(SPARQL_ServletBase.PlainRequestFlag.DIFFERENT, verbose);
    }

    public SPARQL_Query() {
        this(false);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) {
        this.doCommon(request, response);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
        this.doCommon(request, response);
    }

    protected void doOptions(HttpServletRequest request, HttpServletResponse response) {
        response.setHeader("Allow", "GET,OPTIONS,POST");
        response.setHeader("Content-Length", "0");
    }

    @Override
    protected final void perform(long id, DatasetRef desc, HttpServletRequest request, HttpServletResponse response) {
        this.validate(request);
        HttpActionQuery action = new HttpActionQuery(id, desc, request, response, this.verbose_debug);
        if (request.getMethod().equals("GET")) {
            this.executeWithParameter(action);
            return;
        }
        ContentType ct = FusekiLib.contentType(request);
        String incoming = ct.getContentType();
        if ("application/sparql-query".equals(incoming)) {
            this.executeBody(action);
            return;
        }
        if ("application/x-www-form-urlencoded".equals(incoming)) {
            this.executeWithParameter(action);
            return;
        }
        SPARQL_Query.error(415, "Bad content type: " + incoming);
    }

    protected abstract void validate(HttpServletRequest var1);

    protected void validate(HttpServletRequest request, Set<String> params) {
        ContentType ct = FusekiLib.contentType(request);
        boolean mustHaveQueryParam = true;
        if (ct != null) {
            String incoming = ct.getContentType();
            if ("application/sparql-query".equals(incoming)) {
                mustHaveQueryParam = false;
            } else if (!"application/x-www-form-urlencoded".equals(incoming)) {
                SPARQL_Query.error(415, "Unsupported: " + incoming);
            }
        }
        if (mustHaveQueryParam) {
            String queryStr = request.getParameter("query");
            if (queryStr == null) {
                SPARQL_Query.errorBadRequest("SPARQL Query: No query specified (no 'query=' found)");
            }
            if (queryStr.isEmpty()) {
                SPARQL_Query.errorBadRequest("SPARQL Query: Empty query string");
            }
        }
        if (params != null) {
            Enumeration en = request.getParameterNames();
            while (en.hasMoreElements()) {
                String name = (String)en.nextElement();
                if (params.contains(name)) continue;
                SPARQL_Query.warning("SPARQL Query: Unrecognize request parameter (ignored): " + name);
            }
        }
    }

    private void executeWithParameter(HttpActionQuery action) {
        String queryString = action.request.getParameter("query");
        this.execute(queryString, action);
    }

    private void executeBody(HttpActionQuery action) {
        String queryString = null;
        try {
            ServletInputStream input = action.request.getInputStream();
            queryString = IO.readWholeFileAsUTF8((InputStream)input);
        }
        catch (IOException ex) {
            SPARQL_Query.errorOccurred(ex);
        }
        this.execute(queryString, action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(String queryString, HttpActionQuery action) {
        String queryStringLog = SPARQL_Query.formatForLog(queryString);
        log.info(String.format("[%d] Query = %s", action.id, queryStringLog));
        Query query = null;
        try {
            query = QueryFactory.create((String)queryString, (Syntax)Syntax.syntaxARQ);
            queryStringLog = this.formatForLog(query);
        }
        catch (QueryParseException ex) {
            SPARQL_Query.errorBadRequest("Parse error: \n" + queryString + "\n\r" + SPARQL_Query.messageForQPE(ex));
        }
        catch (QueryException ex) {
            SPARQL_Query.errorBadRequest("Error: \n" + queryString + "\n\r" + ex.getMessage());
        }
        this.validateQuery(action, query);
        action.beginRead();
        try {
            SPARQLResult result = this.executeQuery(action, query, queryStringLog);
            this.sendResults(action, result);
        }
        finally {
            action.endRead();
        }
    }

    protected abstract void validateQuery(HttpActionQuery var1, Query var2);

    protected QueryExecution createQueryExecution(Query query, Dataset dataset) {
        return QueryExecutionFactory.create((Query)query, (Dataset)dataset);
    }

    protected SPARQLResult executeQuery(HttpActionQuery action, Query query, String queryStringLog) {
        Dataset dataset = this.decideDataset(action, query, queryStringLog);
        QueryExecution qexec = this.createQueryExecution(query, dataset);
        this.setAnyTimeouts(qexec, action);
        if (query.isSelectType()) {
            ResultSet rs = qexec.execSelect();
            rs.hasNext();
            log.info(String.format("[%d] OK/select", action.id));
            return new SPARQLResult(rs);
        }
        if (query.isConstructType()) {
            Model model = qexec.execConstruct();
            log.info(String.format("[%d] OK/construct", action.id));
            return new SPARQLResult(model);
        }
        if (query.isDescribeType()) {
            Model model = qexec.execDescribe();
            log.info(String.format("[%d] OK/describe", action.id));
            return new SPARQLResult(model);
        }
        if (query.isAskType()) {
            boolean b = qexec.execAsk();
            log.info(String.format("[%d] OK/ask", action.id));
            return new SPARQLResult(b);
        }
        SPARQL_Query.errorBadRequest("Unknown query type - " + queryStringLog);
        return null;
    }

    private void setAnyTimeouts(QueryExecution qexec, HttpActionQuery action) {
        if (!action.desc.allowTimeoutOverride) {
            return;
        }
        long desiredTimeout = Long.MAX_VALUE;
        String timeoutHeader = action.request.getHeader("Timeout");
        String timeoutParameter = action.request.getParameter("timeout");
        if (timeoutHeader != null) {
            try {
                desiredTimeout = (int)Float.parseFloat(timeoutHeader) * 1000;
            }
            catch (NumberFormatException e) {
                throw new FusekiException("Timeout header must be a number", e);
            }
        }
        if (timeoutParameter != null) {
            try {
                desiredTimeout = (int)Float.parseFloat(timeoutParameter) * 1000;
            }
            catch (NumberFormatException e) {
                throw new FusekiException("timeout parameter must be a number", e);
            }
        }
        desiredTimeout = Math.min(action.desc.maximumTimeoutOverride, desiredTimeout);
        if (desiredTimeout != Long.MAX_VALUE) {
            qexec.setTimeout(desiredTimeout);
        }
    }

    protected abstract Dataset decideDataset(HttpActionQuery var1, Query var2, String var3);

    protected void sendResults(HttpActionQuery action, SPARQLResult result) {
        if (result.isResultSet()) {
            ResponseResultSet.doResponseResultSet(result.getResultSet(), null, action.request, action.response);
        } else if (result.isGraph()) {
            ResponseModel.doResponseModel(result.getModel(), action.request, action.response);
        } else if (result.isBoolean()) {
            ResponseResultSet.doResponseResultSet(null, result.getBooleanResult(), action.request, action.response);
        } else {
            SPARQL_Query.errorOccurred("Unknown or invalid result type");
        }
    }

    private String formatForLog(Query query) {
        IndentedLineBuffer out = new IndentedLineBuffer();
        out.setFlatMode(true);
        query.serialize(out);
        return out.asString();
    }

    private String getRemoteString(String queryURI) {
        return WebIO.exec_get(queryURI);
    }

    protected class HttpActionQuery
    extends SPARQL_Protocol.HttpActionProtocol {
        DatasetRef desc;

        public HttpActionQuery(long id, DatasetRef desc, HttpServletRequest request, HttpServletResponse response, boolean verbose) {
            super(SPARQL_Query.this, id, desc, request, response, verbose);
            this.desc = desc;
        }
    }
}

