/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.servlets;

import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.query.QueryCancelledException;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.DatasetGraphFactory;
import com.hp.hpl.jena.tdb.migrate.DatasetGraphReadOnly;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jena.fuseki.http.HttpSC;
import org.apache.jena.fuseki.server.DatasetRef;
import org.apache.jena.fuseki.server.DatasetRegistry;
import org.apache.jena.fuseki.servlets.ActionErrorException;
import org.apache.jena.fuseki.servlets.HttpServletResponseTracker;
import org.apache.jena.fuseki.servlets.ServletBase;

public abstract class SPARQL_ServletBase
extends ServletBase {
    private final PlainRequestFlag queryStringHandling;
    private static DatasetGraph dummyDSG = new DatasetGraphReadOnly(DatasetGraphFactory.createMemFixed());

    protected SPARQL_ServletBase(PlainRequestFlag noQueryStringIsOK, boolean verbose_debug) {
        super(verbose_debug);
        this.queryStringHandling = noQueryStringIsOK;
    }

    protected void doCommon(HttpServletRequest request, HttpServletResponse response) {
        long id = requestIdAlloc.incrementAndGet();
        this.printRequest(id, request);
        HttpServletResponseTracker responseTracked = new HttpServletResponseTracker((HttpServletResponse)response);
        response = responseTracked;
        String uri = request.getRequestURI();
        this.initResponse(request, (HttpServletResponse)response);
        try {
            boolean requestContinue;
            if (request.getQueryString() == null && this.queryStringHandling == PlainRequestFlag.DIFFERENT && !(requestContinue = this.requestNoQueryString(request, (HttpServletResponse)response))) {
                return;
            }
            uri = this.mapRequestToDataset(uri);
            DatasetRef desc = null;
            if (uri != null) {
                desc = (DatasetRef)DatasetRegistry.get().get(uri);
                if (desc == null) {
                    SPARQL_ServletBase.errorNotFound("No dataset for URI: " + uri);
                    return;
                }
            } else {
                desc = new DatasetRef();
                desc.dataset = dummyDSG;
            }
            this.perform(id, desc, request, (HttpServletResponse)response);
        }
        catch (QueryCancelledException ex) {
            String message = String.format("The query timed out (restricted to %s ms).", ARQ.getContext().get(ARQ.queryTimeout));
            this.responseSendError((HttpServletResponse)response, 408, message);
        }
        catch (ActionErrorException ex) {
            if (ex.exception != null) {
                ex.exception.printStackTrace(System.err);
            }
            if (ex.message != null) {
                this.responseSendError((HttpServletResponse)response, ex.rc, ex.message);
            } else {
                this.responseSendError((HttpServletResponse)response, ex.rc);
            }
        }
        catch (Throwable ex) {
            log.warn(String.format("[%d] RC = %d : %s", id, 500, ex.getMessage()), ex);
            this.responseSendError((HttpServletResponse)response, 500, ex.getMessage());
        }
        this.printResponse(id, responseTracked);
    }

    protected void doPatch(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.sendError(405, "HTTP PATCH not supported");
    }

    private void printRequest(long id, HttpServletRequest request) {
        String url = SPARQL_ServletBase.wholeRequestURL(request);
        String method = request.getMethod();
        log.info(String.format("[%d] %s %s", id, method, url));
        if (this.verbose_debug) {
            Enumeration en = request.getHeaderNames();
            while (en.hasMoreElements()) {
                String h = (String)en.nextElement();
                Enumeration vals = request.getHeaders(h);
                if (!vals.hasMoreElements()) {
                    log.info(String.format("[%d]   ", id, h));
                    continue;
                }
                while (vals.hasMoreElements()) {
                    log.info(String.format("[%d]   %-20s %s", id, h, vals.nextElement()));
                }
            }
        }
    }

    private void initResponse(HttpServletRequest request, HttpServletResponse response) {
        SPARQL_ServletBase.setCommonHeaders(response);
        String method = request.getMethod().toUpperCase();
        if ("GET".equals(method) || "HEAD".equals(method)) {
            SPARQL_ServletBase.setVaryHeader(response);
        }
    }

    private void printResponse(long id, HttpServletResponseTracker response) {
        if (this.verbose_debug) {
            if (response.contentType != null) {
                log.info(String.format("[%d]   %-20s %s", id, "Content-Type", response.contentType));
            }
            if (response.contentLength != -1) {
                log.info(String.format("[%d]   %-20s %d", id, "Content-Length", response.contentLength));
            }
            for (Map.Entry<String, String> e : response.headers.entrySet()) {
                log.info(String.format("[%d]   %-20s %s", id, e.getKey(), e.getValue()));
            }
        }
        if (response.message == null) {
            log.info(String.format("[%d] %d %s", id, response.statusCode, HttpSC.getMessage(response.statusCode)));
        } else {
            log.info(String.format("[%d] %d %s", id, response.statusCode, response.message));
        }
    }

    private void responseSendError(HttpServletResponse response, int statusCode, String message) {
        try {
            response.sendError(statusCode, message);
        }
        catch (IOException ex) {
            SPARQL_ServletBase.errorOccurred(ex);
        }
    }

    private void responseSendError(HttpServletResponse response, int statusCode) {
        try {
            response.sendError(statusCode);
        }
        catch (IOException ex) {
            SPARQL_ServletBase.errorOccurred(ex);
        }
    }

    protected String mapRequestToDataset(String uri) {
        return this.mapRequestToDataset$(uri);
    }

    protected String mapRequestToDataset$(String uri) {
        int i = uri.lastIndexOf(47);
        if (i == 0) {
            return uri;
        }
        return uri.substring(0, i);
    }

    protected abstract void perform(long var1, DatasetRef var3, HttpServletRequest var4, HttpServletResponse var5);

    protected abstract boolean requestNoQueryString(HttpServletRequest var1, HttpServletResponse var2);

    protected static enum PlainRequestFlag {
        REGULAR,
        DIFFERENT;

    }
}

