/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.servlets;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.graph.GraphFactory;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.util.Streams;
import org.apache.jena.fuseki.FusekiLib;
import org.apache.jena.fuseki.server.DatasetRef;
import org.apache.jena.fuseki.servlets.ActionErrorException;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.fuseki.servlets.SPARQL_ServletBase;
import org.apache.jena.iri.IRI;
import org.openjena.atlas.lib.Sink;
import org.openjena.riot.ContentType;
import org.openjena.riot.ErrorHandler;
import org.openjena.riot.ErrorHandlerFactory;
import org.openjena.riot.Lang;
import org.openjena.riot.RiotException;
import org.openjena.riot.RiotReader;
import org.openjena.riot.lang.LangRIOT;
import org.openjena.riot.lang.SinkTriplesToGraph;
import org.openjena.riot.system.IRIResolver;
import org.slf4j.Logger;

public class SPARQL_Upload
extends SPARQL_ServletBase {
    private static ErrorHandler errorHandler = ErrorHandlerFactory.errorHandlerStd((Logger)log);

    public SPARQL_Upload(boolean verbose_debug) {
        super(SPARQL_ServletBase.PlainRequestFlag.REGULAR, verbose_debug);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doCommon(request, response);
    }

    protected void doOptions(HttpServletRequest request, HttpServletResponse response) {
        response.setHeader("Allow", "OPTIONS,POST");
        response.setHeader("Content-Length", "0");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void perform(long id, DatasetRef desc, HttpServletRequest request, HttpServletResponse response) {
        this.validate(request);
        HttpActionUpload action = new HttpActionUpload(id, desc, request, response, this.verbose_debug);
        boolean isMultipart = ServletFileUpload.isMultipartContent((HttpServletRequest)request);
        if (!isMultipart) {
            SPARQL_Upload.error(400, "Not a file upload");
        }
        ServletFileUpload upload = new ServletFileUpload();
        try {
            String graphName = null;
            Graph graphTmp = GraphFactory.createGraphMem();
            Node gn = null;
            String name = null;
            ContentType ct = null;
            Lang lang = null;
            int tripleCount = 0;
            FileItemIterator iter = upload.getItemIterator(request);
            while (iter.hasNext()) {
                String contentTypeHeader;
                FileItemStream item = iter.next();
                String fieldName = item.getFieldName();
                InputStream stream = item.openStream();
                if (item.isFormField()) {
                    String value = Streams.asString((InputStream)stream, (String)"UTF-8");
                    if (fieldName.equals("graph")) {
                        graphName = value;
                        if (graphName == null || graphName.equals("default")) continue;
                        IRI iri = IRIResolver.parseIRI((String)value);
                        if (iri.hasViolation(false)) {
                            SPARQL_Upload.errorBadRequest("Bad IRI: " + graphName);
                        }
                        if (iri.getScheme() == null) {
                            SPARQL_Upload.errorBadRequest("Bad IRI: no IRI scheme name: " + graphName);
                        }
                        if (iri.getScheme().equalsIgnoreCase("http") || iri.getScheme().equalsIgnoreCase("https")) {
                            if (iri.getRawHost() == null) {
                                SPARQL_Upload.errorBadRequest("Bad IRI: no host name: " + graphName);
                            }
                            if (iri.getRawPath() == null || iri.getRawPath().length() == 0) {
                                SPARQL_Upload.errorBadRequest("Bad IRI: no path: " + graphName);
                            }
                            if (iri.getRawPath().charAt(0) != '/') {
                                SPARQL_Upload.errorBadRequest("Bad IRI: Path does not start '/': " + graphName);
                            }
                        }
                        gn = Node.createURI((String)graphName);
                        continue;
                    }
                    if (fieldName.equals("default-graph-uri")) {
                        graphName = null;
                        continue;
                    }
                    log.info(String.format("[%d] Upload: Field=" + fieldName + " - ignored", new Object[0]));
                    continue;
                }
                name = item.getName();
                if (name == null || name.equals("") || name.equals("UNSET FILE NAME")) {
                    SPARQL_Upload.errorBadRequest("No name for content - can't determine RDF syntax");
                }
                if ((lang = FusekiLib.langFromContentType((ct = ContentType.parse((String)(contentTypeHeader = item.getContentType()))).getContentType())) == null) {
                    lang = Lang.guess((String)name);
                }
                if (lang == null) {
                    lang = Lang.RDFXML;
                }
                String base = "http://example/upload-base/";
                SinkTriplesToGraph sink = new SinkTriplesToGraph(graphTmp);
                LangRIOT parser = RiotReader.createParserTriples((InputStream)stream, (Lang)lang, (String)base, (Sink)sink);
                parser.getProfile().setHandler(errorHandler);
                try {
                    parser.parse();
                }
                catch (RiotException ex) {
                    SPARQL_Upload.errorBadRequest("Parse error: " + ex.getMessage());
                }
                finally {
                    sink.close();
                }
                tripleCount = graphTmp.size();
            }
            if (graphName == null) {
                graphName = "default";
            }
            log.info(String.format("[%d] Upload: Filename: %s, Content-Type=%s, Charset=%s => (%s,%s,%d triple(s))", action.id, name, ct.getContentType(), ct.getCharset(), graphName, lang.getName(), tripleCount));
            action.beginWrite();
            try {
                if (graphName.equals("default")) {
                    action.getActiveDSG().getDefaultGraph().getBulkUpdateHandler().add(graphTmp);
                } else {
                    action.getActiveDSG().getGraph(gn).getBulkUpdateHandler().add(graphTmp);
                }
                action.commit();
            }
            finally {
                action.endWrite();
            }
            response.setContentType("text/plain");
            response.getOutputStream().print("Triples = " + tripleCount);
            SPARQL_Upload.success(action);
        }
        catch (ActionErrorException ex) {
            throw ex;
        }
        catch (Exception ex) {
            SPARQL_Upload.errorOccurred(ex);
            return;
        }
    }

    private void validate(HttpServletRequest request) {
    }

    @Override
    protected boolean requestNoQueryString(HttpServletRequest request, HttpServletResponse response) {
        SPARQL_Upload.errorOccurred("requestNoQueryString");
        return true;
    }

    private class HttpActionUpload
    extends HttpAction {
        public HttpActionUpload(long id, DatasetRef desc, HttpServletRequest request, HttpServletResponse response, boolean verbose) {
            super(id, desc, request, response, verbose);
        }
    }
}

