/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.migrate;

import com.hp.hpl.jena.graph.Factory;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import java.io.InputStream;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.migrate.SinkLimited;
import org.openjena.atlas.lib.Sink;
import org.openjena.riot.Lang;
import org.openjena.riot.RiotReader;
import org.openjena.riot.lang.LangRIOT;
import org.openjena.riot.lang.SinkTriplesToGraph;

public class GraphLoadUtils {
    public static Model readModel(String uri, int limit) {
        Graph g = Factory.createGraphMem();
        GraphLoadUtils.readUtil(g, uri, limit);
        return ModelFactory.createModelForGraph((Graph)g);
    }

    public static void loadModel(Model model, String uri, int limit) {
        Graph g = model.getGraph();
        GraphLoadUtils.readUtil(g, uri, limit);
    }

    public static Graph readGraph(String uri, int limit) {
        Graph g = Factory.createGraphMem();
        GraphLoadUtils.readUtil(g, uri, limit);
        return g;
    }

    public static void loadGraph(Graph g, String uri, int limit) {
        GraphLoadUtils.readUtil(g, uri, limit);
    }

    private static void readUtil(Graph graph, String uri, int limit) {
        Lang lang = Lang.guess((String)uri, (Lang)Lang.RDFXML);
        Object sink = new SinkTriplesToGraph(graph);
        sink = new SinkLimited(sink, limit);
        InputStream input = Fuseki.webFileManager.open(uri);
        LangRIOT parser = RiotReader.createParserTriples((InputStream)input, (Lang)lang, (String)uri, (Sink)sink);
        parser.parse();
    }
}

