/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.migrate;

import org.openjena.atlas.lib.Sink;
import org.openjena.atlas.lib.SinkWrapper;
import org.openjena.riot.RiotException;

public class SinkLimited<T>
extends SinkWrapper<T> {
    private long count = 0L;
    private final long limit;

    public SinkLimited(Sink<T> output, long limit) {
        super(output);
        this.limit = limit;
    }

    public void send(T thing) {
        ++this.count;
        if (this.count > this.limit) {
            throw new RiotException("Limit " + this.limit + " exceeded");
        }
        super.send(thing);
    }

    public long getCount() {
        return this.count;
    }

    public long getLimit() {
        return this.limit;
    }
}

