/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.server;

import com.hp.hpl.jena.assembler.Assembler;
import com.hp.hpl.jena.assembler.JA;
import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.QuerySolutionMap;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFactory;
import com.hp.hpl.jena.query.ResultSetRewindable;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.ResIterator;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.assembler.AssemblerUtils;
import com.hp.hpl.jena.sparql.util.Context;
import com.hp.hpl.jena.tdb.TDB;
import com.hp.hpl.jena.util.FileManager;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.FusekiConfigException;
import org.apache.jena.fuseki.server.DatasetRef;
import org.apache.jena.fuseki.server.FusekiVocab;
import org.apache.jena.fuseki.server.ServerConfig;
import org.openjena.atlas.iterator.Iter;
import org.openjena.atlas.lib.StrUtils;
import org.slf4j.Logger;

public class FusekiConfig {
    int port;
    int mgtPort;
    List<DatasetRef> datasets = null;
    private static Logger log;
    private static String prefixes;

    public static ServerConfig defaultConfiguration(String datasetPath, DatasetGraph dsg, boolean allowUpdate) {
        DatasetRef sDesc = new DatasetRef();
        sDesc.name = datasetPath;
        sDesc.dataset = dsg;
        sDesc.queryEP.add("query");
        sDesc.queryEP.add("sparql");
        if (allowUpdate) {
            sDesc.updateEP.add("update");
            sDesc.uploadEP.add("upload");
            sDesc.readWriteGraphStoreEP.add("data");
        } else {
            sDesc.readGraphStoreEP.add("data");
        }
        ServerConfig config = new ServerConfig();
        config.services = Arrays.asList(sDesc);
        config.port = 3030;
        config.mgtPort = 3031;
        config.pagesPort = config.port;
        config.jettyConfigFile = null;
        config.pages = Fuseki.PagesStatic;
        config.enableCompression = true;
        return config;
    }

    public static ServerConfig configure(String filename) {
        ARQ.init();
        TDB.init();
        Fuseki.init();
        Model m = FileManager.get().loadModel(filename);
        List<Resource> servers = FusekiConfig.getByType(FusekiVocab.tServer, m);
        if (servers.size() == 0) {
            throw new FusekiConfigException("No server found (no resource with type " + FusekiConfig.strForResource(FusekiVocab.tServer));
        }
        if (servers.size() > 1) {
            throw new FusekiConfigException(servers.size() + " servers found (must be exactly one in a configuration file)");
        }
        Resource server = servers.get(0);
        FusekiConfig.processServer(server);
        ResultSet rs = FusekiConfig.query("SELECT * { ?s fu:services [ list:member ?member ] }", m);
        if (!rs.hasNext()) {
            log.warn("No services found");
        }
        ArrayList<DatasetRef> services = new ArrayList<DatasetRef>();
        while (rs.hasNext()) {
            QuerySolution soln = rs.next();
            Resource svc = soln.getResource("member");
            DatasetRef sd = FusekiConfig.processService(svc);
            services.add(sd);
        }
        ServerConfig config = new ServerConfig();
        config.services = services;
        config.port = 3030;
        config.mgtPort = 3031;
        config.pagesPort = config.port;
        config.jettyConfigFile = null;
        config.pages = Fuseki.PagesStatic;
        config.enableCompression = true;
        return config;
    }

    private static void processServer(Resource server) {
        AssemblerUtils.setContext((Resource)server, (Context)Fuseki.getContext());
        StmtIterator sIter = server.listProperties(JA.loadClass);
        while (sIter.hasNext()) {
            Statement s = sIter.nextStatement();
            RDFNode rn = s.getObject();
            String className = null;
            if (rn instanceof Resource) {
                String uri = ((Resource)rn).getURI();
                if (uri == null) {
                    log.warn("Blank node for class to load");
                    continue;
                }
                String javaScheme = "java:";
                if (!uri.startsWith(javaScheme)) {
                    log.warn("Class to load is not 'java:': " + uri);
                    continue;
                }
                className = uri.substring(javaScheme.length());
            }
            if (rn instanceof Literal) {
                className = ((Literal)rn).getLexicalForm();
            }
            FusekiConfig.loadAndInit(className);
        }
    }

    private static void loadAndInit(String className) {
        try {
            Class<?> classObj = Class.forName(className);
            log.info("Loaded " + className);
            Method initMethod = classObj.getMethod("init", new Class[0]);
            initMethod.invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException ex) {
            log.warn("Class not found: " + className);
        }
        catch (Exception e) {
            throw new FusekiConfigException(e);
        }
    }

    private static DatasetRef processService(Resource svc) {
        Resource datasetDesc;
        DatasetRef sDesc = new DatasetRef();
        log.info("Service: " + FusekiConfig.nodeLabel((RDFNode)svc));
        sDesc.name = ((Literal)FusekiConfig.getOne(svc, "fu:name")).getLexicalForm();
        log.info("  name = " + sDesc.name);
        FusekiConfig.addServiceEP("query", sDesc.name, sDesc.queryEP, svc, "fu:serviceQuery");
        FusekiConfig.addServiceEP("update", sDesc.name, sDesc.updateEP, svc, "fu:serviceUpdate");
        FusekiConfig.addServiceEP("upload", sDesc.name, sDesc.uploadEP, svc, "fu:serviceUpload");
        FusekiConfig.addServiceEP("graphStore(RW)", sDesc.name, sDesc.readWriteGraphStoreEP, svc, "fu:serviceReadWriteGraphStore");
        FusekiConfig.addServiceEP("graphStore(R)", sDesc.name, sDesc.readGraphStoreEP, svc, "fu:serviceReadGraphStore");
        if (svc.hasProperty(FusekiVocab.pAllowTimeoutOverride)) {
            sDesc.allowTimeoutOverride = svc.getProperty(FusekiVocab.pAllowTimeoutOverride).getObject().asLiteral().getBoolean();
            if (svc.hasProperty(FusekiVocab.pMaximumTimeoutOverride)) {
                sDesc.maximumTimeoutOverride = (int)(svc.getProperty(FusekiVocab.pMaximumTimeoutOverride).getObject().asLiteral().getFloat() * 1000.0f);
            }
        }
        if (!(datasetDesc = (Resource)FusekiConfig.getOne(svc, "fu:dataset")).hasProperty(RDF.type)) {
            throw new FusekiConfigException("No rdf:type for dataset " + FusekiConfig.nodeLabel((RDFNode)datasetDesc));
        }
        Dataset ds = (Dataset)Assembler.general.open(datasetDesc);
        sDesc.dataset = ds.asDatasetGraph();
        return sDesc;
    }

    private static RDFNode getOne(Resource svc, String property) {
        String ln = property.substring(property.indexOf(58) + 1);
        ResultSet rs = FusekiConfig.query("SELECT * { ?svc " + property + " ?x}", svc.getModel(), "svc", (RDFNode)svc);
        if (!rs.hasNext()) {
            throw new FusekiConfigException("No " + ln + " for service " + FusekiConfig.nodeLabel((RDFNode)svc));
        }
        RDFNode x = rs.next().get("x");
        if (rs.hasNext()) {
            throw new FusekiConfigException("Multiple " + ln + " for service " + FusekiConfig.nodeLabel((RDFNode)svc));
        }
        return x;
    }

    private static List<Resource> getByType(Resource type, Model m) {
        ResIterator rIter = m.listSubjectsWithProperty(RDF.type, (RDFNode)type);
        return Iter.toList((Iterator)rIter);
    }

    private static void addServiceEP(String label, String name, List<String> output, Resource svc, String property) {
        ResultSet rs = FusekiConfig.query("SELECT * { ?svc " + property + " ?ep}", svc.getModel(), "svc", (RDFNode)svc);
        while (rs.hasNext()) {
            QuerySolution soln = rs.next();
            String epName = soln.getLiteral("ep").getLexicalForm();
            output.add(epName);
            log.info("  " + label + " = /" + name + "/" + epName);
        }
    }

    private static ResultSet query(String string, Model m) {
        return FusekiConfig.query(string, m, null, null);
    }

    private static ResultSet query(String string, Model m, String varName, RDFNode value) {
        Query query = QueryFactory.create((String)(prefixes + string));
        QuerySolutionMap initValues = null;
        if (varName != null) {
            initValues = FusekiConfig.querySolution(varName, value);
        }
        QueryExecution qExec = QueryExecutionFactory.create((Query)query, (Model)m, (QuerySolution)initValues);
        ResultSetRewindable rs = ResultSetFactory.copyResults((ResultSet)qExec.execSelect());
        qExec.close();
        return rs;
    }

    private static QuerySolutionMap querySolution(String varName, RDFNode value) {
        QuerySolutionMap qsm = new QuerySolutionMap();
        FusekiConfig.querySolution(qsm, varName, value);
        return qsm;
    }

    private static QuerySolutionMap querySolution(QuerySolutionMap qsm, String varName, RDFNode value) {
        qsm.add(varName, value);
        return qsm;
    }

    private static String nodeLabel(RDFNode n) {
        if (n == null) {
            return "<null>";
        }
        if (n instanceof Resource) {
            return FusekiConfig.strForResource((Resource)n);
        }
        Literal lit = (Literal)n;
        return lit.getLexicalForm();
    }

    private static String strForResource(Resource r) {
        return FusekiConfig.strForResource(r, (PrefixMapping)r.getModel());
    }

    private static String strForResource(Resource r, PrefixMapping pm) {
        RDFNode n;
        if (r == null) {
            return "NULL ";
        }
        if (r.hasProperty(RDFS.label) && (n = r.getProperty(RDFS.label).getObject()) instanceof Literal) {
            return ((Literal)n).getString();
        }
        if (r.isAnon()) {
            return "<<blank node>>";
        }
        if (pm == null) {
            pm = r.getModel();
        }
        return FusekiConfig.strForURI(r.getURI(), pm);
    }

    private static String strForURI(String uri, PrefixMapping pm) {
        String x;
        if (pm != null && !(x = pm.shortForm(uri)).equals(uri)) {
            return x;
        }
        return "<" + uri + ">";
    }

    static {
        Fuseki.init();
        log = Fuseki.configLog;
        prefixes = StrUtils.strjoinNL((String[])new String[]{"PREFIX fu:     <http://jena.apache.org/fuseki#>", "PREFIX rdf:    <http://www.w3.org/1999/02/22-rdf-syntax-ns#>", "PREFIX rdfs:   <http://www.w3.org/2000/01/rdf-schema#>", "PREFIX tdb:    <http://jena.hpl.hp.com/2008/tdb#>", "PREFIX list:   <http://jena.hpl.hp.com/ARQ/list#>", "PREFIX list:   <http://jena.hpl.hp.com/ARQ/list#>", "PREFIX xsd:     <http://www.w3.org/2001/XMLSchema#>", "PREFIX apf:     <http://jena.hpl.hp.com/ARQ/property#>", "PREFIX afn:     <http://jena.hpl.hp.com/ARQ/function#>", ""});
    }
}

