/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.server;

import com.hp.hpl.jena.sparql.util.Utils;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.BindException;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServlet;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.FusekiException;
import org.apache.jena.fuseki.mgt.ActionDataset;
import org.apache.jena.fuseki.mgt.MgtFunctions;
import org.apache.jena.fuseki.server.DatasetRef;
import org.apache.jena.fuseki.server.DatasetRegistry;
import org.apache.jena.fuseki.server.FusekiErrorHandler;
import org.apache.jena.fuseki.server.ServerConfig;
import org.apache.jena.fuseki.servlets.DumpServlet;
import org.apache.jena.fuseki.servlets.SPARQL_QueryDataset;
import org.apache.jena.fuseki.servlets.SPARQL_QueryGeneral;
import org.apache.jena.fuseki.servlets.SPARQL_REST_R;
import org.apache.jena.fuseki.servlets.SPARQL_REST_RW;
import org.apache.jena.fuseki.servlets.SPARQL_UberServlet;
import org.apache.jena.fuseki.servlets.SPARQL_Update;
import org.apache.jena.fuseki.servlets.SPARQL_Upload;
import org.apache.jena.fuseki.servlets.SimpleVelocityServlet;
import org.apache.jena.fuseki.validation.DataValidator;
import org.apache.jena.fuseki.validation.IRIValidator;
import org.apache.jena.fuseki.validation.QueryValidator;
import org.apache.jena.fuseki.validation.UpdateValidator;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.DispatcherType;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.server.nio.BlockingChannelConnector;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlets.GzipFilter;
import org.eclipse.jetty.xml.XmlConfiguration;

public class SPARQLServer {
    private ServerConfig serverConfig;
    private Server server = null;
    private boolean verboseLogging = false;
    private static List<String> epDataset;
    public static boolean \u00fcberServlet;

    public SPARQLServer(ServerConfig config) {
        this.serverConfig = config;
        this.verboseLogging = config.verboseLogging;
        ServletContextHandler context = this.buildServer(this.serverConfig.jettyConfigFile, config.enableCompression);
        for (DatasetRef sDesc : this.serverConfig.services) {
            this.configureOneDataset(context, sDesc, config.enableCompression);
        }
    }

    public void start() {
        String now = Utils.nowAsString();
        Fuseki.serverLog.info(String.format("%s %s %s", "Fuseki", Fuseki.VERSION, Fuseki.BUILD_DATE));
        String host = this.server.getConnectors()[0].getHost();
        if (host != null) {
            Fuseki.serverLog.info("Incoming connections limited to " + host);
        }
        Fuseki.serverLog.info(String.format("Started %s on port %d", now, this.server.getConnectors()[0].getPort()));
        try {
            this.server.start();
        }
        catch (BindException ex) {
            Fuseki.serverLog.error("SPARQLServer: Failed to start server: " + ex.getMessage());
            System.exit(1);
        }
        catch (Exception ex) {
            Fuseki.serverLog.error("SPARQLServer: Failed to start server: " + ex.getMessage(), (Throwable)ex);
            System.exit(1);
        }
        ServletContextHandler context = (ServletContextHandler)this.server.getHandler();
    }

    public void stop() {
        String now = Utils.nowAsString();
        Fuseki.serverLog.info(String.format("Stopped %s on port %d", now, this.server.getConnectors()[0].getPort()));
        try {
            this.server.stop();
        }
        catch (Exception ex) {
            Fuseki.serverLog.warn("SPARQLServer: Exception while stopping server: " + ex.getMessage(), (Throwable)ex);
        }
    }

    public Server getServer() {
        return this.server;
    }

    public List<DatasetRef> getDatasets() {
        return this.serverConfig.services;
    }

    public ServerConfig getServerConfig() {
        return this.serverConfig;
    }

    private ServletContextHandler buildServer(String jettyConfig, boolean enableCompression) {
        this.server = jettyConfig != null ? SPARQLServer.configServer(jettyConfig) : SPARQLServer.defaultServerConfig(this.serverConfig.port);
        ServletContextHandler context = new ServletContextHandler(1);
        context.setErrorHandler((ErrorHandler)new FusekiErrorHandler());
        context.getServletContext().getContextHandler().setMaxFormContentSize(10000000);
        this.server.setHandler((Handler)context);
        MimeTypes mt = new MimeTypes();
        mt.addMimeMapping("rdf", "application/rdf+xml;charset=utf-8");
        mt.addMimeMapping("ttl", "text/turtle;charset=utf-8");
        mt.addMimeMapping("nt", "application/n-triples;charset=ascii");
        mt.addMimeMapping("nq", "text/nquads;charset=ascii");
        mt.addMimeMapping("trig", "application/trig;charset=utf-8");
        context.setMimeTypes(mt);
        this.server.setHandler((Handler)context);
        Fuseki.serverLog.debug("Pages = " + this.serverConfig.pages);
        boolean installManager = true;
        boolean installServices = true;
        String validationRoot = "/validate";
        String sparqlProcessor = "/sparql";
        if (installManager || installServices) {
            if (this.serverConfig.pagesPort != this.serverConfig.port) {
                Fuseki.serverLog.warn("Not supported yet - pages on a different port to services");
            }
            String base = this.serverConfig.pages;
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("mgt", new MgtFunctions());
            SimpleVelocityServlet templateEngine = new SimpleVelocityServlet(base, data);
            SPARQLServer.addServlet(context, templateEngine, "*.tpl", false);
        }
        if (installManager) {
            ActionDataset datasetChooser = new ActionDataset();
            SPARQLServer.addServlet(context, datasetChooser, "/$/datasets", false);
        }
        if (installServices) {
            QueryValidator validateQuery = new QueryValidator();
            UpdateValidator validateUpdate = new UpdateValidator();
            DataValidator validateData = new DataValidator();
            IRIValidator validateIRI = new IRIValidator();
            DumpServlet dumpService = new DumpServlet();
            SPARQL_QueryGeneral generalQueryService = new SPARQL_QueryGeneral();
            SPARQLServer.addServlet(context, validateQuery, validationRoot + "/query", false);
            SPARQLServer.addServlet(context, validateUpdate, validationRoot + "/update", false);
            SPARQLServer.addServlet(context, validateData, validationRoot + "/data", false);
            SPARQLServer.addServlet(context, validateIRI, validationRoot + "/iri", false);
            SPARQLServer.addServlet(context, dumpService, "/dump", false);
            SPARQLServer.addServlet(context, generalQueryService, sparqlProcessor, enableCompression);
        }
        if (installManager || installServices) {
            String[] files = new String[]{"fuseki.html", "index.html"};
            context.setWelcomeFiles(files);
            SPARQLServer.addContent(context, "/", this.serverConfig.pages);
        }
        return context;
    }

    private void configureOneDataset(ServletContextHandler context, DatasetRef sDesc, boolean enableCompression) {
        String datasetPath = sDesc.name;
        if (datasetPath.equals("/")) {
            datasetPath = "";
        } else if (!datasetPath.startsWith("/")) {
            datasetPath = "/" + datasetPath;
        }
        if (datasetPath.endsWith("/")) {
            datasetPath = datasetPath.substring(0, datasetPath.length() - 1);
        }
        DatasetRegistry.get().put(datasetPath, sDesc);
        Fuseki.serverLog.info(String.format("Dataset path = %s", datasetPath));
        SPARQL_QueryDataset sparqlQuery = new SPARQL_QueryDataset(this.verboseLogging);
        SPARQL_Update sparqlUpdate = new SPARQL_Update(this.verboseLogging);
        SPARQL_Upload sparqlUpload = new SPARQL_Upload(this.verboseLogging);
        SPARQL_REST_R sparqlHttpR = new SPARQL_REST_R(this.verboseLogging);
        SPARQL_REST_RW sparqlHttpRW = new SPARQL_REST_RW(this.verboseLogging);
        SPARQL_UberServlet.AccessByConfig sparqlDataset = new SPARQL_UberServlet.AccessByConfig(this.verboseLogging);
        if (!\u00fcberServlet) {
            SPARQLServer.addServlet(context, datasetPath, sparqlQuery, sDesc.queryEP, enableCompression);
            SPARQLServer.addServlet(context, datasetPath, sparqlUpdate, sDesc.updateEP, false);
            SPARQLServer.addServlet(context, datasetPath, sparqlUpload, sDesc.uploadEP, false);
            SPARQLServer.addServlet(context, datasetPath, sparqlHttpR, sDesc.readGraphStoreEP, enableCompression);
            SPARQLServer.addServlet(context, datasetPath, sparqlHttpRW, sDesc.readWriteGraphStoreEP, enableCompression);
        } else {
            SPARQLServer.addServlet(context, datasetPath, sparqlDataset, epDataset, enableCompression);
        }
    }

    private static Server configServer(String jettyConfig) {
        try {
            Fuseki.serverLog.info("Jetty server config file = " + jettyConfig);
            Server server = new Server();
            XmlConfiguration configuration = new XmlConfiguration((InputStream)new FileInputStream(jettyConfig));
            configuration.configure((Object)server);
            return server;
        }
        catch (Exception ex) {
            Fuseki.serverLog.error("SPARQLServer: Failed to configure server: " + ex.getMessage(), (Throwable)ex);
            throw new FusekiException("Failed to configure a server using configuration file '" + jettyConfig + "'");
        }
    }

    private static Server defaultServerConfig(int port) {
        BlockingChannelConnector bcConnector;
        Server server = new Server();
        BlockingChannelConnector connector = bcConnector = new BlockingChannelConnector();
        connector.setMaxIdleTime(0);
        connector.setPort(port);
        connector.setRequestHeaderSize(65536);
        connector.setRequestBufferSize(0x500000);
        connector.setResponseBufferSize(0x500000);
        server.addConnector((Connector)connector);
        return server;
    }

    private static void addContent(ServletContextHandler context, String pathSpec, String pages) {
        DefaultServlet staticServlet = new DefaultServlet();
        ServletHolder staticContent = new ServletHolder((Servlet)staticServlet);
        staticContent.setInitParameter("resourceBase", pages);
        SPARQLServer.addServlet(context, staticContent, pathSpec, false);
    }

    private static void addServlet(ServletContextHandler context, String datasetPath, HttpServlet servlet, List<String> pathSpecs, boolean enableCompression) {
        for (String pathSpec : pathSpecs) {
            if (pathSpec.equals("")) {
                SPARQLServer.addServlet(context, servlet, datasetPath + "/", enableCompression);
                SPARQLServer.addServlet(context, servlet, datasetPath, enableCompression);
                continue;
            }
            if (pathSpec.endsWith("/")) {
                pathSpec = pathSpec.substring(0, pathSpec.length() - 1);
            }
            if (pathSpec.startsWith("/")) {
                pathSpec = pathSpec.substring(1, pathSpec.length());
            }
            SPARQLServer.addServlet(context, servlet, datasetPath + "/" + pathSpec, enableCompression);
        }
    }

    private static void addServlet(ServletContextHandler context, HttpServlet servlet, String pathSpec, boolean enableCompression) {
        ServletHolder holder = new ServletHolder((Servlet)servlet);
        SPARQLServer.addServlet(context, holder, pathSpec, enableCompression);
    }

    private static void addServlet(ServletContextHandler context, ServletHolder holder, String pathSpec, boolean enableCompression) {
        if (Fuseki.serverLog.isDebugEnabled()) {
            if (enableCompression) {
                Fuseki.serverLog.debug("Add servlet @ " + pathSpec + " (with gzip)");
            } else {
                Fuseki.serverLog.debug("Add servlet @ " + pathSpec);
            }
        }
        context.addServlet(holder, pathSpec);
        if (enableCompression) {
            context.addFilter(GzipFilter.class, pathSpec, EnumSet.allOf(DispatcherType.class));
        }
    }

    static {
        Fuseki.init();
        epDataset = Arrays.asList("*");
        \u00fcberServlet = false;
    }
}

