/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.servlets;

import java.util.ConcurrentModificationException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.jena.fuseki.Fuseki;
import org.slf4j.Logger;

public final class ConcurrencyPolicyMRSW {
    private static Logger log = Fuseki.requestLog;
    private static final boolean logging = false;
    private final AtomicLong readCounter = new AtomicLong(0L);
    private final AtomicLong writeCounter = new AtomicLong(0L);
    private static final AtomicLong policyCounter = new AtomicLong(0L);

    public ConcurrencyPolicyMRSW() {
        policyCounter.incrementAndGet();
    }

    public void startRead() {
        this.readCounter.getAndIncrement();
        this.log();
        this.checkConcurrency();
    }

    public void finishRead() {
        this.log();
        this.readCounter.decrementAndGet();
        this.checkConcurrency();
    }

    public void startUpdate() {
        this.writeCounter.getAndIncrement();
        this.log();
        this.checkConcurrency();
    }

    public void finishUpdate() {
        this.log();
        this.writeCounter.decrementAndGet();
        this.checkConcurrency();
    }

    private synchronized void checkConcurrency() {
        long R = this.readCounter.get();
        long W = this.writeCounter.get();
        long id = policyCounter.get();
        if (R > 0L && W > 0L) {
            ConcurrencyPolicyMRSW.policyError(id, R, W);
        }
        if (W > 1L) {
            ConcurrencyPolicyMRSW.policyError(id, R, W);
        }
    }

    private void log() {
    }

    private static void policyError(long id, long R, long W) {
        ConcurrencyPolicyMRSW.policyError(ConcurrencyPolicyMRSW.format(id, R, W));
    }

    private static void policyError(String message) {
        throw new ConcurrentModificationException(message);
    }

    private static String format(long id, long R, long W) {
        return String.format("(lock=%d) Reader = %d, Writer = %d", id, R, W);
    }
}

