/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.servlets;

import com.hp.hpl.jena.sparql.core.DatasetGraph;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.jena.fuseki.FusekiLib;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.fuseki.servlets.SPARQL_REST;
import org.openjena.atlas.web.MediaType;
import org.openjena.atlas.web.TypedOutputStream;
import org.openjena.riot.Lang;
import org.openjena.riot.RiotWriter;

public class REST_Quads
extends SPARQL_REST {
    public REST_Quads(boolean verbose) {
        super(verbose);
    }

    @Override
    protected void validate(HttpServletRequest request) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doGet(SPARQL_REST.HttpActionREST action) {
        ServletOutputStream output;
        MediaType mediaType = HttpAction.contentNegotationQuads(action);
        try {
            output = action.response.getOutputStream();
        }
        catch (IOException ex) {
            REST_Quads.errorOccurred(ex);
            output = null;
        }
        TypedOutputStream out = new TypedOutputStream((OutputStream)output, mediaType);
        Lang lang = FusekiLib.langFromContentType(mediaType.getContentType());
        if (lang == null) {
            lang = Lang.TRIG;
        }
        if (action.verbose) {
            log.info(String.format("[%d]   Get: Content-Type=%s, Charset=%s => %s", action.id, mediaType.getContentType(), mediaType.getCharset(), lang.getName()));
        }
        if (!lang.isQuads()) {
            REST_Quads.errorBadRequest("Not a quads format: " + mediaType);
        }
        action.beginRead();
        try {
            DatasetGraph dsg = action.getActiveDSG();
            if (lang == Lang.NQUADS) {
                RiotWriter.writeNQuads((OutputStream)out, (DatasetGraph)dsg);
            } else if (lang == Lang.TRIG) {
                REST_Quads.errorBadRequest("TriG - Not implemented (yet) : " + mediaType);
            } else {
                REST_Quads.errorBadRequest("No handled: " + mediaType);
            }
            REST_Quads.success(action);
        }
        finally {
            action.endRead();
        }
    }

    @Override
    protected void doOptions(SPARQL_REST.HttpActionREST action) {
        action.response.setHeader("Allow", "GET, HEAD, OPTIONS");
        action.response.setHeader("Content-Length", "0");
        REST_Quads.success(action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doHead(SPARQL_REST.HttpActionREST action) {
        action.beginRead();
        try {
            MediaType mediaType = HttpAction.contentNegotationQuads(action);
            REST_Quads.success(action);
        }
        finally {
            action.endRead();
        }
    }

    @Override
    protected void doPost(SPARQL_REST.HttpActionREST action) {
        REST_Quads.errorMethodNotAllowed("POST");
    }

    @Override
    protected void doDelete(SPARQL_REST.HttpActionREST action) {
        REST_Quads.errorMethodNotAllowed("DELETE");
    }

    @Override
    protected void doPut(SPARQL_REST.HttpActionREST action) {
        REST_Quads.errorMethodNotAllowed("PUT");
    }

    @Override
    protected void doPatch(SPARQL_REST.HttpActionREST action) {
        REST_Quads.errorMethodNotAllowed("PATCH");
    }
}

