/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.servlets;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryParseException;
import com.hp.hpl.jena.sparql.core.DatasetDescription;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jena.fuseki.server.DatasetRef;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.fuseki.servlets.SPARQL_Query;
import org.apache.jena.fuseki.servlets.SPARQL_ServletBase;
import org.openjena.atlas.iterator.Filter;
import org.openjena.atlas.iterator.Iter;
import org.openjena.atlas.lib.Lib;

public abstract class SPARQL_Protocol
extends SPARQL_ServletBase {
    private static Filter<String> acceptNonEmpty = new Filter<String>(){

        public boolean accept(String item) {
            return item != null && item.length() != 0;
        }
    };

    protected SPARQL_Protocol(boolean verbose_debug) {
        super(verbose_debug);
    }

    protected static String messageForQPE(QueryParseException ex) {
        if (ex.getMessage() != null) {
            return ex.getMessage();
        }
        if (ex.getCause() != null) {
            return Lib.classShortName(ex.getCause().getClass());
        }
        return null;
    }

    protected static DatasetDescription getDatasetDescription(SPARQL_Query.HttpActionQuery action) {
        List<String> graphURLs = SPARQL_Protocol.toStrList(action.request.getParameterValues("default-graph-uri"));
        List<String> namedGraphs = SPARQL_Protocol.toStrList(action.request.getParameterValues("named-graph-uri"));
        graphURLs = SPARQL_Protocol.removeEmptyValues(graphURLs);
        namedGraphs = SPARQL_Protocol.removeEmptyValues(namedGraphs);
        if (graphURLs.size() == 0 && namedGraphs.size() == 0) {
            return null;
        }
        return DatasetDescription.create(graphURLs, namedGraphs);
    }

    protected static DatasetDescription getDatasetDescription(Query query) {
        return DatasetDescription.create((Query)query);
    }

    private static List<String> toStrList(String[] array) {
        if (array == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(array);
    }

    private static List<String> removeEmptyValues(List<String> list) {
        return Iter.iter(list).filter(acceptNonEmpty).toList();
    }

    protected static int countParamOccurences(HttpServletRequest request, String param) {
        String[] x = request.getParameterValues(param);
        if (x == null) {
            return 0;
        }
        return x.length;
    }

    protected class HttpActionProtocol
    extends HttpAction {
        public HttpActionProtocol(long id, DatasetRef desc, HttpServletRequest request, HttpServletResponse response, boolean verbose) {
            super(id, desc, request, response, verbose);
        }
    }
}

