/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.servlets;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.DatasetGraphFactory;
import com.hp.hpl.jena.sparql.graph.GraphFactory;
import com.hp.hpl.jena.util.FileUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jena.fuseki.FusekiLib;
import org.apache.jena.fuseki.server.DatasetRef;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.fuseki.servlets.SPARQL_Protocol;
import org.apache.jena.fuseki.servlets.SPARQL_ServletBase;
import org.apache.jena.fuseki.servlets.ServletBase;
import org.openjena.atlas.lib.Sink;
import org.openjena.atlas.web.ContentType;
import org.openjena.riot.ErrorHandler;
import org.openjena.riot.ErrorHandlerFactory;
import org.openjena.riot.Lang;
import org.openjena.riot.RiotException;
import org.openjena.riot.RiotReader;
import org.openjena.riot.lang.LangRIOT;
import org.openjena.riot.lang.SinkTriplesToGraph;
import org.openjena.riot.system.IRIResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SPARQL_REST
extends SPARQL_ServletBase {
    protected static Logger classLog = LoggerFactory.getLogger(SPARQL_REST.class);
    protected static ErrorHandler errorHandler = ErrorHandlerFactory.errorHandlerStd((Logger)log);

    public SPARQL_REST(boolean verbose) {
        super(verbose);
    }

    public SPARQL_REST() {
        this(false);
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doCommon(request, response);
    }

    private void maybeSetLastModified(HttpServletResponse resp, long lastModified) {
        if (resp.containsHeader("Last-Modified")) {
            return;
        }
        if (lastModified >= 0L) {
            resp.setDateHeader("Last-Modified", lastModified);
        }
    }

    @Override
    protected void perform(long id, DatasetRef desc, HttpServletRequest request, HttpServletResponse response) {
        this.validate(request);
        HttpActionREST action = new HttpActionREST(id, desc, request, response, this.verbose_debug);
        this.dispatch(action);
    }

    private void dispatch(HttpActionREST action) {
        HttpServletRequest req = action.request;
        HttpServletResponse resp = action.response;
        String method = req.getMethod().toUpperCase();
        if (method.equals("GET")) {
            this.doGet(action);
        } else if (method.equals("HEAD")) {
            this.doHead(action);
        } else if (method.equals("POST")) {
            this.doPost(action);
        } else if (method.equals("PATCH")) {
            this.doPatch(action);
        } else if (method.equals("OPTIONS")) {
            this.doOptions(action);
        } else if (method.equals("TRACE")) {
            SPARQL_REST.errorMethodNotAllowed("TRACE");
        } else if (method.equals("PUT")) {
            this.doPut(action);
        } else if (method.equals("DELETE")) {
            this.doDelete(action);
        } else {
            SPARQL_REST.errorNotImplemented("Unknown method: " + method);
        }
    }

    protected abstract void doGet(HttpActionREST var1);

    protected abstract void doHead(HttpActionREST var1);

    protected abstract void doPost(HttpActionREST var1);

    protected abstract void doPatch(HttpActionREST var1);

    protected abstract void doDelete(HttpActionREST var1);

    protected abstract void doPut(HttpActionREST var1);

    protected abstract void doOptions(HttpActionREST var1);

    protected static void deleteGraph(HttpActionREST action) {
        if (action.getTarget().isDefault) {
            action.getTarget().graph().getBulkUpdateHandler().removeAll();
        } else {
            action.getActiveDSG().removeGraph(action.getTarget().graphName);
        }
    }

    protected static void clearGraph(Target target) {
        if (!target.isGraphSet()) {
            Graph g = target.graph();
            g.getBulkUpdateHandler().removeAll();
        }
    }

    protected static void addDataInto(Graph data, HttpActionREST action) {
        try {
            Target dest = action.getTarget();
            Graph g = dest.graph();
            if (g == null) {
                if (dest.isDefault) {
                    SPARQL_REST.errorOccurred("Dataset does not have a default graph");
                }
                log.info(String.format("[%d] Creating in-memory graph for <%s>", action.id, dest.graphName));
                g = GraphFactory.createDefaultGraph();
                dest.dsg.addGraph(dest.graphName, g);
            }
            g.getBulkUpdateHandler().add(data);
        }
        catch (RuntimeException ex) {
            action.abort();
            SPARQL_REST.errorOccurred(ex.getMessage());
            return;
        }
    }

    protected static DatasetGraph parseBody(HttpActionREST action) {
        ContentType ct;
        String contentTypeHeader = action.request.getContentType();
        if (contentTypeHeader == null) {
            SPARQL_REST.errorBadRequest("No content type: " + contentTypeHeader);
        }
        if ("multipart/form".equalsIgnoreCase((ct = ContentType.parse((String)contentTypeHeader)).getContentType())) {
            SPARQL_REST.error(415, "multipart/form-data not supported");
            return null;
        }
        if ("multipart/mixed".equals(ct.getContentType())) {
            SPARQL_REST.error(415, "multipart/mixed not supported");
            return null;
        }
        int len = action.request.getContentLength();
        Lang lang = FusekiLib.langFromContentType(ct.getContentType());
        if (lang == null) {
            SPARQL_REST.errorBadRequest("Unknown content type for triples: " + contentTypeHeader);
            return null;
        }
        if (action.verbose) {
            if (len >= 0) {
                log.info(String.format("[%d]   Body: Content-Length=%d, Content-Type=%s, Charset=%s => %s", action.id, len, ct.getContentType(), ct.getCharset(), lang.getName()));
            } else {
                log.info(String.format("[%d]   Body: Content-Type=%s, Charset=%s => %s", action.id, ct.getContentType(), ct.getCharset(), lang.getName()));
            }
        }
        try {
            Object input = action.request.getInputStream();
            String base = SPARQL_REST.wholeRequestURL(action.request);
            boolean buffering = false;
            if (buffering) {
                if (len >= 0) {
                    byte[] b = new byte[len];
                    input.read(b);
                    input = new ByteArrayInputStream(b);
                } else {
                    String x = FileUtils.readWholeFileAsUTF8((InputStream)input);
                    input = new ByteArrayInputStream(x.getBytes("UTF-8"));
                }
            }
            return SPARQL_REST.parse(action, lang, base, (InputStream)input);
        }
        catch (IOException ex) {
            SPARQL_REST.errorOccurred(ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DatasetGraph parse(HttpActionREST action, Lang lang, String base, InputStream input) {
        Graph graphTmp = GraphFactory.createGraphMem();
        SinkTriplesToGraph sink = new SinkTriplesToGraph(graphTmp);
        LangRIOT parser = RiotReader.createParserTriples((InputStream)input, (Lang)lang, (String)base, (Sink)sink);
        parser.getProfile().setHandler(errorHandler);
        try {
            parser.parse();
        }
        catch (RiotException ex) {
            SPARQL_REST.errorBadRequest("Parse error: " + ex.getMessage());
        }
        finally {
            sink.close();
        }
        DatasetGraph dsgTmp = DatasetGraphFactory.create((Graph)graphTmp);
        return dsgTmp;
    }

    @Override
    protected void validate(HttpServletRequest request) {
        if (request.getQueryString() == null) {
            return;
        }
        String g = request.getParameter("graph");
        String d = request.getParameter("default");
        if (g != null && d != null) {
            SPARQL_REST.errorBadRequest("Both ?default and ?graph in the query string of the request");
        }
        if (g == null && d == null) {
            SPARQL_REST.errorBadRequest("Neither ?default nor ?graph in the query string of the request");
        }
        int x1 = SPARQL_Protocol.countParamOccurences(request, "graph");
        int x2 = SPARQL_Protocol.countParamOccurences(request, "default");
        if (x1 > 1) {
            SPARQL_REST.errorBadRequest("Multiple ?default in the query string of the request");
        }
        if (x2 > 1) {
            SPARQL_REST.errorBadRequest("Multiple ?graph in the query string of the request");
        }
        Enumeration en = request.getParameterNames();
        while (en.hasMoreElements()) {
            String h = (String)en.nextElement();
            if (!"graph".equals(h) && !"default".equals(h)) {
                SPARQL_REST.errorBadRequest("Unknown parameter '" + h + "'");
            }
            if (request.getParameterValues(h).length == 1) continue;
            SPARQL_REST.errorBadRequest("Multiple parameters '" + h + "'");
        }
    }

    protected static Target targetGraph(HttpServletRequest request, DatasetRef desc, DatasetGraph dsg) {
        boolean dftGraph = SPARQL_REST.getOneOnly(request, "default") != null;
        String uri = SPARQL_REST.getOneOnly(request, "graph");
        if (!dftGraph && uri == null) {
            uri = request.getRequestURL().toString();
            if (request.getRequestURI().equals(desc.name)) {
                SPARQL_REST.errorBadRequest("Neither default graph nor named graph specificed; no direct name");
            }
        }
        if (dftGraph) {
            return Target.createDefault(dsg);
        }
        if (uri.equals("default")) {
            return Target.createDefault(dsg);
        }
        String base = request.getRequestURL().toString();
        if (request.getQueryString() != null && !base.endsWith("/")) {
            base = base + "/";
        }
        String absUri = IRIResolver.resolveString((String)uri, (String)base);
        Node gn = Node.createURI((String)absUri);
        return Target.createNamed(dsg, absUri, gn);
    }

    protected static String getOneOnly(HttpServletRequest request, String name) {
        String[] values = request.getParameterValues(name);
        if (values == null) {
            return null;
        }
        if (values.length == 0) {
            return null;
        }
        if (values.length > 1) {
            SPARQL_REST.errorBadRequest("Multiple occurrences of '" + name + "'");
        }
        return values[0];
    }

    protected static final class Target {
        final boolean isDefault;
        final DatasetGraph dsg;
        private Graph _graph;
        final String name;
        final Node graphName;

        static Target createNamed(DatasetGraph dsg, String name, Node graphName) {
            return new Target(false, dsg, name, graphName);
        }

        static Target createDefault(DatasetGraph dsg) {
            return new Target(true, dsg, null, null);
        }

        private Target(boolean isDefault, DatasetGraph dsg, String name, Node graphName) {
            this.isDefault = isDefault;
            this.dsg = dsg;
            this._graph = null;
            this.name = name;
            this.graphName = graphName;
            if (isDefault) {
                if (name != null || graphName != null) {
                    throw new IllegalArgumentException("Inconsistent: default and a graph name/node");
                }
            } else if (name == null || graphName == null) {
                throw new IllegalArgumentException("Inconsistent: not default and/or no graph name/node");
            }
        }

        public Graph graph() {
            if (!this.isGraphSet()) {
                this._graph = this.isDefault ? this.dsg.getDefaultGraph() : this.dsg.getGraph(this.graphName);
            }
            return this._graph;
        }

        public boolean exists() {
            if (this.isDefault) {
                return true;
            }
            return this.dsg.containsGraph(this.graphName);
        }

        public boolean isGraphSet() {
            return this._graph != null;
        }

        public String toString() {
            if (this.isDefault) {
                return "default";
            }
            return this.name;
        }
    }

    public static class HttpActionREST
    extends HttpAction {
        private Target _target = null;

        HttpActionREST(long id, DatasetRef desc, String absUri, HttpServletRequest request, HttpServletResponse response, boolean verbose) {
            super(id, desc, request, response, verbose);
            Node gn = Node.createURI((String)absUri);
            this._target = Target.createNamed(desc.dataset, absUri, gn);
        }

        protected HttpActionREST(long id, DatasetRef desc, HttpServletRequest request, HttpServletResponse response, boolean verbose) {
            super(id, desc, request, response, verbose);
        }

        protected final boolean hasTarget() {
            return true;
        }

        protected final Target getTarget() {
            if (this._target == null) {
                if (super.getActiveDSG() == null) {
                    ServletBase.errorOccurred("Internal error : No action graph (not in a transaction?)");
                }
                this._target = SPARQL_REST.targetGraph(this.request, super.getDatasetRef(), super.getActiveDSG());
            }
            return this._target;
        }
    }
}

