/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.servlets;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import javax.servlet.ServletOutputStream;
import org.apache.jena.fuseki.FusekiLib;
import org.apache.jena.fuseki.server.DatasetRegistry;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.fuseki.servlets.SPARQL_REST;
import org.openjena.atlas.web.MediaType;
import org.openjena.atlas.web.TypedOutputStream;
import org.openjena.riot.Lang;

public class SPARQL_REST_R
extends SPARQL_REST {
    public SPARQL_REST_R(boolean verbose) {
        super(verbose);
    }

    public SPARQL_REST_R() {
        this(false);
    }

    @Override
    protected String mapRequestToDataset(String uri) {
        if (uri == null) {
            return null;
        }
        String ds = null;
        Iterator<String> iter = DatasetRegistry.get().keys();
        while (iter.hasNext()) {
            String ds2 = iter.next();
            if (!uri.startsWith(ds2)) continue;
            if (ds == null) {
                ds = ds2;
                continue;
            }
            if (ds.length() <= ds2.length()) continue;
            ds = ds2;
        }
        return ds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doGet(SPARQL_REST.HttpActionREST action) {
        ServletOutputStream output;
        MediaType mediaType = HttpAction.contentNegotationRDF(action);
        try {
            output = action.response.getOutputStream();
        }
        catch (IOException ex) {
            SPARQL_REST_R.errorOccurred(ex);
            output = null;
        }
        TypedOutputStream out = new TypedOutputStream((OutputStream)output, mediaType);
        Lang lang = FusekiLib.langFromContentType(mediaType.getContentType());
        if (action.verbose) {
            log.info(String.format("[%d]   Get: Content-Type=%s, Charset=%s => %s", action.id, mediaType.getContentType(), mediaType.getCharset(), lang.getName()));
        }
        action.beginRead();
        try {
            boolean exists;
            if (log.isDebugEnabled()) {
                log.debug("GET->" + action.getTarget());
            }
            if (!(exists = action.getTarget().exists())) {
                SPARQL_REST_R.errorNotFound("No such graph: <" + action.getTarget().name + ">");
            }
            RDFWriter writer = FusekiLib.chooseWriter(lang);
            Model model = ModelFactory.createModelForGraph((Graph)action.getTarget().graph());
            writer.write(model, (OutputStream)out, null);
            SPARQL_REST_R.success(action);
        }
        finally {
            action.endRead();
        }
    }

    @Override
    protected void doOptions(SPARQL_REST.HttpActionREST action) {
        action.response.setHeader("Allow", "GET,HEAD,OPTIONS");
        action.response.setHeader("Content-Length", "0");
        SPARQL_REST_R.success(action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doHead(SPARQL_REST.HttpActionREST action) {
        action.beginRead();
        try {
            if (log.isDebugEnabled()) {
                log.debug("HEAD->" + action.getTarget());
            }
            if (!action.getTarget().exists()) {
                SPARQL_REST_R.successNotFound(action);
                return;
            }
            MediaType mediaType = HttpAction.contentNegotationRDF(action);
            SPARQL_REST_R.success(action);
        }
        finally {
            action.endRead();
        }
    }

    @Override
    protected void doPost(SPARQL_REST.HttpActionREST action) {
        SPARQL_REST_R.errorMethodNotAllowed("POST");
    }

    @Override
    protected void doDelete(SPARQL_REST.HttpActionREST action) {
        SPARQL_REST_R.errorMethodNotAllowed("DELETE");
    }

    @Override
    protected void doPut(SPARQL_REST.HttpActionREST action) {
        SPARQL_REST_R.errorMethodNotAllowed("PUT");
    }

    @Override
    protected void doPatch(SPARQL_REST.HttpActionREST action) {
        SPARQL_REST_R.errorMethodNotAllowed("PATCH");
    }
}

