/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.servlets;

import com.hp.hpl.jena.sparql.core.DatasetGraph;
import org.apache.jena.fuseki.servlets.SPARQL_REST;
import org.apache.jena.fuseki.servlets.SPARQL_REST_R;
import org.apache.jena.fuseki.servlets.SPARQL_ServletBase;

public class SPARQL_REST_RW
extends SPARQL_REST_R {
    public SPARQL_REST_RW(boolean verbose) {
        super(verbose);
    }

    public SPARQL_REST_RW() {
        this(false);
    }

    @Override
    protected void doOptions(SPARQL_REST.HttpActionREST action) {
        action.response.setHeader("Allow", "GET,HEAD,OPTIONS,PUT,DELETE,POST");
        action.response.setHeader("Content-Length", "0");
        SPARQL_REST_RW.success(action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doDelete(SPARQL_REST.HttpActionREST action) {
        action.beginWrite();
        try {
            boolean existedBefore;
            if (log.isDebugEnabled()) {
                log.debug("DELETE->" + action.getTarget());
            }
            if (!(existedBefore = action.getTarget().exists())) {
                action.commit();
                SPARQL_REST_RW.errorNotFound("No such graph: " + action.getTarget().name);
            }
            SPARQL_REST_RW.deleteGraph(action);
            action.commit();
        }
        finally {
            action.endWrite();
        }
        SPARQL_ServletBase.successNoContent(action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doPut(SPARQL_REST.HttpActionREST action) {
        DatasetGraph body = SPARQL_REST_RW.parseBody(action);
        action.beginWrite();
        boolean existedBefore = false;
        try {
            if (log.isDebugEnabled()) {
                log.debug("PUT->" + action.getTarget());
            }
            if (existedBefore = action.getTarget().exists()) {
                SPARQL_REST_RW.clearGraph(action.getTarget());
            }
            SPARQL_REST_RW.addDataInto(body.getDefaultGraph(), action);
            action.commit();
        }
        finally {
            action.endWrite();
        }
        if (existedBefore) {
            SPARQL_ServletBase.successNoContent(action);
        } else {
            SPARQL_ServletBase.successCreated(action);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doPost(SPARQL_REST.HttpActionREST action) {
        boolean existedBefore;
        DatasetGraph body = SPARQL_REST_RW.parseBody(action);
        action.beginWrite();
        try {
            if (log.isDebugEnabled()) {
                log.debug("POST->" + action.getTarget());
            }
            existedBefore = action.getTarget().exists();
            SPARQL_REST_RW.addDataInto(body.getDefaultGraph(), action);
            action.commit();
        }
        finally {
            action.endWrite();
        }
        if (existedBefore) {
            SPARQL_ServletBase.successNoContent(action);
        } else {
            SPARQL_ServletBase.successCreated(action);
        }
    }
}

