/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.servlets;

import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jena.fuseki.DEF;
import org.apache.jena.fuseki.conneg.ConNeg;
import org.apache.jena.fuseki.server.DatasetRef;
import org.apache.jena.fuseki.server.DatasetRegistry;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.fuseki.servlets.REST_Quads;
import org.apache.jena.fuseki.servlets.SPARQL_QueryDataset;
import org.apache.jena.fuseki.servlets.SPARQL_REST;
import org.apache.jena.fuseki.servlets.SPARQL_REST_R;
import org.apache.jena.fuseki.servlets.SPARQL_REST_RW;
import org.apache.jena.fuseki.servlets.SPARQL_ServletBase;
import org.apache.jena.fuseki.servlets.SPARQL_Update;
import org.apache.jena.fuseki.servlets.SPARQL_Upload;
import org.openjena.atlas.iterator.Filter;
import org.openjena.atlas.iterator.Iter;
import org.openjena.atlas.web.MediaType;

public abstract class SPARQL_UberServlet
extends SPARQL_ServletBase {
    private final SPARQL_ServletBase queryServlet;
    private final SPARQL_ServletBase updateServlet;
    private final SPARQL_ServletBase uploadServlet;
    private final SPARQL_REST restServlet_RW;
    private final SPARQL_REST restServlet_R;
    private final SPARQL_ServletBase restQuads;

    protected abstract boolean allowQuery(HttpAction var1);

    protected abstract boolean allowUpdate(HttpAction var1);

    protected abstract boolean allowREST_R(HttpAction var1);

    protected abstract boolean allowREST_W(HttpAction var1);

    protected abstract boolean allowQuadsR(HttpAction var1);

    protected abstract boolean allowQuadsW(HttpAction var1);

    public SPARQL_UberServlet(boolean verbose_debug) {
        super(verbose_debug);
        this.queryServlet = new SPARQL_QueryDataset(this.verbose_debug);
        this.updateServlet = new SPARQL_Update(this.verbose_debug);
        this.uploadServlet = new SPARQL_Upload(this.verbose_debug);
        this.restServlet_RW = new SPARQL_REST_RW(this.verbose_debug);
        this.restServlet_R = new SPARQL_REST_R(this.verbose_debug);
        this.restQuads = new REST_Quads(this.verbose_debug);
    }

    private String getEPName(String dsname, List<String> endpoints) {
        if (endpoints == null || endpoints.size() == 0) {
            return null;
        }
        String x = endpoints.get(0);
        x = !dsname.endsWith("/") ? dsname + "/" + x : dsname + x;
        return x;
    }

    @Override
    protected void validate(HttpServletRequest request) {
    }

    @Override
    protected void doCommonWorker(long id, HttpServletRequest request, HttpServletResponse response) {
        boolean hasTrailing;
        String uri = request.getRequestURI();
        String method = request.getMethod();
        String dsname = SPARQL_UberServlet.findDataset(uri);
        String trailing = SPARQL_UberServlet.findTrailing(uri, dsname);
        String qs = request.getQueryString();
        boolean hasParams = request.getParameterMap().size() > 0;
        boolean hasParamQuery = request.getParameter("query") != null;
        boolean hasParamUpdate = request.getParameter("update") != null || request.getParameter("request") != null;
        boolean hasParamGraph = request.getParameter("graph") != null;
        boolean hasParamGraphDefault = request.getParameter("default") != null;
        boolean isForm = "application/x-www-form-urlencoded".equalsIgnoreCase(request.getContentType());
        String ct = request.getContentType();
        String charset = request.getCharacterEncoding();
        MediaType mt = null;
        if (ct != null) {
            mt = MediaType.create((String)ct, (String)charset);
        }
        DatasetRef desc = (DatasetRef)DatasetRegistry.get().get(dsname);
        HttpAction action = new HttpAction(id, desc, request, response, this.verbose_debug);
        log.info(String.format("[%d] All: %s %s :: '%s' :: %s ? %s", id, method, dsname, trailing, mt == null ? "<none>" : mt, qs == null ? "" : qs));
        boolean bl = hasTrailing = trailing.length() != 0;
        if (!hasTrailing && !hasParams) {
            SPARQL_UberServlet.errorBadRequest("Request not support (quad operation)");
            return;
        }
        if (!hasTrailing) {
            if (hasParamQuery || "application/sparql-query".equalsIgnoreCase(ct)) {
                if (!this.allowQuery(action)) {
                    SPARQL_UberServlet.errorForbidden("Forbidden: SPARQL query");
                }
                this.executeRequest(desc, this.queryServlet, desc.queryEP, id, request, response);
                return;
            }
            if (hasParamUpdate || "application/sparql-update".equalsIgnoreCase(ct)) {
                if (!this.allowQuery(action)) {
                    SPARQL_UberServlet.errorForbidden("Forbidden: SPARQL query");
                }
                this.executeRequest(desc, this.updateServlet, desc.updateEP, id, request, response);
                return;
            }
            if (hasParamGraph || hasParamGraphDefault) {
                this.doGraphStoreProtocol(action);
                return;
            }
            SPARQL_UberServlet.errorBadRequest("Malformed request");
        }
        boolean checkForPossibleService = true;
        if (this.checkDispatch(desc.queryEP, trailing, this.queryServlet, desc, id, request, response)) {
            return;
        }
        if (this.checkDispatch(desc.updateEP, trailing, this.updateServlet, desc, id, request, response)) {
            return;
        }
        if (this.checkDispatch(desc.uploadEP, trailing, this.uploadServlet, desc, id, request, response)) {
            return;
        }
        if (this.checkDispatch(desc.readGraphStoreEP, trailing, this.restServlet_R, desc, id, request, response)) {
            return;
        }
        if (this.checkDispatch(desc.readWriteGraphStoreEP, trailing, this.restServlet_RW, desc, id, request, response)) {
            return;
        }
        if (hasParams) {
            SPARQL_UberServlet.errorBadRequest("Can't invoke a query-string service on a direct named graph");
        }
        this.doGraphStoreProtocol(action);
    }

    private void doGraphStoreProtocol(HttpAction action) {
        DatasetRef desc = action.getDatasetRef();
        String method = action.request.getMethod();
        if ("GET".equalsIgnoreCase(method) || "HEAD".equalsIgnoreCase(method)) {
            if (!this.allowREST_R(action)) {
                SPARQL_UberServlet.errorForbidden("Forbidden: SPARQL Graph Store Protocol : Read operation : " + method);
            }
            if (desc.readGraphStoreEP.size() > 0) {
                this.executeRequest(desc, this.restServlet_R, desc.readGraphStoreEP, action.id, action.request, action.response);
            } else if (desc.readWriteGraphStoreEP.size() > 0) {
                this.executeRequest(desc, this.restServlet_RW, desc.readWriteGraphStoreEP, action.id, action.request, action.response);
            } else {
                SPARQL_UberServlet.errorMethodNotAllowed(method);
            }
            return;
        }
        if (!this.allowREST_W(action)) {
            SPARQL_UberServlet.errorForbidden("Forbidden: SPARQL Graph Store Protocol : Write operation : " + method);
        }
        this.executeRequest(desc, this.restServlet_RW, desc.readWriteGraphStoreEP, action.id, action.request, action.response);
    }

    private void executeRequest(DatasetRef desc, SPARQL_ServletBase servlet, List<String> endpointList, long id, HttpServletRequest request, HttpServletResponse response) {
        if (endpointList == null || endpointList.size() == 0) {
            SPARQL_UberServlet.errorMethodNotAllowed(request.getMethod());
        }
        servlet.doCommonWorker(id, request, response);
    }

    private void executeRequest(DatasetRef desc, SPARQL_ServletBase servlet, long id, HttpServletRequest request, HttpServletResponse response) {
        servlet.doCommonWorker(id, request, response);
    }

    protected static MediaType contentNegotationQuads(HttpAction action) {
        MediaType mt = ConNeg.chooseContentType(action.request, DEF.quadsOffer, DEF.acceptNQuads);
        if (mt == null) {
            return null;
        }
        if (mt.getContentType() != null) {
            action.response.setContentType(mt.getContentType());
        }
        if (mt.getCharset() != null) {
            action.response.setCharacterEncoding(mt.getCharset());
        }
        return mt;
    }

    private boolean checkDispatch(List<String> endpointNames, String srvName, SPARQL_ServletBase servlet, DatasetRef desc, long id, HttpServletRequest request, HttpServletResponse response) {
        if (!endpointNames.contains(srvName)) {
            return false;
        }
        servlet.doCommonWorker(id, request, response);
        return true;
    }

    @Override
    protected void perform(long id, DatasetRef desc, HttpServletRequest request, HttpServletResponse response) {
        SPARQL_UberServlet.error(500, "Operation directed to general indirection servlet");
    }

    protected static String findDataset(final String uri) {
        Iterator<String> datasets = DatasetRegistry.get().keys();
        Filter<String> matchDS = new Filter<String>(){

            public boolean accept(String datasetname) {
                return uri.startsWith(datasetname);
            }
        };
        String ds = (String)Iter.first(datasets, (Filter)matchDS);
        return ds;
    }

    protected static String findTrailing(String uri, String dsname) {
        if (dsname.length() >= uri.length()) {
            return "";
        }
        return uri.substring(dsname.length() + 1);
    }

    protected void doHead(HttpServletRequest request, HttpServletResponse response) {
        this.doCommon(request, response);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
        this.doCommon(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) {
        this.doCommon(request, response);
    }

    protected void doOptions(HttpServletRequest request, HttpServletResponse response) {
        this.doCommon(request, response);
    }

    protected void doPut(HttpServletRequest request, HttpServletResponse response) {
        this.doCommon(request, response);
    }

    protected void doDelete(HttpServletRequest request, HttpServletResponse response) {
        this.doCommon(request, response);
    }

    public static class AccessByConfig
    extends SPARQL_UberServlet {
        public AccessByConfig(boolean verbose_debug) {
            super(verbose_debug);
        }

        @Override
        protected boolean allowQuery(HttpAction action) {
            return this.isEnabled(action.getDatasetRef().queryEP);
        }

        @Override
        protected boolean allowUpdate(HttpAction action) {
            return this.isEnabled(action.getDatasetRef().updateEP);
        }

        @Override
        protected boolean allowREST_R(HttpAction action) {
            return this.isEnabled(action.getDatasetRef().readGraphStoreEP) || this.allowREST_W(action);
        }

        @Override
        protected boolean allowREST_W(HttpAction action) {
            return this.isEnabled(action.getDatasetRef().readWriteGraphStoreEP);
        }

        @Override
        protected boolean allowQuadsR(HttpAction action) {
            return this.isEnabled(action.getDatasetRef().readGraphStoreEP);
        }

        @Override
        protected boolean allowQuadsW(HttpAction action) {
            return this.isEnabled(action.getDatasetRef().readWriteGraphStoreEP);
        }

        private boolean isEnabled(List<String> ep) {
            return ep.size() > 0;
        }
    }

    public static class ReadWrite
    extends SPARQL_UberServlet {
        public ReadWrite(boolean verbose_debug) {
            super(verbose_debug);
        }

        @Override
        protected boolean allowQuery(HttpAction action) {
            return true;
        }

        @Override
        protected boolean allowUpdate(HttpAction action) {
            return true;
        }

        @Override
        protected boolean allowREST_R(HttpAction action) {
            return true;
        }

        @Override
        protected boolean allowREST_W(HttpAction action) {
            return true;
        }

        @Override
        protected boolean allowQuadsR(HttpAction action) {
            return true;
        }

        @Override
        protected boolean allowQuadsW(HttpAction action) {
            return true;
        }
    }

    public static class ReadOnly
    extends SPARQL_UberServlet {
        public ReadOnly(boolean verbose_debug) {
            super(verbose_debug);
        }

        @Override
        protected boolean allowQuery(HttpAction action) {
            return true;
        }

        @Override
        protected boolean allowUpdate(HttpAction action) {
            return false;
        }

        @Override
        protected boolean allowREST_R(HttpAction action) {
            return true;
        }

        @Override
        protected boolean allowREST_W(HttpAction action) {
            return false;
        }

        @Override
        protected boolean allowQuadsR(HttpAction action) {
            return true;
        }

        @Override
        protected boolean allowQuadsW(HttpAction action) {
            return false;
        }
    }
}

