/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.servlets;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.QueryParseException;
import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.modify.request.UpdateWithUsing;
import com.hp.hpl.jena.update.Update;
import com.hp.hpl.jena.update.UpdateAction;
import com.hp.hpl.jena.update.UpdateException;
import com.hp.hpl.jena.update.UpdateFactory;
import com.hp.hpl.jena.update.UpdateRequest;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.FusekiLib;
import org.apache.jena.fuseki.server.DatasetRef;
import org.apache.jena.fuseki.servlets.SPARQL_Protocol;
import org.apache.jena.iri.IRI;
import org.openjena.atlas.io.IO;
import org.openjena.atlas.web.MediaType;
import org.openjena.riot.system.IRIResolver;

public class SPARQL_Update
extends SPARQL_Protocol {
    private static String updateParseBase = "http://example/base/";
    private static IRIResolver resolver = IRIResolver.create((String)updateParseBase);
    protected static List<String> paramsForm = Arrays.asList("request", "update", "using-graph-uri", "using-named-graph-uri");
    protected static List<String> paramsPOST = Arrays.asList("using-graph-uri", "using-named-graph-uri");

    public SPARQL_Update(boolean verbose) {
        super(verbose);
    }

    public SPARQL_Update() {
        this(false);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.sendError(400, "Attempt to perform SPARQL update by GET.  Use POST");
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doCommon(request, response);
    }

    protected void doOptions(HttpServletRequest request, HttpServletResponse response) {
        response.setHeader("Allow", "OPTIONS,POST");
        response.setHeader("Content-Length", "0");
    }

    @Override
    protected void perform(long id, DatasetRef desc, HttpServletRequest request, HttpServletResponse response) {
        this.validate(request);
        HttpActionUpdate action = new HttpActionUpdate(id, desc, request, response, this.verbose_debug);
        MediaType incoming = FusekiLib.contentType(request);
        String ctStr = incoming == null ? "application/sparql-update" : incoming.getContentType();
        if ("application/sparql-update".equals(ctStr)) {
            this.executeBody(action);
            return;
        }
        if ("application/x-www-form-urlencoded".equals(ctStr)) {
            this.executeForm(action);
            return;
        }
        SPARQL_Update.error(415, "Bad content type: " + request.getContentType());
    }

    @Override
    protected void validate(HttpServletRequest request) {
        MediaType incoming;
        String ctStr;
        if (!"POST".equals(request.getMethod().toUpperCase())) {
            SPARQL_Update.errorMethodNotAllowed("SPARQL Update : use POST");
        }
        if ("application/sparql-update".equals(ctStr = (incoming = FusekiLib.contentType(request)) == null ? "application/sparql-update" : incoming.getContentType())) {
            String charset = request.getCharacterEncoding();
            if (charset != null && !charset.equalsIgnoreCase("utf-8")) {
                SPARQL_Update.errorBadRequest("Bad charset: " + charset);
            }
            this.validate(request, paramsPOST);
            return;
        }
        if ("application/x-www-form-urlencoded".equals(ctStr)) {
            String requestStr;
            int x = SPARQL_Update.countParamOccurences(request, "update") + SPARQL_Update.countParamOccurences(request, "request");
            if (x != 1) {
                SPARQL_Update.errorBadRequest("SPARQL Update: Multiple 'update=' parameters");
            }
            if ((requestStr = request.getParameter("update")) == null) {
                requestStr = request.getParameter("request");
            }
            if (requestStr == null) {
                SPARQL_Update.errorBadRequest("SPARQL Update: No update= in HTML form");
            }
            this.validate(request, paramsForm);
            return;
        }
        SPARQL_Update.error(415, "Must be application/sparql-update or application/x-www-form-urlencoded (got " + ctStr + ")");
    }

    protected void validate(HttpServletRequest request, Collection<String> params) {
        if (params != null) {
            Enumeration en = request.getParameterNames();
            while (en.hasMoreElements()) {
                String name = (String)en.nextElement();
                if (params.contains(name)) continue;
                SPARQL_Update.warning("SPARQL Update: Unrecognize request parameter (ignored): " + name);
            }
        }
    }

    private void executeBody(HttpActionUpdate action) {
        UpdateRequest req;
        block8: {
            ServletInputStream input = null;
            try {
                input = action.request.getInputStream();
            }
            catch (IOException ex) {
                SPARQL_Update.errorOccurred(ex);
            }
            try {
                if (this.verbose_debug || action.verbose) {
                    String requestStr = null;
                    try {
                        requestStr = IO.readWholeFileAsUTF8((InputStream)action.request.getInputStream());
                    }
                    catch (IOException ex) {
                        IO.exception((IOException)ex);
                    }
                    String requestStrLog = SPARQL_Update.formatForLog(requestStr);
                    Fuseki.requestLog.info(String.format("[%d] Update = %s", action.id, requestStrLog));
                    req = UpdateFactory.create((String)requestStr, (Syntax)Syntax.syntaxARQ);
                    break block8;
                }
                req = UpdateFactory.read((InputStream)input, (Syntax)Syntax.syntaxARQ);
            }
            catch (UpdateException ex) {
                SPARQL_Update.errorBadRequest(ex.getMessage());
                req = null;
            }
            catch (QueryParseException ex) {
                SPARQL_Update.errorBadRequest(SPARQL_Update.messageForQPE(ex));
                req = null;
            }
        }
        this.execute(action, req);
        SPARQL_Update.successNoContent(action);
    }

    private void executeForm(HttpActionUpdate action) {
        UpdateRequest req;
        String requestStr = action.request.getParameter("update");
        if (requestStr == null) {
            requestStr = action.request.getParameter("request");
        }
        if (this.verbose_debug || action.verbose) {
            Fuseki.requestLog.info(String.format("[%d] Form update = \n%s", action.id, requestStr));
        }
        try {
            req = UpdateFactory.create((String)requestStr, (String)updateParseBase);
        }
        catch (UpdateException ex) {
            SPARQL_Update.errorBadRequest(ex.getMessage());
            req = null;
        }
        catch (QueryParseException ex) {
            SPARQL_Update.errorBadRequest(SPARQL_Update.messageForQPE(ex));
            req = null;
        }
        this.execute(action, req);
        SPARQL_Update.successPage(action, "Update succeeded");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(HttpActionUpdate action, UpdateRequest updateRequest) {
        this.processProtocol(action.request, updateRequest);
        action.beginWrite();
        try {
            UpdateAction.execute((UpdateRequest)updateRequest, (DatasetGraph)action.getActiveDSG());
            action.commit();
        }
        catch (UpdateException ex) {
            action.abort();
            SPARQL_Update.errorBadRequest(ex.getMessage());
        }
        finally {
            action.endWrite();
        }
    }

    private void processProtocol(HttpServletRequest request, UpdateRequest updateRequest) {
        String[] usingArgs = request.getParameterValues("using-graph-uri");
        String[] usingNamedArgs = request.getParameterValues("using-named-graph-uri");
        if (usingArgs == null && usingNamedArgs == null) {
            return;
        }
        if (usingArgs == null) {
            usingArgs = new String[]{};
        }
        if (usingNamedArgs == null) {
            usingNamedArgs = new String[]{};
        }
        for (Update up : updateRequest.getOperations()) {
            if (!(up instanceof UpdateWithUsing)) continue;
            UpdateWithUsing upu = (UpdateWithUsing)up;
            if (upu.getUsing().size() != 0 || upu.getUsingNamed().size() != 0 || upu.getWithIRI() != null) {
                SPARQL_Update.errorBadRequest("SPARQL Update: Protocol using-graph-uri or using-named-graph-uri present where update request has USING, USING NAMED or WITH");
            }
            for (String a : usingArgs) {
                upu.addUsing(SPARQL_Update.createNode(a));
            }
            for (String a : usingNamedArgs) {
                upu.addUsingNamed(SPARQL_Update.createNode(a));
            }
        }
    }

    private static Node createNode(String x) {
        try {
            IRI iri = resolver.resolve(x);
            return Node.createURI((String)iri.toString());
        }
        catch (Exception ex) {
            SPARQL_Update.errorBadRequest("SPARQL Update: bad IRI: " + x);
            return null;
        }
    }

    private class HttpActionUpdate
    extends SPARQL_Protocol.HttpActionProtocol {
        public HttpActionUpdate(long id, DatasetRef desc, HttpServletRequest request, HttpServletResponse response, boolean verbose) {
            super(SPARQL_Update.this, id, desc, request, response, verbose);
        }
    }
}

