/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shacl.compact.writer;

import org.apache.jena.atlas.io.AWriter;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.riot.out.NodeFormatter;
import org.apache.jena.shacl.compact.writer.CompactOut;
import org.apache.jena.shacl.compact.writer.ShaclNotCompactException;
import org.apache.jena.shacl.engine.ShaclPaths;
import org.apache.jena.shacl.engine.constraint.MaxCount;
import org.apache.jena.shacl.engine.constraint.MinCount;
import org.apache.jena.shacl.parser.Constraint;
import org.apache.jena.shacl.parser.NodeShape;
import org.apache.jena.shacl.parser.PropertyShape;
import org.apache.jena.shacl.parser.Shape;
import org.apache.jena.shacl.parser.ShapeVisitor;
import org.apache.jena.shacl.vocabulary.SHACL;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.core.Prologue;
import org.apache.jena.sparql.path.Path;

public class ShapeOutputVisitor
implements ShapeVisitor {
    private final IndentedWriter out;
    private final NodeFormatter nodeFmt;
    private final Prologue prologue;

    ShapeOutputVisitor(PrefixMapping pmap, NodeFormatter nodeFmt, IndentedWriter out) {
        this(nodeFmt, out, new Prologue(pmap));
    }

    private ShapeOutputVisitor(NodeFormatter nodeFmt, IndentedWriter out, Prologue prologue) {
        this.nodeFmt = nodeFmt;
        this.out = out;
        this.prologue = prologue;
    }

    public ShapeOutputVisitor fork(IndentedWriter out) {
        return new ShapeOutputVisitor(this.nodeFmt, out, this.prologue);
    }

    @Override
    public void visit(NodeShape nodeShape) {
        this.printShape(nodeShape);
        this.printTargets(nodeShape);
        nodeShape.getConstraints().forEach(c -> this.nodeConstraint((Constraint)c));
        nodeShape.getPropertyShapes().forEach(this::outputPropertyShape);
    }

    @Override
    public void visit(PropertyShape propertyShape) {
        this.printShape(propertyShape);
        Path path = propertyShape.getPath();
        ShaclPaths.write(this.out, path, this.prologue);
        int minCount = -1;
        int maxCount = -1;
        for (Constraint c : propertyShape.getConstraints()) {
            if (SHACL.MinCountConstraintComponent.equals((Object)c.getComponent())) {
                minCount = ((MinCount)c).getMinCount();
                continue;
            }
            if (!SHACL.MaxCountConstraintComponent.equals((Object)c.getComponent())) continue;
            maxCount = ((MaxCount)c).getMaxCount();
        }
        boolean minMaxCountDone = false;
        for (Constraint c : propertyShape.getConstraints()) {
            if (SHACL.MinCountConstraintComponent.equals((Object)c.getComponent()) || SHACL.MaxCountConstraintComponent.equals((Object)c.getComponent())) {
                if (!(minMaxCountDone || minCount == -1 && maxCount == -1)) {
                    String minStr = minCount != -1 ? Integer.toString(minCount) : "0";
                    String maxStr = maxCount != -1 ? Integer.toString(maxCount) : "*";
                    this.out.print(" [" + minStr + ".." + maxStr + "]");
                }
                minMaxCountDone = true;
                continue;
            }
            this.out.print(" ");
            this.propertyConstraint(c);
        }
        this.out.println(" .");
        propertyShape.getPropertyShapes().forEach(this::outputPropertyShape);
    }

    private void printShape(Shape shape) {
        if (shape.deactivated()) {
            CompactOut.compactUnquotedString(this.out, "deactivated", "true");
            this.out.println(" .");
        }
        if (shape.getSeverity() != null && !SHACL.Violation.equals((Object)shape.getSeverity().level())) {
            CompactOut.compact(this.out, this.nodeFmt, "severity", shape.getSeverity().level());
            this.out.println(" .");
        }
        if (shape.getMessages() != null) {
            shape.getMessages().forEach(msg -> {
                CompactOut.compact(this.out, this.nodeFmt, "message", msg);
                this.out.println(" .");
            });
        }
    }

    private void printTargets(Shape shape) {
        shape.getTargets().forEach(target -> {
            switch (target.getTargetType()) {
                case implicitClass: {
                    return;
                }
                case targetClass: {
                    return;
                }
                case targetNode: {
                    break;
                }
                case targetObjectsOf: {
                    break;
                }
                case targetSubjectsOf: {
                    break;
                }
                case targetExtension: {
                    throw new ShaclNotCompactException("sh:target not supported in compact syntax");
                }
            }
            this.out.print(target.getTargetType().compact);
            this.out.print(" = ");
            this.nodeFmt.format((AWriter)this.out, target.getObject());
            this.out.println(" .");
        });
    }

    private void outputPropertyShape(PropertyShape ps) {
        ps.visit(this);
    }

    void nodeConstraint(Constraint c) {
        this.constraint(c);
        this.out.println(" .");
    }

    void propertyConstraint(Constraint c) {
        this.constraint(c);
    }

    void constraint(Constraint c) {
        c.printCompact(this.out, this.nodeFmt);
    }
}

