/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.functions;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.SimpleScriptContext;
import org.apache.jmeter.engine.util.CompoundVariable;
import org.apache.jmeter.functions.AbstractFunction;
import org.apache.jmeter.functions.InvalidVariableException;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.threads.JMeterContext;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Scriptable;

public class JavaScript
extends AbstractFunction {
    private static final String NASHORN_ENGINE_NAME = "nashorn";
    private static final String USE_RHINO_ENGINE_PROPERTY = "javascript.use_rhino";
    private static final boolean USE_RHINO_ENGINE = JMeterUtils.getPropDefault((String)"javascript.use_rhino", (boolean)true) || JavaScript.getInstance().getEngineByName("nashorn") == null;
    private static final List<String> desc = new LinkedList<String>();
    private static final String KEY = "__javaScript";
    private static final Logger log = LoggingManager.getLoggerForClass();
    private Object[] values;

    private static ScriptEngineManager getInstance() {
        return LazyHolder.INSTANCE;
    }

    public String execute(SampleResult previousResult, Sampler currentSampler) throws InvalidVariableException {
        JMeterContext jmctx = JMeterContextService.getContext();
        JMeterVariables vars = jmctx.getVariables();
        String script = ((CompoundVariable)this.values[0]).execute();
        String varName = this.values.length < 2 ? null : ((CompoundVariable)this.values[1]).execute().trim();
        String resultStr = "";
        resultStr = USE_RHINO_ENGINE ? this.executeWithRhino(previousResult, currentSampler, jmctx, vars, script, varName) : this.executeWithNashorn(previousResult, currentSampler, jmctx, vars, script, varName);
        return resultStr;
    }

    private String executeWithNashorn(SampleResult previousResult, Sampler currentSampler, JMeterContext jmctx, JMeterVariables vars, String script, String varName) throws InvalidVariableException {
        String resultStr = null;
        try {
            SimpleScriptContext newContext = new SimpleScriptContext();
            ScriptEngine engine = JavaScript.getInstance().getEngineByName(NASHORN_ENGINE_NAME);
            Bindings bindings = engine.createBindings();
            bindings.put("log", (Object)log);
            bindings.put("ctx", (Object)jmctx);
            bindings.put("vars", (Object)vars);
            bindings.put("props", (Object)JMeterUtils.getJMeterProperties());
            bindings.put("threadName", (Object)Thread.currentThread().getName());
            bindings.put("sampler", (Object)currentSampler);
            bindings.put("sampleResult", (Object)previousResult);
            newContext.setBindings(bindings, 100);
            Object result = engine.eval(script, (ScriptContext)newContext);
            resultStr = result.toString();
            if (varName != null && vars != null) {
                vars.put(varName, resultStr);
            }
        }
        catch (Exception e) {
            log.error("Error processing Javascript: [" + script + "]\n", (Throwable)e);
            throw new InvalidVariableException("Error processing Javascript: [" + script + "]", (Throwable)e);
        }
        return resultStr;
    }

    private String executeWithRhino(SampleResult previousResult, Sampler currentSampler, JMeterContext jmctx, JMeterVariables vars, String script, String varName) throws InvalidVariableException {
        Context cx = Context.enter();
        String resultStr = null;
        try {
            Scriptable scope = cx.initStandardObjects(null);
            scope.put("log", scope, (Object)log);
            scope.put("ctx", scope, (Object)jmctx);
            scope.put("vars", scope, (Object)vars);
            scope.put("props", scope, (Object)JMeterUtils.getJMeterProperties());
            scope.put("threadName", scope, (Object)Thread.currentThread().getName());
            scope.put("sampler", scope, (Object)currentSampler);
            scope.put("sampleResult", scope, (Object)previousResult);
            Object result = cx.evaluateString(scope, script, "<cmd>", 1, null);
            resultStr = Context.toString((Object)result);
            if (varName != null && vars != null) {
                vars.put(varName, resultStr);
            }
        }
        catch (RhinoException e) {
            log.error("Error processing Javascript: [" + script + "]\n", (Throwable)e);
            throw new InvalidVariableException("Error processing Javascript: [" + script + "]", (Throwable)e);
        }
        finally {
            Context.exit();
        }
        return resultStr;
    }

    public void setParameters(Collection<CompoundVariable> parameters) throws InvalidVariableException {
        this.checkParameterCount(parameters, 1, 2);
        this.values = parameters.toArray();
    }

    public String getReferenceKey() {
        return KEY;
    }

    public List<String> getArgumentDesc() {
        return desc;
    }

    static {
        desc.add(JMeterUtils.getResString((String)"javascript_expression"));
        desc.add(JMeterUtils.getResString((String)"function_name_paropt"));
    }

    private static class LazyHolder {
        public static final ScriptEngineManager INSTANCE = new ScriptEngineManager();

        private LazyHolder() {
        }
    }
}

