/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.functions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.jmeter.engine.util.CompoundVariable;
import org.apache.jmeter.functions.AbstractFunction;
import org.apache.jmeter.functions.InvalidVariableException;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;
import org.apache.oro.text.MalformedCachePatternException;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.PatternMatcherInput;
import org.apache.oro.text.regex.Perl5Matcher;
import org.apache.oro.text.regex.Util;

public class RegexFunction
extends AbstractFunction {
    private static final Logger log = LoggingManager.getLoggerForClass();
    public static final String ALL = "ALL";
    public static final String RAND = "RAND";
    public static final String KEY = "__regexFunction";
    private Object[] values;
    private static final List<String> desc = new LinkedList<String>();
    private static final String TEMPLATE_PATTERN = "\\$(\\d+)\\$";
    private final Pattern templatePattern = JMeterUtils.getPatternCache().getPattern("\\$(\\d+)\\$", 32768);
    private static final int MIN_PARAMETER_COUNT = 2;
    private static final int MAX_PARAMETER_COUNT = 7;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execute(SampleResult previousResult, Sampler currentSampler) throws InvalidVariableException {
        Object[] tmplt;
        Pattern searchPattern;
        String valueIndex = "";
        String defaultValue = "";
        String between = "";
        String name = "";
        String inputVariable = "";
        try {
            String dv;
            searchPattern = JMeterUtils.getPatternCache().getPattern(((CompoundVariable)this.values[0]).execute(), 32768);
            tmplt = this.generateTemplate(((CompoundVariable)this.values[1]).execute());
            if (this.values.length > 2) {
                valueIndex = ((CompoundVariable)this.values[2]).execute();
            }
            if (valueIndex.length() == 0) {
                valueIndex = "1";
            }
            if (this.values.length > 3) {
                between = ((CompoundVariable)this.values[3]).execute();
            }
            if (this.values.length > 4 && (dv = ((CompoundVariable)this.values[4]).execute()).length() != 0) {
                defaultValue = dv;
            }
            if (this.values.length > 5) {
                name = ((CompoundVariable)this.values[5]).execute();
            }
            if (this.values.length > 6) {
                inputVariable = ((CompoundVariable)this.values[6]).execute();
            }
        }
        catch (MalformedCachePatternException e) {
            log.error("Malformed cache pattern:" + this.values[0], (Throwable)e);
            throw new InvalidVariableException("Malformed cache pattern:" + this.values[0], (Throwable)e);
        }
        JMeterVariables vars = this.getVariables();
        if (vars == null) {
            return defaultValue;
        }
        if (name.length() > 0) {
            vars.put(name, defaultValue);
        }
        String textToMatch = null;
        if (inputVariable.length() > 0) {
            textToMatch = vars.get(inputVariable);
        } else if (previousResult != null) {
            textToMatch = previousResult.getResponseDataAsString();
        }
        if (textToMatch == null || textToMatch.length() == 0) {
            return defaultValue;
        }
        ArrayList<MatchResult> collectAllMatches = new ArrayList<MatchResult>();
        try {
            Perl5Matcher matcher = JMeterUtils.getMatcher();
            PatternMatcherInput input = new PatternMatcherInput(textToMatch);
            while (matcher.contains(input, searchPattern)) {
                MatchResult match = matcher.getMatch();
                collectAllMatches.add(match);
            }
        }
        finally {
            if (name.length() > 0) {
                vars.put(name + "_matchNr", Integer.toString(collectAllMatches.size()));
            }
        }
        if (collectAllMatches.size() == 0) {
            return defaultValue;
        }
        if (valueIndex.equals(ALL)) {
            StringBuilder value = new StringBuilder();
            Iterator it = collectAllMatches.iterator();
            boolean first = true;
            while (it.hasNext()) {
                if (!first) {
                    value.append(between);
                } else {
                    first = false;
                }
                value.append(this.generateResult((MatchResult)it.next(), name, tmplt, vars));
            }
            return value.toString();
        }
        if (valueIndex.equals(RAND)) {
            MatchResult result = (MatchResult)collectAllMatches.get(ThreadLocalRandom.current().nextInt(collectAllMatches.size()));
            return this.generateResult(result, name, tmplt, vars);
        }
        try {
            int index = Integer.parseInt(valueIndex) - 1;
            MatchResult result = (MatchResult)collectAllMatches.get(index);
            return this.generateResult(result, name, tmplt, vars);
        }
        catch (NumberFormatException e) {
            float ratio = Float.parseFloat(valueIndex);
            MatchResult result = (MatchResult)collectAllMatches.get((int)((double)((float)collectAllMatches.size() * ratio) + 0.5) - 1);
            return this.generateResult(result, name, tmplt, vars);
        }
        catch (IndexOutOfBoundsException e) {
            return defaultValue;
        }
    }

    private void saveGroups(MatchResult result, String namep, JMeterVariables vars) {
        if (result != null) {
            for (int x = 0; x < result.groups(); ++x) {
                vars.put(namep + "_g" + x, result.group(x));
            }
        }
    }

    public List<String> getArgumentDesc() {
        return desc;
    }

    private String generateResult(MatchResult match, String namep, Object[] template, JMeterVariables vars) {
        this.saveGroups(match, namep, vars);
        StringBuilder result = new StringBuilder();
        for (Object t : template) {
            if (t instanceof String) {
                result.append(t);
                continue;
            }
            result.append(match.group(((Integer)t).intValue()));
        }
        if (namep.length() > 0) {
            vars.put(namep, result.toString());
        }
        return result.toString();
    }

    public String getReferenceKey() {
        return KEY;
    }

    public void setParameters(Collection<CompoundVariable> parameters) throws InvalidVariableException {
        this.checkParameterCount(parameters, 2, 7);
        this.values = parameters.toArray();
    }

    private Object[] generateTemplate(String rawTemplate) {
        ArrayList pieces = new ArrayList();
        LinkedList<Integer> combined = new LinkedList<Integer>();
        Perl5Matcher matcher = JMeterUtils.getMatcher();
        Util.split(pieces, (PatternMatcher)matcher, (Pattern)this.templatePattern, (String)rawTemplate);
        PatternMatcherInput input = new PatternMatcherInput(rawTemplate);
        boolean startsWith = this.isFirstElementGroup(rawTemplate);
        if (startsWith) {
            pieces.remove(0);
        }
        Iterator iter = pieces.iterator();
        while (iter.hasNext()) {
            boolean matchExists = matcher.contains(input, this.templatePattern);
            if (startsWith) {
                if (matchExists) {
                    combined.add(Integer.valueOf(matcher.getMatch().group(1)));
                }
                combined.add((Integer)iter.next());
                continue;
            }
            combined.add((Integer)iter.next());
            if (!matchExists) continue;
            combined.add(Integer.valueOf(matcher.getMatch().group(1)));
        }
        if (matcher.contains(input, this.templatePattern)) {
            combined.add(Integer.valueOf(matcher.getMatch().group(1)));
        }
        return combined.toArray();
    }

    private boolean isFirstElementGroup(String rawData) {
        Pattern pattern = JMeterUtils.getPatternCache().getPattern("^\\$\\d+\\$", 32768);
        return JMeterUtils.getMatcher().contains(rawData, pattern);
    }

    static {
        desc.add(JMeterUtils.getResString((String)"regexfunc_param_1"));
        desc.add(JMeterUtils.getResString((String)"regexfunc_param_2"));
        desc.add(JMeterUtils.getResString((String)"regexfunc_param_3"));
        desc.add(JMeterUtils.getResString((String)"regexfunc_param_4"));
        desc.add(JMeterUtils.getResString((String)"regexfunc_param_5"));
        desc.add(JMeterUtils.getResString((String)"function_name_paropt"));
        desc.add(JMeterUtils.getResString((String)"regexfunc_param_7"));
    }
}

