/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.functions;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.time.LocalDate;
import java.time.Year;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.engine.util.CompoundVariable;
import org.apache.jmeter.functions.AbstractFunction;
import org.apache.jmeter.functions.InvalidVariableException;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jmeter.util.JMeterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RandomDate
extends AbstractFunction {
    private static final Logger log = LoggerFactory.getLogger(RandomDate.class);
    private static final String KEY = "__RandomDate";
    private static final int MIN_PARAMETER_COUNT = 1;
    private static final int MAX_PARAMETER_COUNT = 5;
    private static final List<String> desc = Arrays.asList(JMeterUtils.getResString((String)"time_format_random"), JMeterUtils.getResString((String)"date_start"), JMeterUtils.getResString((String)"date_end"), JMeterUtils.getResString((String)"locale_format"), JMeterUtils.getResString((String)"function_name_paropt"));
    private String format = "";
    private Locale locale = JMeterUtils.getLocale();
    private String variableName = "";
    private ZoneId systemDefaultZoneID = ZoneId.systemDefault();
    private String dateStart;
    private String dateEnd;
    private Object[] values;
    private Cache<LocaleFormatObject, DateTimeFormatter> dateRandomFormatterCache;

    public String execute(SampleResult previousResult, Sampler currentSampler) throws InvalidVariableException {
        JMeterVariables vars;
        DateTimeFormatter formatter;
        LocaleFormatObject lfo;
        long localStartDate = 0L;
        long localEndDate = 0L;
        this.format = ((CompoundVariable)this.values[0]).execute().trim();
        String localeAsString = ((CompoundVariable)this.values[3]).execute().trim();
        if (!localeAsString.trim().isEmpty()) {
            this.locale = LocaleUtils.toLocale((String)localeAsString);
        }
        if (!StringUtils.isEmpty((CharSequence)this.format)) {
            try {
                lfo = new LocaleFormatObject(this.format, this.locale);
                formatter = (DateTimeFormatter)this.dateRandomFormatterCache.get((Object)lfo, key -> this.createFormatter((LocaleFormatObject)key));
            }
            catch (IllegalArgumentException ex) {
                log.error("Format date pattern '{}' is invalid (see https://docs.oracle.com/javase/8/docs/api/java    ime/format/DateTimeFormatter.html)", (Object)this.format, (Object)ex);
                return "";
            }
        }
        try {
            lfo = new LocaleFormatObject("yyyy-MM-dd", this.locale);
            formatter = (DateTimeFormatter)this.dateRandomFormatterCache.get((Object)lfo, key -> this.createFormatter((LocaleFormatObject)key));
        }
        catch (IllegalArgumentException ex) {
            log.error("Format date pattern '{}' is invalid (see https://docs.oracle.com/javase/8/docs/api/java    ime/format/DateTimeFormatter.html)", (Object)this.format, (Object)ex);
            return "";
        }
        this.dateStart = ((CompoundVariable)this.values[1]).execute().trim();
        if (!this.dateStart.isEmpty()) {
            try {
                localStartDate = LocalDate.parse(this.dateStart, formatter).toEpochDay();
            }
            catch (NumberFormatException | DateTimeParseException ex) {
                log.error("Failed to parse the date '{}' to shift with formatter '{}'", new Object[]{this.dateStart, formatter, ex});
            }
        } else {
            try {
                localStartDate = LocalDate.now(this.systemDefaultZoneID).toEpochDay();
            }
            catch (NumberFormatException | DateTimeParseException ex) {
                log.error("Failed to parse the date '{}' to shift with formatter '{}'", new Object[]{this.dateStart, formatter, ex});
            }
        }
        this.dateEnd = ((CompoundVariable)this.values[2]).execute().trim();
        try {
            localEndDate = LocalDate.parse(this.dateEnd, formatter).toEpochDay();
        }
        catch (NumberFormatException | DateTimeParseException ex) {
            log.error("Failed to parse the date '{}' to shift with formatter '{}'", new Object[]{this.dateEnd, formatter, ex});
        }
        String dateString = "";
        long randomDay = ThreadLocalRandom.current().nextLong(localStartDate, localEndDate);
        try {
            dateString = LocalDate.ofEpochDay(randomDay).format(formatter);
        }
        catch (NumberFormatException | DateTimeParseException ex) {
            log.error("Failed to parse the date '{}' to shift with formatter '{}'", new Object[]{randomDay, formatter, ex});
        }
        this.variableName = ((CompoundVariable)this.values[4]).execute().trim();
        if (!StringUtils.isEmpty((CharSequence)this.variableName) && (vars = this.getVariables()) != null) {
            vars.put(this.variableName, dateString);
        }
        return dateString;
    }

    private DateTimeFormatter createFormatter(LocaleFormatObject format) {
        log.debug("Create a new instance of DateTimeFormatter for format '{}' in the cache", (Object)format);
        return new DateTimeFormatterBuilder().appendPattern(format.getFormat()).parseDefaulting(ChronoField.DAY_OF_MONTH, 1L).parseDefaulting(ChronoField.MONTH_OF_YEAR, 1L).parseDefaulting(ChronoField.YEAR_OF_ERA, Year.now().getValue()).toFormatter(format.getLocale());
    }

    public void setParameters(Collection<CompoundVariable> parameters) throws InvalidVariableException {
        this.checkParameterCount(parameters, 1, 5);
        this.values = parameters.toArray();
        if (this.dateRandomFormatterCache == null) {
            this.dateRandomFormatterCache = Caffeine.newBuilder().maximumSize(100L).build();
        }
    }

    public String getReferenceKey() {
        return KEY;
    }

    public List<String> getArgumentDesc() {
        return desc;
    }

    private static final class LocaleFormatObject {
        private String format;
        private Locale locale;

        public LocaleFormatObject(String format, Locale locale) {
            this.format = format;
            this.locale = locale;
        }

        public String getFormat() {
            return this.format;
        }

        public Locale getLocale() {
            return this.locale;
        }

        public int hashCode() {
            return this.format.hashCode() + this.locale.hashCode();
        }

        public boolean equals(Object other) {
            if (!(other instanceof LocaleFormatObject)) {
                return false;
            }
            LocaleFormatObject otherError = (LocaleFormatObject)other;
            return this.format.equals(otherError.getFormat()) && this.locale.getDisplayName().equals(otherError.getLocale().getDisplayName());
        }

        public String toString() {
            return "LocaleFormatObject [format=" + this.format + ", locale=" + this.locale + "]";
        }
    }
}

