/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki;

import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;
import org.apache.wiki.Watchable;
import org.apache.wiki.WikiBackgroundThread;
import org.apache.wiki.WikiEngine;

public final class WatchDog {
    private Watchable m_watchable;
    private Stack<State> m_stateStack = new Stack();
    private boolean m_enabled = true;
    private WikiEngine m_engine;
    private static final Logger log = Logger.getLogger(WatchDog.class);
    private static Map<Integer, WeakReference<WatchDog>> c_kennel = new ConcurrentHashMap<Integer, WeakReference<WatchDog>>();
    private static WikiBackgroundThread c_watcherThread;

    public static WatchDog getCurrentWatchDog(WikiEngine engine) {
        Thread t = Thread.currentThread();
        WatchDog wd = null;
        WeakReference<WatchDog> w = c_kennel.get(t.hashCode());
        if (w != null) {
            wd = (WatchDog)w.get();
        }
        if (w == null || wd == null) {
            wd = new WatchDog(engine, t);
            w = new WeakReference<WatchDog>(wd);
            c_kennel.put(t.hashCode(), w);
        }
        return wd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WatchDog(WikiEngine engine, Watchable watch) {
        this.m_engine = engine;
        this.m_watchable = watch;
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (c_watcherThread == null) {
                c_watcherThread = new WatchDogThread(engine);
                c_watcherThread.start();
            }
        }
    }

    public WatchDog(WikiEngine engine, Thread thread) {
        this(engine, new ThreadWrapper(thread));
    }

    private static void scrub() {
        if (c_kennel == null) {
            return;
        }
        for (Map.Entry<Integer, WeakReference<WatchDog>> e : c_kennel.entrySet()) {
            WeakReference<WatchDog> w = e.getValue();
            if (w.get() != null) continue;
            c_kennel.remove(e.getKey());
            WatchDog.scrub();
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enable() {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (!this.m_enabled) {
                this.m_enabled = true;
                c_watcherThread = new WatchDogThread(this.m_engine);
                c_watcherThread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disable() {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (this.m_enabled) {
                this.m_enabled = false;
                c_watcherThread.shutdown();
                c_watcherThread = null;
            }
        }
    }

    public void enterState(String state) {
        this.enterState(state, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enterState(String state, int expectedCompletionTime) {
        if (log.isDebugEnabled()) {
            log.debug((Object)(this.m_watchable.getName() + ": Entering state " + state + ", expected completion in " + expectedCompletionTime + " s"));
        }
        Stack<State> stack = this.m_stateStack;
        synchronized (stack) {
            State st = new State(state, expectedCompletionTime);
            this.m_stateStack.push(st);
        }
    }

    public void exitState() {
        this.exitState(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exitState(String state) {
        if (!this.m_stateStack.empty()) {
            Stack<State> stack = this.m_stateStack;
            synchronized (stack) {
                State st = this.m_stateStack.peek();
                if (state == null || st.getState().equals(state)) {
                    this.m_stateStack.pop();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)(this.m_watchable.getName() + ": Exiting state " + st.getState()));
                    }
                } else {
                    log.error((Object)"exitState() called before enterState()");
                }
            }
        } else {
            log.warn((Object)("Stack for " + this.m_watchable.getName() + " is empty!"));
        }
    }

    public boolean isStateStackNotEmpty() {
        return this.m_stateStack != null && !this.m_stateStack.isEmpty();
    }

    public boolean isWatchableAlive() {
        return this.m_watchable != null && this.m_watchable.isAlive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void check() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Checking watchdog '" + this.m_watchable.getName() + "'"));
        }
        Stack<State> stack = this.m_stateStack;
        synchronized (stack) {
            if (!this.m_stateStack.empty()) {
                State st = this.m_stateStack.peek();
                long now = System.currentTimeMillis();
                if (now > st.getExpiryTime()) {
                    log.info((Object)("Watchable '" + this.m_watchable.getName() + "' exceeded timeout in state '" + st.getState() + "' by " + (now - st.getExpiryTime()) / 1000L + " seconds" + (log.isDebugEnabled() ? "" : "Enable DEBUG-level logging to see stack traces.")));
                    this.dumpStackTraceForWatchable();
                    this.m_watchable.timeoutExceeded(st.getState());
                }
            } else {
                log.warn((Object)("Stack for " + this.m_watchable.getName() + " is empty!"));
            }
        }
    }

    private void dumpStackTraceForWatchable() {
        if (!log.isDebugEnabled()) {
            return;
        }
        Map<Thread, StackTraceElement[]> stackTraces = Thread.getAllStackTraces();
        Set<Thread> threads = stackTraces.keySet();
        Iterator<Thread> threadIterator = threads.iterator();
        StringBuilder stacktrace = new StringBuilder();
        while (threadIterator.hasNext()) {
            Thread t = threadIterator.next();
            if (!t.getName().equals(this.m_watchable.getName())) continue;
            if (t.getName().equals(this.m_watchable.getName())) {
                stacktrace.append("dumping stacktrace for too long running thread : " + t);
            } else {
                stacktrace.append("dumping stacktrace for other running thread : " + t);
            }
            StackTraceElement[] ste = stackTraces.get(t);
            for (int i = 0; i < ste.length; ++i) {
                stacktrace.append("\n" + ste[i]);
            }
        }
        log.debug((Object)stacktrace.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Stack<State> stack = this.m_stateStack;
        synchronized (stack) {
            String state = "Idle";
            if (!this.m_stateStack.empty()) {
                State st = this.m_stateStack.peek();
                state = st.getState();
            }
            return "WatchDog state=" + state;
        }
    }

    private static class ThreadWrapper
    implements Watchable {
        private Thread m_thread;

        public ThreadWrapper(Thread thread) {
            this.m_thread = thread;
        }

        @Override
        public void timeoutExceeded(String state) {
        }

        @Override
        public String getName() {
            return this.m_thread.getName();
        }

        @Override
        public boolean isAlive() {
            return this.m_thread.isAlive();
        }
    }

    private static class State {
        protected String m_state;
        protected long m_enterTime;
        protected long m_expiryTime;

        protected State(String state, int expiry) {
            this.m_state = state;
            this.m_enterTime = System.currentTimeMillis();
            this.m_expiryTime = this.m_enterTime + (long)expiry * 1000L;
        }

        protected String getState() {
            return this.m_state;
        }

        protected long getExpiryTime() {
            return this.m_expiryTime;
        }
    }

    private static class WatchDogThread
    extends WikiBackgroundThread {
        private static final int CHECK_INTERVAL = 30;

        public WatchDogThread(WikiEngine engine) {
            super(engine, 30);
            this.setName("WatchDog for '" + engine.getApplicationName() + "'");
        }

        @Override
        public void startupTask() {
        }

        @Override
        public void shutdownTask() {
            WatchDog.scrub();
        }

        @Override
        public void backgroundTask() throws Exception {
            if (c_kennel == null) {
                return;
            }
            for (Map.Entry entry : c_kennel.entrySet()) {
                WeakReference wr = (WeakReference)entry.getValue();
                WatchDog w = (WatchDog)wr.get();
                if (w == null) continue;
                if (w.isWatchableAlive() && w.isStateStackNotEmpty()) {
                    w.check();
                    continue;
                }
                c_kennel.remove(entry.getKey());
                break;
            }
            WatchDog.scrub();
        }
    }
}

