/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki;

import org.apache.log4j.Logger;
import org.apache.wiki.InternalWikiException;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.event.WikiEngineEvent;
import org.apache.wiki.event.WikiEvent;
import org.apache.wiki.event.WikiEventListener;

public abstract class WikiBackgroundThread
extends Thread
implements WikiEventListener {
    private static final Logger LOG = Logger.getLogger(WikiBackgroundThread.class);
    private volatile boolean m_killMe = false;
    private final WikiEngine m_engine;
    private final int m_interval;
    private static final long POLLING_INTERVAL = 1000L;

    public WikiBackgroundThread(WikiEngine engine, int sleepInterval) {
        this.m_engine = engine;
        this.m_interval = sleepInterval;
        engine.addWikiEventListener(this);
        this.setDaemon(false);
    }

    @Override
    public final void actionPerformed(WikiEvent event) {
        if (event instanceof WikiEngineEvent && ((WikiEngineEvent)event).getType() == 1) {
            LOG.warn((Object)("Detected wiki engine shutdown: killing " + this.getName() + "."));
            this.m_killMe = true;
        }
    }

    public abstract void backgroundTask() throws Exception;

    public WikiEngine getEngine() {
        return this.m_engine;
    }

    public void shutdown() {
        this.m_killMe = true;
    }

    @Override
    public final void run() {
        try {
            String name = this.getName();
            LOG.warn((Object)("Starting up background thread: " + name + "."));
            this.startupTask();
            while (!this.m_killMe) {
                this.backgroundTask();
                boolean interrupted = false;
                try {
                    for (int i = 0; i < this.m_interval; ++i) {
                        Thread.sleep(1000L);
                        if (!this.m_killMe) continue;
                        interrupted = true;
                        LOG.warn((Object)("Interrupted background thread: " + name + "."));
                        break;
                    }
                    if (!interrupted) continue;
                    break;
                }
                catch (Throwable t) {
                    LOG.error((Object)"Background thread error: (stack trace follows)", t);
                }
            }
            this.shutdownTask();
        }
        catch (Throwable t) {
            LOG.error((Object)"Background thread error: (stack trace follows)", t);
            throw new InternalWikiException(t.getMessage(), t);
        }
    }

    public void shutdownTask() throws Exception {
    }

    public void startupTask() throws Exception {
    }
}

