/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.attachment;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.wiki.WikiContext;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.WikiPage;
import org.apache.wiki.api.exceptions.NoRequiredPropertyException;
import org.apache.wiki.api.exceptions.ProviderException;
import org.apache.wiki.api.exceptions.WikiException;
import org.apache.wiki.attachment.Attachment;
import org.apache.wiki.attachment.DynamicAttachment;
import org.apache.wiki.parser.MarkupParser;
import org.apache.wiki.providers.WikiAttachmentProvider;
import org.apache.wiki.util.ClassUtil;

public class AttachmentManager {
    public static final String PROP_PROVIDER = "jspwiki.attachmentProvider";
    public static final String PROP_MAXSIZE = "jspwiki.attachment.maxsize";
    public static final String PROP_ALLOWEDEXTENSIONS = "jspwiki.attachment.allowed";
    public static final String PROP_FORDBIDDENEXTENSIONS = "jspwiki.attachment.forbidden";
    static Logger log = Logger.getLogger(AttachmentManager.class);
    private WikiAttachmentProvider m_provider;
    private WikiEngine m_engine;
    private CacheManager m_cacheManager = CacheManager.getInstance();
    private Cache m_dynamicAttachments;
    public static final String CACHE_NAME = "jspwiki.dynamicAttachmentCache";
    public static final int DEFAULT_CACHECAPACITY = 1000;

    public AttachmentManager(WikiEngine engine, Properties props) {
        this.m_engine = engine;
        boolean useCache = "true".equals(props.getProperty("jspwiki.usePageCache"));
        String classname = useCache ? "org.apache.wiki.providers.CachingAttachmentProvider" : props.getProperty(PROP_PROVIDER);
        if (classname == null) {
            log.info((Object)"No attachment provider defined - disabling attachment support.");
            return;
        }
        String cacheName = engine.getApplicationName() + "." + CACHE_NAME;
        try {
            if (this.m_cacheManager.cacheExists(cacheName)) {
                this.m_dynamicAttachments = this.m_cacheManager.getCache(cacheName);
            } else {
                log.info((Object)("cache with name " + cacheName + " not found in ehcache.xml, creating it with defaults."));
                this.m_dynamicAttachments = new Cache(cacheName, 1000, false, false, 0L, 0L);
                this.m_cacheManager.addCache(this.m_dynamicAttachments);
            }
            Class<?> providerclass = ClassUtil.findClass("org.apache.wiki.providers", classname);
            this.m_provider = (WikiAttachmentProvider)providerclass.newInstance();
            this.m_provider.initialize(this.m_engine, props);
        }
        catch (ClassNotFoundException e) {
            log.error((Object)"Attachment provider class not found", (Throwable)e);
        }
        catch (InstantiationException e) {
            log.error((Object)"Attachment provider could not be created", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            log.error((Object)"You may not access the attachment provider class", (Throwable)e);
        }
        catch (NoRequiredPropertyException e) {
            log.error((Object)("Attachment provider did not find a property that it needed: " + e.getMessage()), (Throwable)e);
            this.m_provider = null;
        }
        catch (IOException e) {
            log.error((Object)"Attachment provider reports IO error", (Throwable)e);
            this.m_provider = null;
        }
    }

    public boolean attachmentsEnabled() {
        return this.m_provider != null;
    }

    public Attachment getAttachmentInfo(String name) throws ProviderException {
        return this.getAttachmentInfo(name, -1);
    }

    public Attachment getAttachmentInfo(String name, int version) throws ProviderException {
        if (name == null) {
            return null;
        }
        return this.getAttachmentInfo(null, name, version);
    }

    public Attachment getAttachmentInfo(WikiContext context, String attachmentname) throws ProviderException {
        return this.getAttachmentInfo(context, attachmentname, -1);
    }

    public String getAttachmentInfoName(WikiContext context, String attachmentname) {
        Attachment att = null;
        try {
            att = this.getAttachmentInfo(context, attachmentname);
        }
        catch (ProviderException e) {
            log.warn((Object)"Finding attachments failed: ", (Throwable)e);
            return null;
        }
        if (att != null) {
            return att.getName();
        }
        if (attachmentname.indexOf(47) != -1) {
            return attachmentname;
        }
        return null;
    }

    public Attachment getAttachmentInfo(WikiContext context, String attachmentname, int version) throws ProviderException {
        int cutpt;
        if (this.m_provider == null) {
            return null;
        }
        WikiPage currentPage = null;
        if (context != null) {
            currentPage = context.getPage();
        }
        if ((cutpt = attachmentname.lastIndexOf(47)) != -1) {
            String parentPage = attachmentname.substring(0, cutpt);
            parentPage = MarkupParser.cleanLink(parentPage);
            attachmentname = attachmentname.substring(cutpt + 1);
            if (parentPage.length() == 0) {
                return null;
            }
            currentPage = this.m_engine.getPage(parentPage);
            if (currentPage == null) {
                currentPage = this.m_engine.getPage(MarkupParser.wikifyLink(parentPage));
            }
        }
        if (currentPage == null || currentPage.getName().length() == 0) {
            return null;
        }
        Attachment att = this.getDynamicAttachment(currentPage.getName() + "/" + attachmentname);
        if (att == null) {
            att = this.m_provider.getAttachmentInfo(currentPage, attachmentname, version);
        }
        return att;
    }

    public List<Attachment> listAttachments(WikiPage wikipage) throws ProviderException {
        if (this.m_provider == null) {
            return new ArrayList<Attachment>();
        }
        List<Object> atts = this.m_provider.listAttachments(wikipage);
        this.m_engine.getPageSorter().sortPages(atts);
        return atts;
    }

    public boolean hasAttachments(WikiPage wikipage) {
        try {
            return this.listAttachments(wikipage).size() > 0;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public InputStream getAttachmentStream(Attachment att) throws IOException, ProviderException {
        return this.getAttachmentStream(null, att);
    }

    public InputStream getAttachmentStream(WikiContext ctx, Attachment att) throws ProviderException, IOException {
        if (this.m_provider == null) {
            return null;
        }
        if (att instanceof DynamicAttachment) {
            return ((DynamicAttachment)att).getProvider().getAttachmentData(ctx, att);
        }
        return this.m_provider.getAttachmentData(att);
    }

    public void storeDynamicAttachment(WikiContext ctx, DynamicAttachment att) {
        this.m_dynamicAttachments.put(new Element((Object)att.getName(), (Object)att));
    }

    public DynamicAttachment getDynamicAttachment(String name) {
        Element element = this.m_dynamicAttachments.get((Serializable)((Object)name));
        if (element != null) {
            return (DynamicAttachment)element.getObjectValue();
        }
        this.m_dynamicAttachments.put(new Element((Serializable)((Object)name), null));
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeAttachment(Attachment att, File source) throws IOException, ProviderException {
        try (FileInputStream in = null;){
            in = new FileInputStream(source);
            this.storeAttachment(att, in);
        }
    }

    public void storeAttachment(Attachment att, InputStream in) throws IOException, ProviderException {
        if (this.m_provider == null) {
            return;
        }
        if (!this.m_engine.getPageManager().pageExists(att.getParentName())) {
            throw new ProviderException("attach.parent.not.exist");
        }
        this.m_provider.putAttachmentData(att, in);
        this.m_engine.getReferenceManager().updateReferences(att.getName(), new Vector<String>());
        WikiPage parent = new WikiPage(this.m_engine, att.getParentName());
        this.m_engine.updateReferences(parent);
        this.m_engine.getSearchManager().reindexPage(att);
    }

    public List<Attachment> getVersionHistory(String attachmentName) throws ProviderException {
        if (this.m_provider == null) {
            return null;
        }
        Attachment att = this.getAttachmentInfo((WikiContext)null, attachmentName);
        if (att != null) {
            return this.m_provider.getVersionHistory(att);
        }
        return null;
    }

    public Collection<Attachment> getAllAttachments() throws ProviderException {
        if (this.attachmentsEnabled()) {
            return this.m_provider.listAllChanged(new Date(0L));
        }
        return new ArrayList<Attachment>();
    }

    public WikiAttachmentProvider getCurrentProvider() {
        return this.m_provider;
    }

    public void deleteVersion(Attachment att) throws ProviderException {
        if (this.m_provider == null) {
            return;
        }
        this.m_provider.deleteVersion(att);
    }

    public void deleteAttachment(Attachment att) throws ProviderException {
        if (this.m_provider == null) {
            return;
        }
        this.m_provider.deleteAttachment(att);
        this.m_engine.getSearchManager().pageRemoved(att);
        this.m_engine.getReferenceManager().clearPageEntries(att.getName());
    }

    static String validateFileName(String filename) throws WikiException {
        if (filename == null || filename.trim().length() == 0) {
            log.error((Object)"Empty file name given.");
            throw new WikiException("attach.empty.file");
        }
        if ((filename = filename.trim()).toLowerCase().endsWith(".jsp") || filename.toLowerCase().endsWith(".jspf")) {
            log.info((Object)"Attempt to upload a file with a .jsp/.jspf extension.  In certain cases this can trigger unwanted security side effects, so we're preventing it.");
            throw new WikiException("attach.unwanted.file");
        }
        String[] splitpath = filename.split("[/\\\\]");
        filename = splitpath[splitpath.length - 1];
        filename = StringUtils.replaceChars((String)filename, (String)"#?\"'", (String)"____");
        return filename;
    }
}

