/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.auth;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Principal;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.WikiSession;
import org.apache.wiki.api.exceptions.WikiException;
import org.apache.wiki.auth.AuthorizationManager;
import org.apache.wiki.auth.Authorizer;
import org.apache.wiki.auth.GroupPrincipal;
import org.apache.wiki.auth.SessionMonitor;
import org.apache.wiki.auth.WikiSecurityException;
import org.apache.wiki.auth.authorize.Role;
import org.apache.wiki.auth.authorize.WebAuthorizer;
import org.apache.wiki.auth.authorize.WebContainerAuthorizer;
import org.apache.wiki.auth.login.AnonymousLoginModule;
import org.apache.wiki.auth.login.CookieAssertionLoginModule;
import org.apache.wiki.auth.login.CookieAuthenticationLoginModule;
import org.apache.wiki.auth.login.UserDatabaseLoginModule;
import org.apache.wiki.auth.login.WebContainerCallbackHandler;
import org.apache.wiki.auth.login.WebContainerLoginModule;
import org.apache.wiki.auth.login.WikiCallbackHandler;
import org.apache.wiki.event.WikiEventListener;
import org.apache.wiki.event.WikiEventManager;
import org.apache.wiki.event.WikiSecurityEvent;
import org.apache.wiki.util.TextUtil;
import org.apache.wiki.util.TimedCounterList;

public class AuthenticationManager {
    private static final long LASTLOGINS_CLEANUP_TIME = 600000L;
    private static final long MAX_LOGIN_DELAY = 20000L;
    public static final String COOKIE_MODULE = CookieAssertionLoginModule.class.getName();
    public static final String COOKIE_AUTHENTICATION_MODULE = CookieAuthenticationLoginModule.class.getName();
    public static final String PROP_STOREIPADDRESS = "jspwiki.storeIPAddress";
    public static final String PROP_ALLOW_COOKIE_AUTH = "jspwiki.cookieAuthentication";
    @Deprecated
    public static final String PROP_SECURITY = "jspwiki.security";
    @Deprecated
    public static final String SECURITY_OFF = "off";
    @Deprecated
    public static final String SECURITY_JAAS = "jaas";
    public static final String PROP_LOGIN_THROTTLING = "jspwiki.login.throttling";
    protected static final Logger log = Logger.getLogger(AuthenticationManager.class);
    protected static final String PREFIX_LOGIN_MODULE_OPTIONS = "jspwiki.loginModule.options.";
    protected static final String PROP_ALLOW_COOKIE_ASSERTIONS = "jspwiki.cookieAssertions";
    protected static final String PROP_LOGIN_MODULE = "jspwiki.loginModule.class";
    protected static final Map<String, String> EMPTY_MAP = Collections.unmodifiableMap(new HashMap());
    protected Class<? extends LoginModule> m_loginModuleClass = UserDatabaseLoginModule.class;
    protected Map<String, String> m_loginModuleOptions = new HashMap<String, String>();
    @Deprecated
    protected static final String SECURITY_CONTAINER = "container";
    private static final String DEFAULT_LOGIN_MODULE = "org.apache.wiki.auth.login.UserDatabaseLoginModule";
    private static final Set<Principal> NO_PRINCIPALS = new HashSet<Principal>();
    private boolean m_allowsCookieAssertions = true;
    private boolean m_throttleLogins = true;
    private boolean m_allowsCookieAuthentication = false;
    private WikiEngine m_engine = null;
    private boolean m_storeIPAddress = true;
    private TimedCounterList<String> m_lastLoginAttempts = new TimedCounterList();

    public void initialize(WikiEngine engine, Properties props) throws WikiException {
        this.m_engine = engine;
        this.m_storeIPAddress = TextUtil.getBooleanProperty(props, PROP_STOREIPADDRESS, this.m_storeIPAddress);
        this.m_allowsCookieAssertions = TextUtil.getBooleanProperty(props, PROP_ALLOW_COOKIE_ASSERTIONS, true);
        this.m_allowsCookieAuthentication = TextUtil.getBooleanProperty(props, PROP_ALLOW_COOKIE_AUTH, false);
        this.m_throttleLogins = TextUtil.getBooleanProperty(props, PROP_LOGIN_THROTTLING, true);
        String loginModuleClassName = TextUtil.getStringProperty(props, PROP_LOGIN_MODULE, DEFAULT_LOGIN_MODULE);
        try {
            this.m_loginModuleClass = Class.forName(loginModuleClassName);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new WikiException("Could not instantiate LoginModule class.", e);
        }
        this.initLoginModuleOptions(props);
    }

    public boolean isContainerAuthenticated() {
        try {
            Authorizer authorizer = this.m_engine.getAuthorizationManager().getAuthorizer();
            if (authorizer instanceof WebContainerAuthorizer) {
                return ((WebContainerAuthorizer)authorizer).isContainerAuthorized();
            }
        }
        catch (WikiException wikiException) {
            // empty catch block
        }
        return false;
    }

    public boolean login(HttpServletRequest request) throws WikiSecurityException {
        Set<Principal> principals;
        HttpSession httpSession = request.getSession();
        WikiSession session = SessionMonitor.getInstance(this.m_engine).find(httpSession);
        AuthenticationManager authenticationMgr = this.m_engine.getAuthenticationManager();
        AuthorizationManager authorizationMgr = this.m_engine.getAuthorizationManager();
        WebContainerCallbackHandler handler = null;
        Map<String, String> options = EMPTY_MAP;
        if (!session.isAuthenticated()) {
            handler = new WebContainerCallbackHandler(this.m_engine, request);
            principals = authenticationMgr.doJAASLogin(WebContainerLoginModule.class, handler, options);
            if (principals.size() == 0 && authenticationMgr.allowsCookieAuthentication()) {
                principals = authenticationMgr.doJAASLogin(CookieAuthenticationLoginModule.class, handler, options);
            }
            if (principals.size() > 0) {
                this.fireEvent(40, this.getLoginPrincipal(principals), session);
                for (Principal principal : principals) {
                    this.fireEvent(35, principal, session);
                }
                this.injectAuthorizerRoles(session, authorizationMgr.getAuthorizer(), request);
            }
        }
        if (!session.isAuthenticated() && authenticationMgr.allowsCookieAssertions() && (principals = authenticationMgr.doJAASLogin(CookieAssertionLoginModule.class, handler, options)).size() > 0) {
            this.fireEvent(32, this.getLoginPrincipal(principals), session);
        }
        if (session.isAnonymous() && (principals = authenticationMgr.doJAASLogin(AnonymousLoginModule.class, handler, options)).size() > 0) {
            this.fireEvent(31, this.getLoginPrincipal(principals), session);
            return true;
        }
        return false;
    }

    public boolean login(WikiSession session, String username, String password) throws WikiSecurityException {
        return this.login(session, null, username, password);
    }

    public boolean login(WikiSession session, HttpServletRequest request, String username, String password) throws WikiSecurityException {
        WikiCallbackHandler handler;
        Set<Principal> principals;
        if (session == null) {
            log.error((Object)"No wiki session provided, cannot log in.");
            return false;
        }
        if (this.m_throttleLogins) {
            this.delayLogin(username);
        }
        if ((principals = this.doJAASLogin(this.m_loginModuleClass, handler = new WikiCallbackHandler(this.m_engine, null, username, password), this.m_loginModuleOptions)).size() > 0) {
            this.fireEvent(40, this.getLoginPrincipal(principals), session);
            for (Principal principal : principals) {
                this.fireEvent(35, principal, session);
            }
            this.injectAuthorizerRoles(session, this.m_engine.getAuthorizationManager().getAuthorizer(), null);
            return true;
        }
        return false;
    }

    private void delayLogin(String username) {
        try {
            this.m_lastLoginAttempts.cleanup(600000L);
            int count = this.m_lastLoginAttempts.count(username);
            long delay = Math.min((long)(1 << count), 20000L);
            log.debug((Object)("Sleeping for " + delay + " ms to allow login."));
            Thread.sleep(delay);
            this.m_lastLoginAttempts.add(username);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void logout(HttpServletRequest request) {
        String sid;
        if (request == null) {
            log.error((Object)"No HTTP reqest provided; cannot log out.");
            return;
        }
        HttpSession session = request.getSession();
        String string = sid = session == null ? "(null)" : session.getId();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Invalidating WikiSession for session ID=" + sid));
        }
        WikiSession wikiSession = WikiSession.getWikiSession(this.m_engine, request);
        Principal originalPrincipal = wikiSession.getLoginPrincipal();
        wikiSession.invalidate();
        WikiSession.removeWikiSession(this.m_engine, request);
        if (session != null) {
            session.invalidate();
        }
        this.fireEvent(44, originalPrincipal, null);
    }

    public boolean allowsCookieAssertions() {
        return this.m_allowsCookieAssertions;
    }

    public boolean allowsCookieAuthentication() {
        return this.m_allowsCookieAuthentication;
    }

    public static boolean isRolePrincipal(Principal principal) {
        return principal instanceof Role || principal instanceof GroupPrincipal;
    }

    public static boolean isUserPrincipal(Principal principal) {
        return !AuthenticationManager.isRolePrincipal(principal);
    }

    protected Set<Principal> doJAASLogin(Class<? extends LoginModule> clazz, CallbackHandler handler, Map<String, String> options) throws WikiSecurityException {
        LoginModule loginModule = null;
        try {
            loginModule = clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new WikiSecurityException(e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new WikiSecurityException(e.getMessage(), e);
        }
        Subject subject = new Subject();
        loginModule.initialize(subject, handler, EMPTY_MAP, options);
        boolean loginSucceeded = false;
        boolean commitSucceeded = false;
        try {
            loginSucceeded = loginModule.login();
            if (loginSucceeded) {
                commitSucceeded = loginModule.commit();
            }
        }
        catch (LoginException loginException) {
            // empty catch block
        }
        if (loginSucceeded && commitSucceeded) {
            return subject.getPrincipals();
        }
        return NO_PRINCIPALS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static URL findConfigFile(WikiEngine engine, String name) {
        URL path;
        block16: {
            log.info((Object)("looking for " + name + " inside WEB-INF "));
            File defaultFile = null;
            if (engine.getRootPath() != null) {
                defaultFile = new File(engine.getRootPath() + "/WEB-INF/" + name);
            }
            if (defaultFile != null && defaultFile.exists()) {
                try {
                    return defaultFile.toURI().toURL();
                }
                catch (MalformedURLException e) {
                    log.warn((Object)("Malformed URL: " + e.getMessage()));
                }
            }
            path = null;
            if (engine.getServletContext() != null) {
                FileOutputStream os = null;
                InputStream is = null;
                try {
                    URL url = engine.getServletContext().getResource("/WEB-INF/" + name);
                    if (url != null) {
                        URL uRL = url;
                        return uRL;
                    }
                    log.info((Object)("looking for /" + name + " on classpath"));
                    is = AuthenticationManager.class.getResourceAsStream("/" + name);
                    if (is == null) {
                        throw new FileNotFoundException(name + " not found");
                    }
                    File tmpFile = File.createTempFile("temp." + name, "");
                    tmpFile.deleteOnExit();
                    os = new FileOutputStream(tmpFile);
                    byte[] buff = new byte[1024];
                    int bytes = 0;
                    while ((bytes = is.read(buff)) != -1) {
                        ((OutputStream)os).write(buff, 0, bytes);
                    }
                    path = tmpFile.toURI().toURL();
                    IOUtils.closeQuietly((InputStream)is);
                }
                catch (MalformedURLException e) {
                    log.fatal((Object)"Your code is b0rked.  You are a bad person.", (Throwable)e);
                    break block16;
                }
                catch (IOException e) {
                    log.error((Object)("failed to load security policy from file " + name + ",stacktrace follows"), (Throwable)e);
                    break block16;
                }
                finally {
                    IOUtils.closeQuietly(is);
                    IOUtils.closeQuietly(os);
                }
                IOUtils.closeQuietly((OutputStream)os);
            }
        }
        return path;
    }

    protected Principal getLoginPrincipal(Set<Principal> principals) {
        for (Principal principal : principals) {
            if (!AuthenticationManager.isUserPrincipal(principal)) continue;
            return principal;
        }
        return null;
    }

    public synchronized void addWikiEventListener(WikiEventListener listener) {
        WikiEventManager.addWikiEventListener(this, listener);
    }

    public synchronized void removeWikiEventListener(WikiEventListener listener) {
        WikiEventManager.removeWikiEventListener(this, listener);
    }

    protected void fireEvent(int type, Principal principal, Object target) {
        if (WikiEventManager.isListening(this)) {
            WikiEventManager.fireEvent(this, new WikiSecurityEvent(this, type, principal, target));
        }
    }

    private void initLoginModuleOptions(Properties props) {
        for (Object key : props.keySet()) {
            String optionKey;
            String propName = key.toString();
            if (!propName.startsWith(PREFIX_LOGIN_MODULE_OPTIONS) || (optionKey = propName.substring(PREFIX_LOGIN_MODULE_OPTIONS.length()).trim()).length() <= 0) continue;
            String optionValue = props.getProperty(propName);
            if (this.m_loginModuleOptions.containsKey(optionKey)) {
                throw new IllegalArgumentException("JAAS LoginModule key " + propName + " cannot be specified twice!");
            }
            this.m_loginModuleOptions.put(optionKey, optionValue);
        }
    }

    private void injectAuthorizerRoles(WikiSession session, Authorizer authorizer, HttpServletRequest request) {
        for (Principal role : authorizer.getRoles()) {
            WebAuthorizer wa;
            if (authorizer.isUserInRole(session, role)) {
                this.fireEvent(35, role, session);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Added authorizer role " + role.getName() + "."));
                continue;
            }
            if (request == null || !(authorizer instanceof WebAuthorizer) || !(wa = (WebAuthorizer)authorizer).isUserInRole(request, role)) continue;
            this.fireEvent(35, role, session);
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Added container role " + role.getName() + "."));
        }
    }
}

