/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.auth;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.log4j.Logger;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.WikiSession;
import org.apache.wiki.auth.PrincipalComparator;
import org.apache.wiki.event.WikiEventListener;
import org.apache.wiki.event.WikiEventManager;
import org.apache.wiki.event.WikiSecurityEvent;

public class SessionMonitor
implements HttpSessionListener {
    private static Logger log = Logger.getLogger(SessionMonitor.class);
    private static ConcurrentHashMap<WikiEngine, SessionMonitor> c_monitors = new ConcurrentHashMap();
    private final Map<String, WikiSession> m_sessions = new WeakHashMap<String, WikiSession>();
    private WikiEngine m_engine;
    private final PrincipalComparator m_comparator = new PrincipalComparator();

    public static final SessionMonitor getInstance(WikiEngine engine) {
        if (engine == null) {
            throw new IllegalArgumentException("Engine cannot be null.");
        }
        SessionMonitor monitor = c_monitors.get(engine);
        if (monitor == null) {
            monitor = new SessionMonitor(engine);
            c_monitors.put(engine, monitor);
        }
        return monitor;
    }

    public SessionMonitor() {
    }

    private SessionMonitor(WikiEngine engine) {
        this.m_engine = engine;
    }

    private WikiSession findSession(HttpSession session) {
        WikiSession wikiSession = null;
        String sid = session == null ? "(null)" : session.getId();
        WikiSession storedSession = this.m_sessions.get(sid);
        if (storedSession != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Looking up WikiSession for session ID=" + sid + "... found it"));
            }
            wikiSession = storedSession;
        }
        return wikiSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final WikiSession find(HttpSession session) {
        String sid;
        WikiSession wikiSession = this.findSession(session);
        String string = sid = session == null ? "(null)" : session.getId();
        if (wikiSession == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Looking up WikiSession for session ID=" + sid + "... not found. Creating guestSession()"));
            }
            wikiSession = WikiSession.guestSession(this.m_engine);
            Map<String, WikiSession> map = this.m_sessions;
            synchronized (map) {
                this.m_sessions.put(sid, wikiSession);
            }
        }
        return wikiSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void remove(HttpSession session) {
        if (session == null) {
            throw new IllegalArgumentException("Session cannot be null.");
        }
        Map<String, WikiSession> map = this.m_sessions;
        synchronized (map) {
            this.m_sessions.remove(session.getId());
        }
    }

    public final int sessions() {
        return this.userPrincipals().length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Principal[] userPrincipals() {
        ArrayList<Principal> principals = new ArrayList<Principal>();
        Map<String, WikiSession> map = this.m_sessions;
        synchronized (map) {
            for (WikiSession session : this.m_sessions.values()) {
                principals.add(session.getUserPrincipal());
            }
        }
        Principal[] p = principals.toArray(new Principal[principals.size()]);
        Arrays.sort(p, this.m_comparator);
        return p;
    }

    public final synchronized void addWikiEventListener(WikiEventListener listener) {
        WikiEventManager.addWikiEventListener(this, listener);
    }

    public final synchronized void removeWikiEventListener(WikiEventListener listener) {
        WikiEventManager.removeWikiEventListener(this, listener);
    }

    protected final void fireEvent(int type, Principal principal, WikiSession session) {
        if (WikiEventManager.isListening(this)) {
            WikiEventManager.fireEvent(this, new WikiSecurityEvent(this, type, principal, session));
        }
    }

    public void sessionCreated(HttpSessionEvent se) {
        HttpSession session = se.getSession();
        log.debug((Object)("Created session: " + session.getId() + "."));
    }

    public void sessionDestroyed(HttpSessionEvent se) {
        HttpSession session = se.getSession();
        for (SessionMonitor monitor : c_monitors.values()) {
            WikiSession storedSession = monitor.findSession(session);
            monitor.remove(session);
            log.debug((Object)("Removed session " + session.getId() + "."));
            if (storedSession == null) continue;
            this.fireEvent(45, storedSession.getLoginPrincipal(), storedSession);
        }
    }
}

