/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.auth.authorize;

import java.io.IOException;
import java.net.URL;
import java.security.Principal;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.apache.wiki.InternalWikiException;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.WikiSession;
import org.apache.wiki.auth.authorize.Role;
import org.apache.wiki.auth.authorize.WebAuthorizer;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.jdom2.input.SAXBuilder;
import org.jdom2.input.sax.XMLReaderJDOMFactory;
import org.jdom2.input.sax.XMLReaders;
import org.jdom2.xpath.XPath;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class WebContainerAuthorizer
implements WebAuthorizer {
    private static final String J2EE_SCHEMA_25_NAMESPACE = "http://java.sun.com/xml/ns/javaee";
    protected static final Logger log = Logger.getLogger(WebContainerAuthorizer.class);
    protected WikiEngine m_engine;
    protected Role[] m_containerRoles = new Role[0];
    protected boolean m_containerAuthorized = false;
    private Document m_webxml = null;

    @Override
    public void initialize(WikiEngine engine, Properties props) {
        this.m_engine = engine;
        this.m_containerAuthorized = false;
        try {
            this.m_webxml = this.getWebXml();
            if (this.m_webxml != null) {
                this.m_webxml.getRootElement().setNamespace(Namespace.getNamespace((String)J2EE_SCHEMA_25_NAMESPACE));
                boolean bl = this.m_containerAuthorized = this.isConstrained("/Delete.jsp", Role.ALL) && this.isConstrained("/Login.jsp", Role.ALL);
            }
            if (this.m_containerAuthorized) {
                this.m_containerRoles = this.getRoles(this.m_webxml);
                log.info((Object)"JSPWiki is using container-managed authentication.");
            } else {
                log.info((Object)"JSPWiki is using custom authentication.");
            }
        }
        catch (IOException e) {
            log.error((Object)"Initialization failed: ", (Throwable)e);
            throw new InternalWikiException(e.getClass().getName() + ": " + e.getMessage(), e);
        }
        catch (JDOMException e) {
            log.error((Object)"Malformed XML in web.xml", (Throwable)e);
            throw new InternalWikiException(((Object)((Object)e)).getClass().getName() + ": " + e.getMessage(), e);
        }
        if (this.m_containerRoles.length > 0) {
            String roles = "";
            for (Role containerRole : this.m_containerRoles) {
                roles = roles + containerRole + " ";
            }
            log.info((Object)(" JSPWiki determined the web container manages these roles: " + roles));
        }
        log.info((Object)"Authorizer WebContainerAuthorizer initialized successfully.");
    }

    @Override
    public boolean isUserInRole(HttpServletRequest request, Principal role) {
        return request.isUserInRole(role.getName());
    }

    @Override
    public boolean isUserInRole(WikiSession session, Principal role) {
        if (session == null || role == null) {
            return false;
        }
        return session.hasPrincipal(role);
    }

    @Override
    public Principal findRole(String role) {
        for (Role containerRole : this.m_containerRoles) {
            if (!containerRole.getName().equals(role)) continue;
            return containerRole;
        }
        return null;
    }

    public boolean isConstrained(String url, Role role) throws JDOMException {
        Element root = this.m_webxml.getRootElement();
        String selector = "//j:web-app/j:security-constraint[j:web-resource-collection/j:url-pattern=\"" + url + "\"]";
        XPath xpath = XPath.newInstance((String)selector);
        xpath.addNamespace("j", J2EE_SCHEMA_25_NAMESPACE);
        List constraints = xpath.selectNodes((Object)root);
        selector = "//j:web-app/j:security-constraint[j:auth-constraint/j:role-name=\"" + role.getName() + "\"]";
        xpath = XPath.newInstance((String)selector);
        xpath.addNamespace("j", J2EE_SCHEMA_25_NAMESPACE);
        List roles = xpath.selectNodes((Object)root);
        if (constraints.size() == 0) {
            return false;
        }
        if (role.equals(Role.ALL)) {
            return true;
        }
        if (roles.size() == 0) {
            return false;
        }
        for (Element constraint : constraints) {
            for (Element roleConstraint : roles) {
                if (!constraint.equals((Object)roleConstraint)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isContainerAuthorized() {
        return this.m_containerAuthorized;
    }

    @Override
    public Principal[] getRoles() {
        return (Principal[])this.m_containerRoles.clone();
    }

    protected Role[] getRoles(Document webxml) throws JDOMException {
        String role;
        HashSet<Role> roles = new HashSet<Role>();
        Element root = webxml.getRootElement();
        String selector = "//j:web-app/j:security-constraint/j:auth-constraint/j:role-name";
        XPath xpath = XPath.newInstance((String)selector);
        xpath.addNamespace("j", J2EE_SCHEMA_25_NAMESPACE);
        List nodes = xpath.selectNodes((Object)root);
        Iterator it = nodes.iterator();
        while (it.hasNext()) {
            role = ((Element)it.next()).getTextTrim();
            roles.add(new Role(role));
        }
        selector = "//j:web-app/j:security-role/j:role-name";
        xpath = XPath.newInstance((String)selector);
        xpath.addNamespace("j", J2EE_SCHEMA_25_NAMESPACE);
        nodes = xpath.selectNodes((Object)root);
        it = nodes.iterator();
        while (it.hasNext()) {
            role = ((Element)it.next()).getTextTrim();
            roles.add(new Role(role));
        }
        return roles.toArray(new Role[roles.size()]);
    }

    protected Document getWebXml() throws JDOMException, IOException {
        URL url;
        SAXBuilder builder = new SAXBuilder();
        builder.setXMLReaderFactory((XMLReaderJDOMFactory)XMLReaders.NONVALIDATING);
        builder.setEntityResolver((EntityResolver)new LocalEntityResolver());
        Document doc = null;
        if (this.m_engine.getServletContext() == null) {
            ClassLoader cl = WebContainerAuthorizer.class.getClassLoader();
            url = cl.getResource("WEB-INF/web.xml");
            if (url != null) {
                log.info((Object)("Examining " + url.toExternalForm()));
            }
        } else {
            url = this.m_engine.getServletContext().getResource("/WEB-INF/web.xml");
            if (url != null) {
                log.info((Object)("Examining " + url.toExternalForm()));
            }
        }
        if (url == null) {
            throw new IOException("Unable to find web.xml for processing.");
        }
        log.debug((Object)("Processing web.xml at " + url.toExternalForm()));
        doc = builder.build(url);
        return doc;
    }

    public class LocalEntityResolver
    implements EntityResolver {
        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            URL url;
            String file = systemId.substring(systemId.lastIndexOf(47) + 1);
            if (WebContainerAuthorizer.this.m_engine.getServletContext() == null) {
                ClassLoader cl = WebContainerAuthorizer.class.getClassLoader();
                url = cl.getResource("WEB-INF/dtd/" + file);
            } else {
                url = WebContainerAuthorizer.this.m_engine.getServletContext().getResource("/WEB-INF/dtd/" + file);
            }
            if (url != null) {
                InputSource is = new InputSource(url.openStream());
                log.debug((Object)("Resolved systemID=" + systemId + " using local file " + url));
                return is;
            }
            log.info((Object)("Please note: There are no local DTD references in /WEB-INF/dtd/" + file + "; falling back to default behaviour. This may mean that the XML parser will attempt to connect to the internet to find the DTD. If you are running JSPWiki locally in an unconnected network, you might want to put the DTD files in place to avoid nasty UnknownHostExceptions."));
            return null;
        }
    }
}

