/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.event;

import java.util.EventObject;

public abstract class WikiEvent
extends EventObject {
    private static final long serialVersionUID = 1829433967558773960L;
    public static final int ERROR = -99;
    public static final int UNDEFINED = -98;
    private int m_type = -98;
    private final long m_when = System.currentTimeMillis();

    public WikiEvent(Object src, int type) {
        super(src);
        this.setType(type);
    }

    public <T> T getSrc() {
        return (T)super.getSource();
    }

    public long getWhen() {
        return this.m_when;
    }

    protected void setType(int type) {
        this.m_type = type;
    }

    public int getType() {
        return this.m_type;
    }

    public String getTypeDescription() {
        switch (this.m_type) {
            case -99: {
                return "exception or error event";
            }
            case -98: {
                return "undefined event type";
            }
        }
        return "unknown event type (" + this.m_type + ")";
    }

    public static boolean isValidType(int type) {
        return type != -99 && type != -98;
    }

    public String eventName() {
        switch (this.m_type) {
            case -99: {
                return "ERROR";
            }
            case -98: {
                return "UNDEFINED";
            }
        }
        return "UNKNOWN (" + this.m_type + ")";
    }

    @Override
    public String toString() {
        StringBuilder out = new StringBuilder();
        out.append("WikiEvent.");
        out.append(this.eventName());
        out.append(" [source=");
        out.append(this.getSource().toString());
        out.append("]");
        return out.toString();
    }
}

