/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.filters;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.apache.wiki.WikiContext;
import org.apache.wiki.api.filters.BasicPageFilter;
import org.apache.wiki.util.TextUtil;

public class ProfanityFilter
extends BasicPageFilter {
    private static final Logger log = Logger.getLogger(ProfanityFilter.class);
    private static final String PROPERTYFILE = "org/apache/wiki/filters/profanity.properties";
    private static String[] c_profanities = new String[0];

    @Override
    public String preTranslate(WikiContext context, String content) {
        for (int i = 0; i < c_profanities.length; ++i) {
            String word = c_profanities[i];
            String replacement = word.charAt(0) + "*" + word.charAt(word.length() - 1);
            content = TextUtil.replaceStringCaseUnsensitive(content, word, replacement);
        }
        return content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    static {
        BufferedReader br = null;
        InputStream in = null;
        try {
            String str;
            ClassLoader loader = ProfanityFilter.class.getClassLoader();
            in = loader.getResourceAsStream(PROPERTYFILE);
            if (in == null) {
                throw new IOException("No property file found! (Check the installation, it should be there.)");
            }
            br = new BufferedReader(new InputStreamReader(in));
            ArrayList<String> profs = new ArrayList<String>();
            while ((str = br.readLine()) != null) {
                if (str.length() <= 0 || str.startsWith("#")) continue;
                profs.add(str);
            }
            c_profanities = profs.toArray(new String[0]);
        }
        catch (IOException e) {
            log.error((Object)"Unable to load profanities from org/apache/wiki/filters/profanity.properties", (Throwable)e);
            IOUtils.closeQuietly(br);
            IOUtils.closeQuietly((InputStream)in);
        }
        catch (Exception e2) {
            log.error((Object)"Unable to initialize Profanity Filter", (Throwable)e2);
            {
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(br);
                    IOUtils.closeQuietly(in);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly(br);
            IOUtils.closeQuietly((InputStream)in);
        }
        IOUtils.closeQuietly((Reader)br);
        IOUtils.closeQuietly((InputStream)in);
    }
}

