/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.modules;

import java.util.Collection;
import java.util.Iterator;
import java.util.TreeSet;
import org.apache.wiki.Release;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.modules.WikiModuleInfo;

public abstract class ModuleManager {
    public static final String PLUGIN_RESOURCE_LOCATION = "ini/jspwiki_module.xml";
    protected WikiEngine m_engine;
    private boolean m_loadIncompatibleModules = false;

    public ModuleManager(WikiEngine engine) {
        this.m_engine = engine;
    }

    public boolean checkCompatibility(WikiModuleInfo info) {
        if (!this.m_loadIncompatibleModules) {
            String minVersion = info.getMinVersion();
            String maxVersion = info.getMaxVersion();
            return Release.isNewerOrEqual(minVersion) && Release.isOlderOrEqual(maxVersion);
        }
        return true;
    }

    public abstract Collection<WikiModuleInfo> modules();

    protected <T extends WikiModuleInfo> Collection<WikiModuleInfo> modules(Iterator<T> iterator) {
        TreeSet<WikiModuleInfo> ls = new TreeSet<WikiModuleInfo>();
        Iterator<T> i = iterator;
        while (i.hasNext()) {
            WikiModuleInfo wmi = (WikiModuleInfo)i.next();
            if (ls.contains(wmi)) continue;
            ls.add(wmi);
        }
        return ls;
    }

    public abstract WikiModuleInfo getModuleInfo(String var1);
}

