/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.plugin;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.apache.oro.text.GlobCompiler;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Matcher;
import org.apache.wiki.WikiContext;
import org.apache.wiki.api.exceptions.PluginException;
import org.apache.wiki.api.plugin.WikiPlugin;

public class Denounce
implements WikiPlugin {
    private static Logger log = Logger.getLogger(Denounce.class);
    public static final String PARAM_LINK = "link";
    public static final String PARAM_TEXT = "text";
    private static final String PROPERTYFILE = "org/apache/wiki/plugin/denounce.properties";
    private static final String PROP_AGENTPATTERN = "denounce.agentpattern.";
    private static final String PROP_HOSTPATTERN = "denounce.hostpattern.";
    private static final String PROP_REFERERPATTERN = "denounce.refererpattern.";
    private static final String PROP_DENOUNCETEXT = "denounce.denouncetext";
    private static ArrayList<Pattern> c_refererPatterns = new ArrayList();
    private static ArrayList<Pattern> c_agentPatterns = new ArrayList();
    private static ArrayList<Pattern> c_hostPatterns = new ArrayList();
    private static String c_denounceText = "";

    @Override
    public String execute(WikiContext context, Map<String, String> params) throws PluginException {
        String link = params.get(PARAM_LINK);
        String text = params.get(PARAM_TEXT);
        boolean linkAllowed = true;
        if (link == null) {
            throw new PluginException("Denounce: No parameter link defined!");
        }
        HttpServletRequest request = context.getHttpRequest();
        if (request != null) {
            boolean bl = linkAllowed = !this.matchHeaders(request);
        }
        if (text == null) {
            text = link;
        }
        if (linkAllowed) {
            return "<a href=\"" + link + "\">" + text + "</a>";
        }
        return c_denounceText;
    }

    private boolean matchPattern(List<Pattern> list, String path) {
        Perl5Matcher matcher = new Perl5Matcher();
        Iterator<Pattern> i = list.iterator();
        while (i.hasNext()) {
            if (!matcher.matches(path, i.next())) continue;
            return true;
        }
        return false;
    }

    private boolean matchHeaders(HttpServletRequest request) {
        String userAgent = request.getHeader("User-Agent");
        if (userAgent != null && this.matchPattern(c_agentPatterns, userAgent)) {
            log.debug((Object)("Matched user agent " + userAgent + " for denounce."));
            return true;
        }
        String refererPath = request.getHeader("Referer");
        if (refererPath != null && this.matchPattern(c_refererPatterns, refererPath)) {
            log.debug((Object)("Matched referer " + refererPath + " for denounce."));
            return true;
        }
        String host = request.getRemoteHost();
        if (host != null && this.matchPattern(c_hostPatterns, host)) {
            log.debug((Object)("Matched host " + host + " for denounce."));
            return true;
        }
        return false;
    }

    static {
        try {
            GlobCompiler compiler = new GlobCompiler();
            ClassLoader loader = Denounce.class.getClassLoader();
            InputStream in = loader.getResourceAsStream(PROPERTYFILE);
            if (in == null) {
                throw new IOException("No property file found! (Check the installation, it should be there.)");
            }
            Properties props = new Properties();
            props.load(in);
            c_denounceText = props.getProperty(PROP_DENOUNCETEXT, c_denounceText);
            Enumeration<?> e = props.propertyNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                try {
                    if (name.startsWith(PROP_REFERERPATTERN)) {
                        c_refererPatterns.add(compiler.compile(props.getProperty(name)));
                        continue;
                    }
                    if (name.startsWith(PROP_AGENTPATTERN)) {
                        c_agentPatterns.add(compiler.compile(props.getProperty(name)));
                        continue;
                    }
                    if (!name.startsWith(PROP_HOSTPATTERN)) continue;
                    c_hostPatterns.add(compiler.compile(props.getProperty(name)));
                }
                catch (MalformedPatternException ex) {
                    log.error((Object)("Malformed URL pattern in org/apache/wiki/plugin/denounce.properties: " + props.getProperty(name)), (Throwable)ex);
                }
            }
            log.debug((Object)("Added " + c_refererPatterns.size() + c_agentPatterns.size() + c_hostPatterns.size() + " crawlers to denounce list."));
        }
        catch (IOException e) {
            log.error((Object)"Unable to load URL patterns from org/apache/wiki/plugin/denounce.properties", (Throwable)e);
        }
        catch (Exception e) {
            log.error((Object)"Unable to initialize Denounce plugin", (Throwable)e);
        }
    }
}

