/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.plugin;

import java.security.Principal;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import org.apache.wiki.WikiContext;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.api.exceptions.PluginException;
import org.apache.wiki.api.plugin.WikiPlugin;
import org.apache.wiki.auth.PrincipalComparator;
import org.apache.wiki.auth.authorize.GroupManager;

public class Groups
implements WikiPlugin {
    private static final Comparator<Principal> COMPARATOR = new PrincipalComparator();

    @Override
    public String execute(WikiContext context, Map<String, String> params) throws PluginException {
        WikiEngine engine = context.getEngine();
        GroupManager groupMgr = engine.getGroupManager();
        Principal[] groups = groupMgr.getRoles();
        Arrays.sort(groups, COMPARATOR);
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < groups.length; ++i) {
            String name = groups[i].getName();
            String url = engine.getURLConstructor().makeURL(WikiContext.VIEW_GROUP, name, false, null);
            s.append("<a href=\"");
            s.append(url);
            s.append("\">");
            s.append(name);
            s.append("</a>");
            if (i >= groups.length - 1) continue;
            s.append(',');
            s.append(' ');
        }
        return s.toString();
    }
}

