/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.plugin;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.log4j.Logger;
import org.apache.oro.text.GlobCompiler;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Matcher;
import org.apache.wiki.ReferenceManager;
import org.apache.wiki.WikiBackgroundThread;
import org.apache.wiki.WikiContext;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.WikiPage;
import org.apache.wiki.api.exceptions.PluginException;
import org.apache.wiki.api.plugin.InitializablePlugin;
import org.apache.wiki.api.plugin.WikiPlugin;
import org.apache.wiki.event.WikiEngineEvent;
import org.apache.wiki.event.WikiEvent;
import org.apache.wiki.event.WikiEventListener;
import org.apache.wiki.event.WikiPageEvent;
import org.apache.wiki.event.WikiPageRenameEvent;
import org.apache.wiki.plugin.AbstractReferralPlugin;
import org.apache.wiki.util.TextUtil;

public class PageViewPlugin
extends AbstractReferralPlugin
implements WikiPlugin,
InitializablePlugin {
    private static final Logger log = Logger.getLogger(PageViewPlugin.class);
    private static PageViewManager c_singleton = null;
    private static final String PARAM_COUNT = "count";
    private static final String PARAM_MAX_ENTRIES = "entries";
    private static final String PARAM_MAX_COUNT = "max";
    private static final String PARAM_MIN_COUNT = "min";
    private static final String PARAM_REFER = "refer";
    private static final String PARAM_SORT = "sort";
    private static final String STR_NONE = "none";
    private static final String STR_LIST = "list";
    private static final String STR_YES = "yes";
    private static final String STR_EMPTY = "";
    private static final String STR_SEPARATOR = "----";
    private static final String STR_COMMA = ",";
    private static final String STR_GLOBSTAR = "*";
    private static final String COUNTER_PAGE = "PageCount.txt";
    private static final int STORAGE_INTERVAL = 60;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialize(WikiEngine engine) {
        log.info((Object)"initializing PageViewPlugin");
        PageViewPlugin pageViewPlugin = this;
        synchronized (pageViewPlugin) {
            if (c_singleton == null) {
                c_singleton = new PageViewManager();
            }
            c_singleton.initialize(engine);
        }
    }

    private void cleanup() {
        log.info((Object)"cleaning up PageView Manager");
        c_singleton = null;
    }

    @Override
    public String execute(WikiContext context, Map<String, String> params) throws PluginException {
        PageViewManager manager = c_singleton;
        String result = STR_EMPTY;
        if (manager != null) {
            result = manager.execute(context, params);
        }
        return result;
    }

    static final class CounterSaveThread
    extends WikiBackgroundThread {
        private final PageViewManager m_manager;

        public CounterSaveThread(WikiEngine engine, int interval, PageViewManager pageViewManager) {
            super(engine, interval);
            if (pageViewManager == null) {
                throw new IllegalArgumentException("Manager cannot be null");
            }
            this.m_manager = pageViewManager;
        }

        @Override
        public void backgroundTask() {
            if (this.m_manager.isRunning(this)) {
                this.m_manager.storeCounters();
            }
        }
    }

    private static final class Counter {
        private int m_count = 0;

        public Counter() {
        }

        public Counter(String value) {
            this.setValue(value);
        }

        public void increment() {
            ++this.m_count;
        }

        public int getValue() {
            return this.m_count;
        }

        public void setValue(String value) {
            this.m_count = NumberUtils.toInt((String)value);
        }

        public String toString() {
            return String.valueOf(this.m_count);
        }
    }

    public final class PageViewManager
    implements WikiEventListener {
        private boolean m_initialized = false;
        private Map<String, Counter> m_counters = null;
        private Properties m_storage = null;
        private boolean m_dirty = false;
        private Thread m_pageCountSaveThread = null;
        private String m_workDir = null;
        private final Comparator<Object> m_compareCountDescending = new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                int v2;
                int v1 = PageViewManager.this.getCount(o1);
                return v1 == (v2 = PageViewManager.this.getCount(o2)) ? ((String)o1).compareTo((String)o2) : (v1 < v2 ? 1 : -1);
            }
        };

        public synchronized void initialize(WikiEngine engine) {
            log.info((Object)"initializing PageView Manager");
            this.m_workDir = engine.getWorkDir();
            engine.addWikiEventListener(this);
            if (this.m_counters == null) {
                this.m_storage = new Properties();
                this.m_counters = new TreeMap<String, Counter>();
                this.loadCounters();
            }
            if (this.m_pageCountSaveThread == null) {
                this.m_pageCountSaveThread = new CounterSaveThread(engine, 300, this);
                this.m_pageCountSaveThread.start();
            }
            this.m_initialized = true;
        }

        private synchronized void handleShutdown() {
            log.info((Object)"handleShutdown: The counter store thread was shut down.");
            PageViewPlugin.this.cleanup();
            if (this.m_counters != null) {
                this.m_dirty = true;
                this.storeCounters();
                this.m_counters.clear();
                this.m_counters = null;
                this.m_storage.clear();
                this.m_storage = null;
            }
            this.m_initialized = false;
            this.m_pageCountSaveThread = null;
        }

        @Override
        public void actionPerformed(WikiEvent event) {
            if (event instanceof WikiEngineEvent) {
                if (event.getType() == 1) {
                    log.info((Object)"Detected wiki engine shutdown");
                    this.handleShutdown();
                }
            } else if (event instanceof WikiPageRenameEvent && event.getType() == 28) {
                String oldPageName = ((WikiPageRenameEvent)event).getOldPageName();
                String newPageName = ((WikiPageRenameEvent)event).getNewPageName();
                Counter oldCounter = this.m_counters.get(oldPageName);
                if (oldCounter != null) {
                    this.m_storage.remove(oldPageName);
                    this.m_counters.put(newPageName, oldCounter);
                    this.m_storage.setProperty(newPageName, oldCounter.toString());
                    this.m_counters.remove(oldPageName);
                    this.m_dirty = true;
                }
            } else if (event instanceof WikiPageEvent && event.getType() == 27) {
                String pageName = ((WikiPageEvent)event).getPageName();
                this.m_storage.remove(pageName);
                this.m_counters.remove(pageName);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String execute(WikiContext context, Map<String, String> params) throws PluginException {
            WikiEngine engine = context.getEngine();
            WikiPage page = context.getPage();
            String result = PageViewPlugin.STR_EMPTY;
            if (page != null) {
                String pagename = page.getName();
                String count = params.get(PageViewPlugin.PARAM_COUNT);
                String show = params.get("show");
                int entries = TextUtil.parseIntParameter(params.get(PageViewPlugin.PARAM_MAX_ENTRIES), Integer.MAX_VALUE);
                int max = TextUtil.parseIntParameter(params.get(PageViewPlugin.PARAM_MAX_COUNT), Integer.MAX_VALUE);
                int min = TextUtil.parseIntParameter(params.get(PageViewPlugin.PARAM_MIN_COUNT), Integer.MIN_VALUE);
                String sort = params.get(PageViewPlugin.PARAM_SORT);
                String body = params.get("_body");
                Pattern[] exclude = this.compileGlobs("exclude", params.get("exclude"));
                Pattern[] include = this.compileGlobs("include", params.get("include"));
                Pattern[] refer = this.compileGlobs(PageViewPlugin.PARAM_REFER, params.get(PageViewPlugin.PARAM_REFER));
                Perl5Matcher matcher = null != exclude || null != include || null != refer ? new Perl5Matcher() : null;
                boolean increment = false;
                if (PageViewPlugin.STR_YES.equals(count)) {
                    increment = true;
                } else {
                    count = null;
                }
                if ((show == null || PageViewPlugin.STR_NONE.equals(show)) && count == null) {
                    increment = true;
                }
                HashSet<String> referrers = null;
                if (refer != null) {
                    ReferenceManager refManager = engine.getReferenceManager();
                    Iterator<String> iter = refManager.findCreated().iterator();
                    while (iter != null && iter.hasNext()) {
                        Set<String> refs;
                        String name = iter.next();
                        boolean use = false;
                        for (int n = 0; !use && n < refer.length; ++n) {
                            use = matcher.matches(name, refer[n]);
                        }
                        if (!use || (refs = engine.getReferenceManager().findReferrers(name)) == null || refs.isEmpty()) continue;
                        if (referrers == null) {
                            referrers = new HashSet<String>();
                        }
                        referrers.addAll(refs);
                    }
                }
                PageViewManager pageViewManager = this;
                synchronized (pageViewManager) {
                    Counter counter = this.m_counters.get(pagename);
                    if (increment && WikiContext.VIEW.equalsIgnoreCase(context.getRequestContext())) {
                        if (counter == null) {
                            counter = new Counter();
                            this.m_counters.put(pagename, counter);
                        }
                        counter.increment();
                        this.m_storage.setProperty(pagename, counter.toString());
                        this.m_dirty = true;
                    }
                    if (show != null && !PageViewPlugin.STR_NONE.equals(show)) {
                        if (PageViewPlugin.PARAM_COUNT.equals(show)) {
                            if (counter == null) {
                                counter = new Counter();
                                this.m_counters.put(pagename, counter);
                                this.m_storage.setProperty(pagename, counter.toString());
                                this.m_dirty = true;
                            }
                            result = counter.toString();
                        } else if (body != null && 0 < body.length() && PageViewPlugin.STR_LIST.equals(show)) {
                            String header = PageViewPlugin.STR_EMPTY;
                            String line = body;
                            String footer = PageViewPlugin.STR_EMPTY;
                            int start = body.indexOf(PageViewPlugin.STR_SEPARATOR);
                            if (0 < start) {
                                int end;
                                header = body.substring(0, start);
                                if ((start = this.skipWhitespace(start + PageViewPlugin.STR_SEPARATOR.length(), body)) >= (end = body.indexOf(PageViewPlugin.STR_SEPARATOR, start))) {
                                    line = body.substring(start);
                                } else {
                                    line = body.substring(start, end);
                                    end = this.skipWhitespace(end + PageViewPlugin.STR_SEPARATOR.length(), body);
                                    footer = body.substring(end);
                                }
                            }
                            Map<String, Counter> sorted = this.m_counters;
                            if (sort != null && PageViewPlugin.PARAM_COUNT.equals(sort)) {
                                sorted = new TreeMap<Object, Counter>(this.m_compareCountDescending);
                                sorted.putAll(this.m_counters);
                            }
                            StringBuffer buf = new StringBuffer(header);
                            MessageFormat fmt = new MessageFormat(line);
                            Object[] args = new Object[]{pagename, PageViewPlugin.STR_EMPTY, PageViewPlugin.STR_EMPTY};
                            Iterator<Map.Entry<String, Counter>> iter = sorted.entrySet().iterator();
                            while (iter != null && 0 < entries && iter.hasNext()) {
                                int n;
                                boolean use;
                                Map.Entry<String, Counter> entry = iter.next();
                                String name = entry.getKey();
                                int value = entry.getValue().getValue();
                                boolean bl = use = min <= value && value <= max;
                                if (use && referrers != null) {
                                    use = referrers.contains(name);
                                }
                                if (use && include != null) {
                                    use = false;
                                    for (n = 0; !use && n < include.length; ++n) {
                                        use = matcher.matches(name, include[n]);
                                    }
                                }
                                if (use && null != exclude) {
                                    for (n = 0; use && n < exclude.length; use &= !matcher.matches(name, exclude[n]), ++n) {
                                    }
                                }
                                if (!use) continue;
                                args[1] = engine.beautifyTitle(name);
                                args[2] = entry.getValue();
                                fmt.format(args, buf, (FieldPosition)null);
                                --entries;
                            }
                            buf.append(footer);
                            result = engine.textToHTML(context, buf.toString());
                        }
                    }
                }
            }
            return result;
        }

        private Pattern[] compileGlobs(String name, String value) throws PluginException {
            Pattern[] result = null;
            if (value != null && 0 < value.length() && !PageViewPlugin.STR_GLOBSTAR.equals(value)) {
                try {
                    GlobCompiler pc = new GlobCompiler();
                    String[] ptrns = StringUtils.split((String)value, (String)PageViewPlugin.STR_COMMA);
                    result = new Pattern[ptrns.length];
                    for (int n = 0; n < ptrns.length; ++n) {
                        result[n] = pc.compile(ptrns[n]);
                    }
                }
                catch (MalformedPatternException e) {
                    throw new PluginException("Parameter " + name + " has a malformed pattern: " + e.getMessage());
                }
            }
            return result;
        }

        private int skipWhitespace(int offset, String value) {
            while (Character.isWhitespace(value.charAt(offset))) {
                ++offset;
            }
            return offset;
        }

        protected int getCount(Object key) {
            return this.m_counters.get(key).getValue();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void loadCounters() {
            block8: {
                if (this.m_counters == null || this.m_storage == null) break block8;
                log.info((Object)"Loading counters.");
                PageViewManager pageViewManager = this;
                synchronized (pageViewManager) {
                    FileInputStream fis = null;
                    try {
                        fis = new FileInputStream(new File(this.m_workDir, PageViewPlugin.COUNTER_PAGE));
                        this.m_storage.load(fis);
                    }
                    catch (IOException ioe) {
                        try {
                            log.error((Object)("Can't load page counter store: " + ioe.getMessage() + " , will create a new one!"));
                        }
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(fis);
                            throw throwable;
                        }
                        IOUtils.closeQuietly((InputStream)fis);
                    }
                    IOUtils.closeQuietly((InputStream)fis);
                    Iterator<Map.Entry<Object, Object>> iter = this.m_storage.entrySet().iterator();
                    while (iter != null && iter.hasNext()) {
                        Map.Entry<Object, Object> entry = iter.next();
                        this.m_counters.put((String)entry.getKey(), new Counter((String)entry.getValue()));
                    }
                    log.info((Object)("Loaded " + this.m_counters.size() + " counter values."));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void storeCounters() {
            block7: {
                if (this.m_counters == null || this.m_storage == null || !this.m_dirty) break block7;
                log.info((Object)("Storing " + this.m_counters.size() + " counter values."));
                PageViewManager pageViewManager = this;
                synchronized (pageViewManager) {
                    FileOutputStream fos = null;
                    try {
                        fos = new FileOutputStream(new File(this.m_workDir, PageViewPlugin.COUNTER_PAGE));
                        this.m_storage.store(fos, "\n# The number of times each page has been viewed.\n# Do not modify.\n");
                        fos.flush();
                        this.m_dirty = false;
                    }
                    catch (IOException ioe) {
                        try {
                            log.error((Object)("Couldn't store counters values: " + ioe.getMessage()));
                        }
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(fos);
                            throw throwable;
                        }
                        IOUtils.closeQuietly((OutputStream)fos);
                    }
                    IOUtils.closeQuietly((OutputStream)fos);
                }
            }
        }

        private synchronized boolean isRunning(Thread thrd) {
            return this.m_initialized && thrd == this.m_pageCountSaveThread;
        }
    }
}

