/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.plugin;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.wiki.WikiContext;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.WikiPage;
import org.apache.wiki.api.exceptions.PluginException;
import org.apache.wiki.api.plugin.WikiPlugin;
import org.apache.wiki.attachment.Attachment;
import org.apache.wiki.plugin.AbstractReferralPlugin;
import org.apache.wiki.preferences.Preferences;
import org.apache.wiki.util.TextUtil;
import org.apache.wiki.util.XHTML;
import org.apache.wiki.util.XhtmlUtil;
import org.jdom2.Content;
import org.jdom2.Element;

public class RecentChangesPlugin
extends AbstractReferralPlugin
implements WikiPlugin {
    private static final Logger log = Logger.getLogger(RecentChangesPlugin.class);
    public static final String PARAM_FORMAT = "format";
    public static final String PARAM_TIME_FORMAT = "timeFormat";
    public static final String PARAM_DATE_FORMAT = "dateFormat";
    private static final int DEFAULT_DAYS = 36500;
    public static final String DEFAULT_TIME_FORMAT = "HH:mm:ss";
    public static final String DEFAULT_DATE_FORMAT = "dd.MM.yyyy";

    @Override
    public String execute(WikiContext context, Map<String, String> params) throws PluginException {
        int since = TextUtil.parseIntParameter(params.get("since"), 36500);
        String spacing = "4";
        boolean showAuthor = true;
        boolean showChangenote = true;
        String tablewidth = "4";
        WikiEngine engine = context.getEngine();
        if ("compact".equals(params.get(PARAM_FORMAT))) {
            spacing = "0";
            showAuthor = false;
            showChangenote = false;
            tablewidth = "2";
        }
        GregorianCalendar sincedate = new GregorianCalendar();
        ((Calendar)sincedate).add(5, -since);
        log.debug((Object)("Calculating recent changes from " + sincedate.getTime()));
        Collection<WikiPage> changes = engine.getRecentChanges();
        super.initialize(context, params);
        changes = super.filterCollection(changes);
        if (changes != null) {
            WikiPage pageref;
            Date lastmod;
            Date olddate = new Date(0L);
            DateFormat fmt = this.getDateFormat(context, params);
            DateFormat tfmt = this.getTimeFormat(context, params);
            Element rt = XhtmlUtil.element(XHTML.table);
            rt.setAttribute("class", "recentchanges");
            rt.setAttribute("cellpadding", spacing);
            Iterator<WikiPage> i = changes.iterator();
            while (i.hasNext() && !(lastmod = (pageref = i.next()).getLastModified()).before(sincedate.getTime())) {
                if (!this.isSameDay(lastmod, olddate)) {
                    Element row = XhtmlUtil.element(XHTML.tr);
                    Element col = XhtmlUtil.element(XHTML.td);
                    col.setAttribute("colspan", tablewidth);
                    col.setAttribute("class", "date");
                    col.addContent((Content)XhtmlUtil.element(XHTML.b, fmt.format(lastmod)));
                    rt.addContent((Content)row);
                    row.addContent((Content)col);
                    olddate = lastmod;
                }
                String href = context.getURL(pageref instanceof Attachment ? WikiContext.ATTACH : WikiContext.VIEW, pageref.getName());
                Element link = XhtmlUtil.link(href, engine.beautifyTitle(pageref.getName()));
                Element row = XhtmlUtil.element(XHTML.tr);
                Element col = XhtmlUtil.element(XHTML.td);
                col.setAttribute("width", "30%");
                col.addContent((Content)link);
                if (pageref instanceof Attachment) {
                    link = XhtmlUtil.link(context.getURL(WikiContext.INFO, pageref.getName()), null);
                    link.setAttribute("class", "infolink");
                    Element img = XhtmlUtil.img(context.getURL(WikiContext.NONE, "images/attachment_small.png"), null);
                    link.addContent((Content)img);
                    col.addContent((Content)link);
                }
                row.addContent((Content)col);
                rt.addContent((Content)row);
                if (pageref instanceof Attachment) {
                    Element td = XhtmlUtil.element(XHTML.td, tfmt.format(lastmod));
                    td.setAttribute("class", "lastchange");
                    row.addContent((Content)td);
                } else {
                    Element infocol = XhtmlUtil.element(XHTML.td);
                    infocol.setAttribute("class", "lastchange");
                    infocol.addContent((Content)XhtmlUtil.link(context.getURL(WikiContext.DIFF, pageref.getName(), "r1=-1"), tfmt.format(lastmod)));
                    row.addContent((Content)infocol);
                }
                if (showAuthor) {
                    String author = pageref.getAuthor();
                    Element authorinfo = XhtmlUtil.element(XHTML.td);
                    authorinfo.setAttribute("class", "author");
                    if (author != null) {
                        if (engine.pageExists(author)) {
                            authorinfo.addContent((Content)XhtmlUtil.link(context.getURL(WikiContext.VIEW, author), author));
                        } else {
                            authorinfo.addContent(author);
                        }
                    } else {
                        authorinfo.addContent(Preferences.getBundle(context, "CoreResources").getString("common.unknownauthor"));
                    }
                    row.addContent((Content)authorinfo);
                }
                if (!showChangenote) continue;
                String changenote = (String)pageref.getAttribute("changenote");
                Element td_changenote = XhtmlUtil.element(XHTML.td, changenote);
                td_changenote.setAttribute("class", "changenote");
                row.addContent((Content)td_changenote);
            }
            return XhtmlUtil.serialize(rt, XhtmlUtil.EXPAND_EMPTY_NODES);
        }
        return "";
    }

    private boolean isSameDay(Date a, Date b) {
        Calendar aa = Calendar.getInstance();
        aa.setTime(a);
        Calendar bb = Calendar.getInstance();
        bb.setTime(b);
        return aa.get(1) == bb.get(1) && aa.get(6) == bb.get(6);
    }

    private DateFormat getTimeFormat(WikiContext context, Map<String, String> params) {
        String formatString = this.get(params, DEFAULT_TIME_FORMAT, PARAM_TIME_FORMAT);
        if (StringUtils.isBlank((String)formatString)) {
            return Preferences.getDateFormat(context, Preferences.TimeFormat.TIME);
        }
        return new SimpleDateFormat(formatString);
    }

    private DateFormat getDateFormat(WikiContext context, Map<String, String> params) {
        String formatString = this.get(params, DEFAULT_DATE_FORMAT, PARAM_DATE_FORMAT);
        if (StringUtils.isBlank((String)formatString)) {
            return Preferences.getDateFormat(context, Preferences.TimeFormat.DATE);
        }
        return new SimpleDateFormat(formatString);
    }

    private String get(Map<String, String> params, String defaultValue, String paramName) {
        String value = params.get(paramName);
        return value == null ? defaultValue : value;
    }
}

