/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.plugin;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.wiki.WikiContext;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.api.exceptions.PluginException;
import org.apache.wiki.api.exceptions.ProviderException;
import org.apache.wiki.api.plugin.WikiPlugin;
import org.apache.wiki.search.SearchResult;
import org.apache.wiki.util.XHTML;
import org.apache.wiki.util.XhtmlUtil;
import org.jdom2.Content;
import org.jdom2.Element;

public class Search
implements WikiPlugin {
    static Logger log = Logger.getLogger(Search.class);
    public static final String PARAM_QUERY = "query";
    public static final String PARAM_SET = "set";
    public static final String DEFAULT_SETNAME = "_defaultSet";
    public static final String PARAM_MAX = "max";

    @Override
    public String execute(WikiContext context, Map<String, String> params) throws PluginException {
        int maxItems = Integer.MAX_VALUE;
        Collection<SearchResult> results = null;
        String queryString = params.get(PARAM_QUERY);
        String set = params.get(PARAM_SET);
        String max = params.get(PARAM_MAX);
        if (set == null) {
            set = DEFAULT_SETNAME;
        }
        if (max != null) {
            maxItems = Integer.parseInt(max);
        }
        if (queryString == null) {
            results = (Collection<SearchResult>)context.getVariable(set);
        } else {
            try {
                results = this.doBasicQuery(context, queryString);
                context.setVariable(set, results);
            }
            catch (Exception e) {
                return "<div class='error'>" + e.getMessage() + "</div>\n";
            }
        }
        String res = "";
        if (results != null) {
            res = this.renderResults(results, context, maxItems);
        }
        return res;
    }

    private Collection<SearchResult> doBasicQuery(WikiContext context, String query) throws ProviderException, IOException {
        log.debug((Object)("Searching for string " + query));
        Collection<SearchResult> list = context.getEngine().getSearchManager().findPages(query, context);
        return list;
    }

    private String renderResults(Collection<SearchResult> results, WikiContext context, int maxItems) {
        WikiEngine engine = context.getEngine();
        Element table = XhtmlUtil.element(XHTML.table);
        table.setAttribute("class", "wikitable search-result");
        Element row = XhtmlUtil.element(XHTML.tr);
        table.addContent((Content)row);
        Element th1 = XhtmlUtil.element(XHTML.th, "Page");
        th1.setAttribute("width", "30%");
        th1.setAttribute("align", "left");
        row.addContent((Content)th1);
        Element th2 = XhtmlUtil.element(XHTML.th, "Score");
        th2.setAttribute("align", "left");
        row.addContent((Content)th2);
        int idx = 0;
        Iterator<SearchResult> i = results.iterator();
        while (i.hasNext() && idx++ <= maxItems) {
            SearchResult sr = i.next();
            row = XhtmlUtil.element(XHTML.tr);
            Element name = XhtmlUtil.element(XHTML.td);
            name.setAttribute("width", "30%");
            name.addContent((Content)XhtmlUtil.link(context.getURL(WikiContext.VIEW, sr.getPage().getName()), engine.beautifyTitle(sr.getPage().getName())));
            row.addContent((Content)name);
            row.addContent((Content)XhtmlUtil.element(XHTML.td, "" + sr.getScore()));
            table.addContent((Content)row);
        }
        if (results.isEmpty()) {
            row = XhtmlUtil.element(XHTML.tr);
            Element td = XhtmlUtil.element(XHTML.td);
            td.setAttribute("colspan", "2");
            Element b = XhtmlUtil.element(XHTML.b, "No results");
            td.addContent((Content)b);
            row.addContent((Content)td);
            table.addContent((Content)row);
        }
        return XhtmlUtil.serialize(table);
    }
}

