/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.plugin;

import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.apache.wiki.PageManager;
import org.apache.wiki.WikiContext;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.WikiPage;
import org.apache.wiki.api.exceptions.PluginException;
import org.apache.wiki.api.exceptions.ProviderException;
import org.apache.wiki.api.plugin.ParserStagePlugin;
import org.apache.wiki.api.plugin.WikiPlugin;
import org.apache.wiki.auth.AuthorizationManager;
import org.apache.wiki.auth.permissions.PagePermission;
import org.apache.wiki.parser.PluginContent;
import org.apache.wiki.preferences.Preferences;
import org.apache.wiki.util.TextUtil;

public class WeblogPlugin
implements WikiPlugin,
ParserStagePlugin {
    private static Logger log = Logger.getLogger(WeblogPlugin.class);
    private static final Pattern HEADINGPATTERN = Pattern.compile("(<h[1-4][^>]*>)(.*)(</h[1-4]>)", 2);
    private static final int DEFAULT_DAYS = 7;
    private static final String DEFAULT_PAGEFORMAT = "%p_blogentry_";
    public static final String DEFAULT_DATEFORMAT = "ddMMyy";
    public static final String PARAM_STARTDATE = "startDate";
    public static final String PARAM_ENTRYFORMAT = "entryFormat";
    public static final String PARAM_DAYS = "days";
    public static final String PARAM_ALLOWCOMMENTS = "allowComments";
    public static final String PARAM_MAXENTRIES = "maxEntries";
    public static final String PARAM_PAGE = "page";
    public static final String ATTR_ISWEBLOG = "weblogplugin.isweblog";

    public static String makeEntryPage(String pageName, String date, String entryNum) {
        return TextUtil.replaceString(DEFAULT_PAGEFORMAT, "%p", pageName) + date + "_" + entryNum;
    }

    public static String makeEntryPage(String pageName) {
        return TextUtil.replaceString(DEFAULT_PAGEFORMAT, "%p", pageName);
    }

    public static String makeEntryPage(String pageName, String date) {
        return TextUtil.replaceString(DEFAULT_PAGEFORMAT, "%p", pageName) + date;
    }

    @Override
    public String execute(WikiContext context, Map<String, String> params) throws PluginException {
        String days;
        int numDays = 7;
        WikiEngine engine = context.getEngine();
        AuthorizationManager mgr = engine.getAuthorizationManager();
        String startDay = null;
        boolean hasComments = false;
        String weblogName = params.get(PARAM_PAGE);
        if (weblogName == null) {
            weblogName = context.getPage().getName();
        }
        if ((days = context.getHttpParameter("weblog.days")) == null) {
            days = params.get(PARAM_DAYS);
        }
        SimpleDateFormat entryFormat = params.get(PARAM_ENTRYFORMAT) == null ? Preferences.getDateFormat(context, Preferences.TimeFormat.DATETIME) : new SimpleDateFormat(params.get(PARAM_ENTRYFORMAT));
        if (days != null) {
            numDays = days.equalsIgnoreCase("all") ? Integer.MAX_VALUE : TextUtil.parseIntParameter(days, 7);
        }
        if ((startDay = params.get(PARAM_STARTDATE)) == null) {
            startDay = context.getHttpParameter("weblog.startDate");
        }
        if (TextUtil.isPositive(params.get(PARAM_ALLOWCOMMENTS))) {
            hasComments = true;
        }
        int maxEntries = TextUtil.parseIntParameter(params.get(PARAM_MAXENTRIES), Integer.MAX_VALUE);
        Calendar startTime = Calendar.getInstance();
        Calendar stopTime = Calendar.getInstance();
        if (startDay != null) {
            SimpleDateFormat fmt = new SimpleDateFormat(DEFAULT_DATEFORMAT);
            try {
                Date d = fmt.parse(startDay);
                startTime.setTime(d);
                stopTime.setTime(d);
            }
            catch (ParseException e) {
                return "Illegal time format: " + startDay;
            }
        }
        context.getPage().setAttribute(ATTR_ISWEBLOG, "true");
        startTime.add(5, -numDays);
        startTime.set(10, 0);
        startTime.set(12, 0);
        startTime.set(13, 0);
        stopTime.set(10, 23);
        stopTime.set(12, 59);
        stopTime.set(13, 59);
        StringBuilder sb = new StringBuilder();
        try {
            List<WikiPage> blogEntries = this.findBlogEntries(engine, weblogName, startTime.getTime(), stopTime.getTime());
            Collections.sort(blogEntries, new PageDateComparator());
            sb.append("<div class=\"weblog\">\n");
            Iterator<WikiPage> i = blogEntries.iterator();
            while (i.hasNext() && maxEntries-- > 0) {
                WikiPage p = i.next();
                if (!mgr.checkPermission(context.getWikiSession(), new PagePermission(p, "view"))) continue;
                this.addEntryHTML(context, entryFormat, hasComments, sb, p);
            }
            sb.append("</div>\n");
        }
        catch (ProviderException e) {
            log.error((Object)"Could not locate blog entries", (Throwable)e);
            throw new PluginException("Could not locate blog entries: " + e.getMessage());
        }
        return sb.toString();
    }

    private void addEntryHTML(WikiContext context, DateFormat entryFormat, boolean hasComments, StringBuilder buffer, WikiPage entry) throws ProviderException {
        WikiEngine engine = context.getEngine();
        ResourceBundle rb = Preferences.getBundle(context, "plugin.PluginResources");
        buffer.append("<div class=\"weblogentry\">\n");
        buffer.append("<div class=\"weblogentryheading\">\n");
        Date entryDate = entry.getLastModified();
        buffer.append(entryFormat.format(entryDate));
        buffer.append("</div>\n");
        WikiContext entryCtx = (WikiContext)context.clone();
        entryCtx.setPage(entry);
        String html = engine.getHTML(entryCtx, engine.getPage(entry.getName()));
        buffer.append("<div class=\"weblogentrytitle\">\n");
        Matcher matcher = HEADINGPATTERN.matcher(html);
        if (matcher.find()) {
            String title = matcher.group(2);
            html = matcher.replaceFirst("");
            buffer.append(title);
        } else {
            buffer.append(entry.getName());
        }
        buffer.append("</div>\n");
        buffer.append("<div class=\"weblogentrybody\">\n");
        buffer.append(html);
        buffer.append("</div>\n");
        buffer.append("<div class=\"weblogentryfooter\">\n");
        String author = entry.getAuthor();
        if (author != null) {
            if (engine.pageExists(author)) {
                author = "<a href=\"" + entryCtx.getURL(WikiContext.VIEW, author) + "\">" + engine.beautifyTitle(author) + "</a>";
            }
        } else {
            author = "AnonymousCoward";
        }
        buffer.append(MessageFormat.format(rb.getString("weblogentryplugin.postedby"), author));
        buffer.append("<a href=\"" + entryCtx.getURL(WikiContext.VIEW, entry.getName()) + "\">" + rb.getString("weblogentryplugin.permalink") + "</a>");
        String commentPageName = TextUtil.replaceString(entry.getName(), "blogentry", "comments");
        if (hasComments) {
            int numComments = this.guessNumberOfComments(engine, commentPageName);
            buffer.append("&nbsp;&nbsp;");
            String addcomment = rb.getString("weblogentryplugin.addcomment");
            buffer.append("<a href=\"" + entryCtx.getURL(WikiContext.COMMENT, commentPageName, "nc=" + numComments) + "\">" + MessageFormat.format(addcomment, numComments) + "</a>");
        }
        buffer.append("</div>\n");
        buffer.append("</div>\n");
    }

    private int guessNumberOfComments(WikiEngine engine, String commentpage) throws ProviderException {
        String pagedata = engine.getPureText(commentpage, -1);
        if (pagedata == null || pagedata.trim().length() == 0) {
            return 0;
        }
        return TextUtil.countSections(pagedata);
    }

    public List<WikiPage> findBlogEntries(WikiEngine engine, String baseName, Date start, Date end) throws ProviderException {
        PageManager mgr = engine.getPageManager();
        Set<String> allPages = engine.getReferenceManager().findCreated();
        ArrayList<WikiPage> result = new ArrayList<WikiPage>();
        baseName = WeblogPlugin.makeEntryPage(baseName);
        for (String pageName : allPages) {
            if (!pageName.startsWith(baseName)) continue;
            try {
                WikiPage firstVersion = mgr.getPageInfo(pageName, 1);
                Date d = firstVersion.getLastModified();
                if (!d.after(start) || !d.before(end)) continue;
                result.add(firstVersion);
            }
            catch (Exception e) {
                log.debug((Object)("Page name :" + pageName + " was suspected as a blog entry but it isn't because of parsing errors"), (Throwable)e);
            }
        }
        return result;
    }

    @Override
    public void executeParser(PluginContent element, WikiContext context, Map<String, String> params) {
        context.getPage().setAttribute(ATTR_ISWEBLOG, "true");
    }

    private static class PageDateComparator
    implements Comparator<WikiPage> {
        private PageDateComparator() {
        }

        @Override
        public int compare(WikiPage page1, WikiPage page2) {
            if (page1 == null || page2 == null) {
                return 0;
            }
            return page2.getLastModified().compareTo(page1.getLastModified());
        }
    }
}

