/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.providers;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.wiki.InternalWikiException;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.WikiPage;
import org.apache.wiki.api.exceptions.NoRequiredPropertyException;
import org.apache.wiki.api.exceptions.ProviderException;
import org.apache.wiki.providers.WikiPageProvider;
import org.apache.wiki.search.QueryItem;
import org.apache.wiki.search.SearchMatcher;
import org.apache.wiki.search.SearchResult;
import org.apache.wiki.search.SearchResultComparator;
import org.apache.wiki.util.FileUtil;
import org.apache.wiki.util.TextUtil;

public abstract class AbstractFileProvider
implements WikiPageProvider {
    private static final Logger log = Logger.getLogger(AbstractFileProvider.class);
    private String m_pageDirectory = "/tmp/";
    protected String m_encoding;
    protected WikiEngine m_engine;
    public static final String PROP_CUSTOMPROP_MAXLIMIT = "custom.pageproperty.max.allowed";
    public static final String PROP_CUSTOMPROP_MAXKEYLENGTH = "custom.pageproperty.key.length";
    public static final String PROP_CUSTOMPROP_MAXVALUELENGTH = "custom.pageproperty.value.length";
    public static final int DEFAULT_MAX_PROPLIMIT = 200;
    public static final int DEFAULT_MAX_PROPKEYLENGTH = 255;
    public static final int DEFAULT_MAX_PROPVALUELENGTH = 4096;
    public static int MAX_PROPLIMIT = 200;
    public static int MAX_PROPKEYLENGTH = 255;
    public static int MAX_PROPVALUELENGTH = 4096;
    public static final String PROP_PAGEDIR = "jspwiki.fileSystemProvider.pageDir";
    public static final String FILE_EXT = ".txt";
    public static final String DEFAULT_ENCODING = StandardCharsets.ISO_8859_1.toString();
    private boolean m_windowsHackNeeded = false;
    private static final String[] WINDOWS_DEVICE_NAMES = new String[]{"con", "prn", "nul", "aux", "lpt1", "lpt2", "lpt3", "lpt4", "lpt5", "lpt6", "lpt7", "lpt8", "lpt9", "com1", "com2", "com3", "com4", "com5", "com6", "com7", "com8", "com9"};

    @Override
    public void initialize(WikiEngine engine, Properties properties) throws NoRequiredPropertyException, IOException, FileNotFoundException {
        log.debug((Object)"Initing FileSystemProvider");
        this.m_pageDirectory = TextUtil.getCanonicalFilePathProperty(properties, PROP_PAGEDIR, System.getProperty("user.home") + File.separator + "jspwiki-files");
        File f = new File(this.m_pageDirectory);
        if (!f.exists()) {
            if (!f.mkdirs()) {
                throw new IOException("Failed to create page directory " + f.getAbsolutePath() + " , please check property " + PROP_PAGEDIR);
            }
        } else {
            if (!f.isDirectory()) {
                throw new IOException("Page directory is not a directory: " + f.getAbsolutePath());
            }
            if (!f.canWrite()) {
                throw new IOException("Page directory is not writable: " + f.getAbsolutePath());
            }
        }
        this.m_engine = engine;
        this.m_encoding = properties.getProperty("jspwiki.encoding", DEFAULT_ENCODING);
        String os = System.getProperty("os.name").toLowerCase();
        if (os.startsWith("windows") || os.equals("nt")) {
            this.m_windowsHackNeeded = true;
        }
        if (properties != null) {
            MAX_PROPLIMIT = TextUtil.getIntegerProperty(properties, PROP_CUSTOMPROP_MAXLIMIT, 200);
            MAX_PROPKEYLENGTH = TextUtil.getIntegerProperty(properties, PROP_CUSTOMPROP_MAXKEYLENGTH, 255);
            MAX_PROPVALUELENGTH = TextUtil.getIntegerProperty(properties, PROP_CUSTOMPROP_MAXVALUELENGTH, 4096);
        }
        log.info((Object)("Wikipages are read from '" + this.m_pageDirectory + "'"));
    }

    String getPageDirectory() {
        return this.m_pageDirectory;
    }

    protected String mangleName(String pagename) {
        pagename = TextUtil.urlEncode(pagename, this.m_encoding);
        if ((pagename = TextUtil.replaceString(pagename, "/", "%2F")).startsWith(".")) {
            pagename = "%2E" + pagename.substring(1);
        }
        if (this.m_windowsHackNeeded) {
            String pn = pagename.toLowerCase();
            for (int i = 0; i < WINDOWS_DEVICE_NAMES.length; ++i) {
                if (!WINDOWS_DEVICE_NAMES[i].equals(pn)) continue;
                pagename = "$$$" + pagename;
            }
        }
        return pagename;
    }

    protected String unmangleName(String filename) {
        if (this.m_windowsHackNeeded && filename.startsWith("$$$") && filename.length() > 3) {
            filename = filename.substring(3);
        }
        return TextUtil.urlDecode(filename, this.m_encoding);
    }

    protected File findPage(String page) {
        return new File(this.m_pageDirectory, this.mangleName(page) + FILE_EXT);
    }

    @Override
    public boolean pageExists(String page) {
        File pagefile = this.findPage(page);
        return pagefile.exists();
    }

    @Override
    public boolean pageExists(String page, int version) {
        return this.pageExists(page);
    }

    @Override
    public String getPageText(String page, int version) throws ProviderException {
        return this.getPageText(page);
    }

    private String getPageText(String page) {
        String result = null;
        File pagedata = this.findPage(page);
        if (pagedata.exists()) {
            if (pagedata.canRead()) {
                try (FileInputStream in = new FileInputStream(pagedata);){
                    result = FileUtil.readContents(in, this.m_encoding);
                }
                catch (IOException e) {
                    log.error((Object)"Failed to read", (Throwable)e);
                }
            } else {
                log.warn((Object)("Failed to read page '" + page + "' from '" + pagedata.getAbsolutePath() + "', possibly a permissions problem"));
            }
        } else {
            log.info((Object)("New page '" + page + "'"));
        }
        return result;
    }

    @Override
    public void putPageText(WikiPage page, String text) throws ProviderException {
        File file = this.findPage(page.getName());
        try (PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), this.m_encoding));){
            out.print(text);
        }
        catch (IOException e) {
            log.error((Object)"Saving failed", (Throwable)e);
        }
    }

    @Override
    public Collection getAllPages() throws ProviderException {
        log.debug((Object)"Getting all pages...");
        ArrayList<WikiPage> set = new ArrayList<WikiPage>();
        File wikipagedir = new File(this.m_pageDirectory);
        File[] wikipages = wikipagedir.listFiles(new WikiFileFilter());
        if (wikipages == null) {
            log.error((Object)("Wikipages directory '" + this.m_pageDirectory + "' does not exist! Please check " + PROP_PAGEDIR + " in jspwiki.properties."));
            throw new InternalWikiException("Page directory does not exist");
        }
        for (int i = 0; i < wikipages.length; ++i) {
            int cutpoint;
            String wikiname = wikipages[i].getName();
            WikiPage page = this.getPageInfo(this.unmangleName(wikiname.substring(0, cutpoint = wikiname.lastIndexOf(FILE_EXT))), -1);
            if (page == null) {
                log.error((Object)("Page " + wikiname + " was found in directory listing, but could not be located individually."));
                continue;
            }
            set.add(page);
        }
        return set;
    }

    @Override
    public Collection getAllChangedSince(Date date) {
        return new ArrayList();
    }

    @Override
    public int getPageCount() {
        File wikipagedir = new File(this.m_pageDirectory);
        File[] wikipages = wikipagedir.listFiles(new WikiFileFilter());
        return wikipages.length;
    }

    @Override
    public Collection findPages(QueryItem[] query) {
        File wikipagedir = new File(this.m_pageDirectory);
        TreeSet<SearchResult> res = new TreeSet<SearchResult>(new SearchResultComparator());
        SearchMatcher matcher = new SearchMatcher(this.m_engine, query);
        File[] wikipages = wikipagedir.listFiles(new WikiFileFilter());
        for (int i = 0; i < wikipages.length; ++i) {
            String filename = wikipages[i].getName();
            int cutpoint = filename.lastIndexOf(FILE_EXT);
            String wikiname = filename.substring(0, cutpoint);
            wikiname = this.unmangleName(wikiname);
            try (FileInputStream input = new FileInputStream(wikipages[i]);){
                String pagetext = FileUtil.readContents(input, this.m_encoding);
                SearchResult comparison = matcher.matchPageContent(wikiname, pagetext);
                if (comparison == null) continue;
                res.add(comparison);
                continue;
            }
            catch (IOException e) {
                log.error((Object)("Failed to read " + filename), (Throwable)e);
            }
        }
        return res;
    }

    @Override
    public WikiPage getPageInfo(String page, int version) throws ProviderException {
        File file = this.findPage(page);
        if (!file.exists()) {
            return null;
        }
        WikiPage p = new WikiPage(this.m_engine, page);
        p.setLastModified(new Date(file.lastModified()));
        return p;
    }

    @Override
    public List<WikiPage> getVersionHistory(String page) throws ProviderException {
        ArrayList<WikiPage> list = new ArrayList<WikiPage>();
        list.add(this.getPageInfo(page, -1));
        return list;
    }

    @Override
    public String getProviderInfo() {
        return "";
    }

    @Override
    public void deleteVersion(String pageName, int version) throws ProviderException {
        if (version == -1) {
            File f = this.findPage(pageName);
            f.delete();
        }
    }

    @Override
    public void deletePage(String pageName) throws ProviderException {
        File f = this.findPage(pageName);
        f.delete();
    }

    protected void setCustomProperties(WikiPage page, Properties properties) {
        Enumeration<?> propertyNames = properties.propertyNames();
        while (propertyNames.hasMoreElements()) {
            String key = (String)propertyNames.nextElement();
            if (key.equals("author") || key.equals("changenote") || key.equals("viewcount")) continue;
            page.setAttribute(key, properties.get(key));
        }
    }

    protected void getCustomProperties(WikiPage page, Properties defaultProperties) throws IOException {
        Properties customPageProperties = this.addCustomProperties(page, defaultProperties);
        this.validateCustomPageProperties(customPageProperties);
        defaultProperties.putAll((Map<?, ?>)customPageProperties);
    }

    protected Properties addCustomProperties(WikiPage page, Properties props) {
        Properties customProperties = new Properties();
        if (page != null) {
            Map<String, Object> atts = page.getAttributes();
            for (String key : atts.keySet()) {
                Object value = atts.get(key);
                if (!key.startsWith("@") || value == null) continue;
                customProperties.put(key, value.toString());
            }
        }
        return customProperties;
    }

    protected void validateCustomPageProperties(Properties customProperties) throws IOException {
        if (customProperties != null && !customProperties.isEmpty()) {
            if (customProperties.size() > MAX_PROPLIMIT) {
                throw new IOException("Too many custom properties. You are adding " + customProperties.size() + ", but max limit is " + MAX_PROPLIMIT);
            }
            Enumeration<?> propertyNames = customProperties.propertyNames();
            while (propertyNames.hasMoreElements()) {
                String key = (String)propertyNames.nextElement();
                String value = (String)customProperties.get(key);
                if (key != null) {
                    if (key.length() > MAX_PROPKEYLENGTH) {
                        throw new IOException("Custom property key " + key + " is too long. Max allowed length is " + MAX_PROPKEYLENGTH);
                    }
                    if (!StringUtils.isAsciiPrintable((String)key)) {
                        throw new IOException("Custom property key " + key + " is not simple ASCII!");
                    }
                }
                if (value == null) continue;
                if (value.length() > MAX_PROPVALUELENGTH) {
                    throw new IOException("Custom property key " + key + " has value that is too long. Value=" + value + ". Max allowed length is " + MAX_PROPVALUELENGTH);
                }
                if (StringUtils.isAsciiPrintable((String)value)) continue;
                throw new IOException("Custom property key " + key + " has value that is not simple ASCII! Value=" + value);
            }
        }
    }

    public static class WikiFileFilter
    implements FilenameFilter {
        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(AbstractFileProvider.FILE_EXT);
        }
    }
}

