/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.render;

import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.util.Properties;
import java.util.Set;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.apache.log4j.Logger;
import org.apache.wiki.WikiContext;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.api.exceptions.WikiException;
import org.apache.wiki.event.WikiEvent;
import org.apache.wiki.event.WikiEventListener;
import org.apache.wiki.event.WikiEventUtils;
import org.apache.wiki.event.WikiPageEvent;
import org.apache.wiki.modules.InternalModule;
import org.apache.wiki.parser.JSPWikiMarkupParser;
import org.apache.wiki.parser.MarkupParser;
import org.apache.wiki.parser.WikiDocument;
import org.apache.wiki.render.WikiRenderer;
import org.apache.wiki.render.WysiwygEditingRenderer;
import org.apache.wiki.render.XHTMLRenderer;
import org.apache.wiki.util.ClassUtil;

public class RenderingManager
implements WikiEventListener,
InternalModule {
    private static Logger log = Logger.getLogger(RenderingManager.class);
    private int m_cacheExpiryPeriod = 86400;
    private WikiEngine m_engine;
    private boolean m_useCache = true;
    private CacheManager m_cacheManager = CacheManager.getInstance();
    private static final int DEFAULT_CACHESIZE = 1000;
    private static final String VERSION_DELIMITER = "::";
    private static final String PROP_PARSER = "jspwiki.renderingManager.markupParser";
    private static final String PROP_RENDERER = "jspwiki.renderingManager.renderer";
    private static final String PROP_WYSIWYG_RENDERER = "jspwiki.renderingManager.renderer.wysiwyg";
    public static final String DEFAULT_PARSER = JSPWikiMarkupParser.class.getName();
    public static final String DEFAULT_RENDERER = XHTMLRenderer.class.getName();
    public static final String DEFAULT_WYSIWYG_RENDERER = WysiwygEditingRenderer.class.getName();
    private Cache m_documentCache;
    public static final String DOCUMENTCACHE_NAME = "jspwiki.renderingCache";
    private Constructor<?> m_rendererConstructor;
    private Constructor<?> m_rendererWysiwygConstructor;
    private String m_markupParserClass = DEFAULT_PARSER;
    public static final String WYSIWYG_EDITOR_MODE = "WYSIWYG_EDITOR_MODE";
    public static final String VAR_EXECUTE_PLUGINS = "_PluginContent.execute";

    public void initialize(WikiEngine engine, Properties properties) throws WikiException {
        this.m_engine = engine;
        this.m_markupParserClass = properties.getProperty(PROP_PARSER, DEFAULT_PARSER);
        if (!ClassUtil.assignable(this.m_markupParserClass, MarkupParser.class.getName())) {
            log.warn((Object)(this.m_markupParserClass + " does not subclass " + MarkupParser.class.getName() + " reverting to default markup parser."));
            this.m_markupParserClass = DEFAULT_PARSER;
        }
        log.info((Object)("Using " + this.m_markupParserClass + " as markup parser."));
        this.m_useCache = "true".equals(properties.getProperty("jspwiki.usePageCache"));
        if (this.m_useCache) {
            String documentCacheName = engine.getApplicationName() + "." + DOCUMENTCACHE_NAME;
            if (this.m_cacheManager.cacheExists(documentCacheName)) {
                this.m_documentCache = this.m_cacheManager.getCache(documentCacheName);
            } else {
                log.info((Object)("cache with name " + documentCacheName + " not found in ehcache.xml, creating it with defaults."));
                this.m_documentCache = new Cache(documentCacheName, 1000, false, false, (long)this.m_cacheExpiryPeriod, (long)this.m_cacheExpiryPeriod);
                this.m_cacheManager.addCache(this.m_documentCache);
            }
        }
        String renderImplName = properties.getProperty(PROP_RENDERER, DEFAULT_RENDERER);
        String renderWysiwygImplName = properties.getProperty(PROP_WYSIWYG_RENDERER, DEFAULT_WYSIWYG_RENDERER);
        Class[] rendererParams = new Class[]{WikiContext.class, WikiDocument.class};
        this.m_rendererConstructor = this.initRenderer(renderImplName, rendererParams);
        this.m_rendererWysiwygConstructor = this.initRenderer(renderWysiwygImplName, rendererParams);
        log.info((Object)("Rendering content with " + renderImplName + "."));
        WikiEventUtils.addWikiEventListener(this.m_engine, 21, this);
    }

    private Constructor<?> initRenderer(String renderImplName, Class<?>[] rendererParams) throws WikiException {
        Constructor<?> c = null;
        try {
            Class<?> clazz = Class.forName(renderImplName);
            c = clazz.getConstructor(rendererParams);
        }
        catch (ClassNotFoundException e) {
            log.error((Object)("Unable to find WikiRenderer implementation " + renderImplName));
        }
        catch (SecurityException e) {
            log.error((Object)("Unable to access the WikiRenderer(WikiContext,WikiDocument) constructor for " + renderImplName));
        }
        catch (NoSuchMethodException e) {
            log.error((Object)("Unable to locate the WikiRenderer(WikiContext,WikiDocument) constructor for " + renderImplName));
        }
        if (c == null) {
            throw new WikiException("Failed to get WikiRenderer '" + renderImplName + "'.");
        }
        return c;
    }

    public MarkupParser getParser(WikiContext context, String pagedata) {
        try {
            return (MarkupParser)ClassUtil.getMappedObject(this.m_markupParserClass, context, new StringReader(pagedata));
        }
        catch (IllegalArgumentException | ReflectiveOperationException e) {
            log.error((Object)("unable to get an instance of " + this.m_markupParserClass + " (" + e.getMessage() + "), returning default markup parser."), (Throwable)e);
            return new JSPWikiMarkupParser(context, new StringReader(pagedata));
        }
    }

    protected WikiDocument getRenderedDocument(WikiContext context, String pagedata) throws IOException {
        WikiDocument doc;
        String pageid = context.getRealPage().getName() + VERSION_DELIMITER + context.getRealPage().getVersion() + VERSION_DELIMITER + context.getVariable(VAR_EXECUTE_PLUGINS);
        if (this.useCache(context)) {
            Element element = this.m_documentCache.get((Serializable)((Object)pageid));
            if (element != null) {
                doc = (WikiDocument)((Object)element.getObjectValue());
                if (pagedata.equals(doc.getPageData())) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Using cached HTML for page " + pageid));
                    }
                    return doc;
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("Re-rendering and storing " + pageid));
            }
        }
        try {
            MarkupParser parser = this.getParser(context, pagedata);
            doc = parser.parse();
            doc.setPageData(pagedata);
            if (this.useCache(context)) {
                this.m_documentCache.put(new Element((Serializable)((Object)pageid), (Serializable)((Object)doc)));
            }
            return doc;
        }
        catch (IOException ex) {
            log.error((Object)"Unable to parse", (Throwable)ex);
            return null;
        }
    }

    boolean useCache(WikiContext context) {
        return this.m_useCache && WikiContext.VIEW.equals(context.getRequestContext());
    }

    public String getHTML(WikiContext context, WikiDocument doc) throws IOException {
        Boolean wysiwygVariable = (Boolean)context.getVariable(WYSIWYG_EDITOR_MODE);
        boolean wysiwygEditorMode = wysiwygVariable != null ? wysiwygVariable : false;
        WikiRenderer rend = wysiwygEditorMode ? this.getWysiwygRenderer(context, doc) : this.getRenderer(context, doc);
        return rend.getString();
    }

    public WikiRenderer getRenderer(WikiContext context, WikiDocument doc) {
        Object[] params = new Object[]{context, doc};
        return this.getRenderer(params, this.m_rendererConstructor);
    }

    public WikiRenderer getWysiwygRenderer(WikiContext context, WikiDocument doc) {
        Object[] params = new Object[]{context, doc};
        return this.getRenderer(params, this.m_rendererWysiwygConstructor);
    }

    private <T extends WikiRenderer> T getRenderer(Object[] params, Constructor<?> rendererConstructor) {
        WikiRenderer rval = null;
        try {
            rval = (WikiRenderer)rendererConstructor.newInstance(params);
        }
        catch (Exception e) {
            log.error((Object)"Unable to create WikiRenderer", (Throwable)e);
        }
        return (T)rval;
    }

    public String getHTML(WikiContext context, String pagedata) {
        try {
            WikiDocument doc = this.getRenderedDocument(context, pagedata);
            return this.getHTML(context, doc);
        }
        catch (IOException e) {
            log.error((Object)"Unable to parse", (Throwable)e);
            return null;
        }
    }

    @Override
    public void actionPerformed(WikiEvent event) {
        log.debug((Object)("event received: " + event.toString()));
        if (this.m_useCache && event instanceof WikiPageEvent && event.getType() == 21 && this.m_documentCache != null) {
            String pageName = ((WikiPageEvent)event).getPageName();
            this.m_documentCache.remove((Serializable)((Object)pageName));
            Set<String> referringPages = this.m_engine.getReferenceManager().findReferrers(pageName);
            if (referringPages != null) {
                for (String page : referringPages) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Flushing latest version of " + page));
                    }
                    this.m_documentCache.remove((Serializable)((Object)(page + VERSION_DELIMITER + -1 + VERSION_DELIMITER + Boolean.FALSE)));
                    this.m_documentCache.remove((Serializable)((Object)(page + VERSION_DELIMITER + -1 + VERSION_DELIMITER + Boolean.TRUE)));
                    this.m_documentCache.remove((Serializable)((Object)(page + VERSION_DELIMITER + -1 + VERSION_DELIMITER + null)));
                }
            }
        }
    }
}

